/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro.declaration;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.core.macro.ActiveAnnotationContexts;
import org.eclipse.xtend.core.macro.ConditionUtils;
import org.eclipse.xtend.core.macro.declaration.JvmTypeParameterDeclarationImpl;
import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.MutableAnnotationTarget;
import org.eclipse.xtend.lib.macro.declaration.MutableTypeParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableTypeParameterDeclarator;
import org.eclipse.xtend.lib.macro.declaration.TypeParameterDeclarator;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.xbase.lib.Conversions;

public class MutableJvmTypeParameterDeclarationImpl
extends JvmTypeParameterDeclarationImpl
implements MutableAnnotationTarget,
MutableTypeParameterDeclaration {
    public void markAsRead() {
        this.checkMutable();
        this.getCompilationUnit().getReadAndWriteTracking().markReadAccess((EObject)this.getDelegate());
    }

    public MutableTypeParameterDeclarator getTypeParameterDeclarator() {
        TypeParameterDeclarator _typeParameterDeclarator = super.getTypeParameterDeclarator();
        return (MutableTypeParameterDeclarator)_typeParameterDeclarator;
    }

    public void setSimpleName(String name) {
        this.checkMutable();
        ConditionUtils.checkJavaIdentifier(name, "name");
        JvmTypeParameter _delegate = (JvmTypeParameter)this.getDelegate();
        _delegate.setName(name);
    }

    public void remove() {
        this.checkMutable();
        Resource _eResource = ((JvmTypeParameter)this.getDelegate()).eResource();
        boolean _tripleNotEquals = _eResource != null;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("This element has already been removed: ");
        JvmTypeParameter _delegate = (JvmTypeParameter)this.getDelegate();
        _builder.append((Object)_delegate);
        Preconditions.checkState((boolean)_tripleNotEquals, (Object)_builder);
        this.getCompilationUnit().getJvmModelAssociator().removeAllAssociation((EObject)this.getDelegate());
        EcoreUtil.remove((EObject)((EObject)this.getDelegate()));
        Resource _eResource_1 = ((JvmTypeParameter)this.getDelegate()).eResource();
        boolean _tripleEquals = _eResource_1 == null;
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("Couldn't remove: ");
        JvmTypeParameter _delegate_1 = (JvmTypeParameter)this.getDelegate();
        _builder_1.append((Object)_delegate_1);
        Preconditions.checkState((boolean)_tripleEquals, (Object)_builder_1);
    }

    public AnnotationReference addAnnotation(AnnotationReference annotationReference) {
        throw new UnsupportedOperationException("It is not possible to add an annotation.");
    }

    public boolean removeAnnotation(AnnotationReference annotationReference) {
        throw new UnsupportedOperationException("It is not possible to remove an annotation.");
    }

    public void setUpperBounds(Iterable<? extends TypeReference> upperBounds) {
        this.checkMutable();
        ConditionUtils.checkIterable(upperBounds, "upperBounds");
        ConditionUtils.checkInferredTypeReferences("parameter type", (TypeReference[])Conversions.unwrapArray(upperBounds, TypeReference.class));
        ((JvmTypeParameter)this.getDelegate()).getConstraints().clear();
        for (TypeReference typeReference : upperBounds) {
            JvmTypeReference typeRef = this.getCompilationUnit().toJvmTypeReference(typeReference);
            JvmUpperBound jvmUpperBound = TypesFactory.eINSTANCE.createJvmUpperBound();
            jvmUpperBound.setTypeReference(typeRef);
            ((JvmTypeParameter)this.getDelegate()).getConstraints().add((Object)jvmUpperBound);
        }
    }

    protected final void checkMutable() {
        boolean _notEquals;
        ActiveAnnotationContexts.AnnotationCallback _lastPhase = this.getCompilationUnit().getLastPhase();
        boolean bl = _notEquals = !Objects.equal((Object)((Object)_lastPhase), (Object)((Object)ActiveAnnotationContexts.AnnotationCallback.INFERENCE));
        if (_notEquals) {
            throw new IllegalStateException("Element cannot be modified outside the transformation phase");
        }
    }
}

