/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeExpectation;
import org.eclipse.xtext.xbase.typesystem.conformance.ConformanceFlags;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

public class TypeData {
    private final XExpression expression;
    private final ITypeExpectation expectation;
    private final LightweightTypeReference type;
    private int flags;
    private final boolean returnType;

    public TypeData(XExpression expression, ITypeExpectation expectation, LightweightTypeReference type, int flags, boolean returnType) {
        ConformanceFlags.sanityCheck(flags);
        this.expression = expression;
        this.expectation = expectation;
        this.type = type;
        this.flags = flags;
        this.returnType = returnType;
    }

    public boolean isOwnedBy(ITypeReferenceOwner owner) {
        return this.expectation.isOwnedBy(owner) && this.type.isOwnedBy(owner);
    }

    public String toString() {
        return "TypeData [expectation=" + this.expectation + ", type=" + this.type + ", flags=" + ConformanceFlags.toString(this.flags) + ", returnType=" + this.returnType + "]";
    }

    public ITypeExpectation getExpectation() {
        return this.expectation;
    }

    public int getConformanceFlags() {
        return this.flags;
    }

    public void setConformanceFlags(int flags) {
        ConformanceFlags.sanityCheck(flags);
        this.flags = flags;
    }

    public XExpression getExpression() {
        return this.expression;
    }

    public LightweightTypeReference getActualType() {
        return this.type;
    }

    public boolean isReturnType() {
        return this.returnType;
    }
}

