/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.contentassist;

import com.google.common.collect.Maps;
import com.google.inject.Provider;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension5;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.xtext.ui.editor.contentassist.ISmartContextInformation;
import org.eclipse.xtext.ui.editor.contentassist.PrefixMatcher;
import org.eclipse.xtext.ui.editor.hover.IEObjectHover;
import org.eclipse.xtext.util.Strings;

public class ConfigurableCompletionProposal
implements Comparable<ConfigurableCompletionProposal>,
ICompletionProposal,
ICompletionProposalExtension,
ICompletionProposalExtension2,
ICompletionProposalExtension3,
ICompletionProposalExtension4,
ICompletionProposalExtension5,
ICompletionProposalExtension6 {
    private static final Logger log = Logger.getLogger(ConfigurableCompletionProposal.class);
    private StyledString displayString;
    private String replacementString;
    private int replacementOffset;
    private int replacementLength;
    private int cursorPosition;
    private Image image;
    private IContextInformation contextInformation;
    private Object additionalProposalInfo;
    private IReplacementTextApplier textApplier;
    private IEObjectHover hover;
    private Map<String, Object> additionalData;
    private boolean autoInsertable = true;
    private int selectionLength = 0;
    private int selectionStart;
    private boolean linkedMode;
    private ITextViewer viewer;
    private char[] exitChars;
    private char[] triggerChars;
    private PrefixMatcher matcher;
    private int replaceContextLength;
    private int priority;
    private Resource contextResource;
    private Point rememberedSelection;

    public void setAdditionalData(String key, Object additionalData) {
        if (this.additionalData == null) {
            this.additionalData = Maps.newHashMap();
        }
        this.additionalData.put(key, additionalData);
    }

    public Object getAdditionalData(String key) {
        return this.additionalData != null ? this.additionalData.get(key) : null;
    }

    public ConfigurableCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition) {
        this(replacementString, replacementOffset, replacementLength, cursorPosition, null, null, null, null);
    }

    public ConfigurableCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, StyledString displayString, IContextInformation contextInformation, String additionalProposalInfo) {
        Assert.isNotNull((Object)replacementString);
        Assert.isTrue((replacementOffset >= 0 ? 1 : 0) != 0);
        Assert.isTrue((replacementLength >= 0 ? 1 : 0) != 0);
        Assert.isTrue((cursorPosition >= 0 ? 1 : 0) != 0);
        this.replacementString = replacementString;
        this.replacementOffset = replacementOffset;
        this.replacementLength = replacementLength;
        this.cursorPosition = cursorPosition;
        this.selectionStart = replacementOffset + cursorPosition;
        this.image = image;
        this.displayString = displayString == null ? new StyledString(this.replacementString) : displayString;
        this.contextInformation = contextInformation;
        this.additionalProposalInfo = additionalProposalInfo;
    }

    public void apply(IDocument document) {
        String original = document.get();
        try {
            if (this.getTextApplier() == null) {
                document.replace(this.getReplacementOffset(), this.getReplacementLength(), this.getReplacementString());
            } else {
                this.getTextApplier().apply(document, this);
            }
            if (this.linkedMode) {
                this.setUpLinkedMode(document);
            }
        }
        catch (Exception exc) {
            log.error((Object)"Error applying completion proposal", (Throwable)exc);
            document.set(original);
        }
    }

    public Point getSelection(IDocument document) {
        if (!this.linkedMode && this.getSelectionLength() == 0) {
            return new Point(this.getReplacementOffset() + this.getCursorPosition(), 0);
        }
        return new Point(this.getSelectionStart(), this.getSelectionLength());
    }

    public IContextInformation getContextInformation() {
        return this.contextInformation;
    }

    public Image getImage() {
        return this.image;
    }

    public String getDisplayString() {
        if (this.displayString != null) {
            return this.getStyledDisplayString().getString();
        }
        return this.replacementString;
    }

    public StyledString getStyledDisplayString() {
        return this.displayString;
    }

    public String getAdditionalProposalInfo() {
        if (this.additionalProposalInfo != null) {
            return this.additionalProposalInfo.toString();
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurableCompletionProposal)) {
            return false;
        }
        String otherDisplayString = ((ConfigurableCompletionProposal)obj).getDisplayString();
        return Strings.equal((String)otherDisplayString, (String)this.getDisplayString());
    }

    public int hashCode() {
        String displayString = this.getDisplayString();
        return displayString != null ? displayString.hashCode() : 31;
    }

    public boolean isAutoInsertable() {
        return this.autoInsertable;
    }

    public void setAutoInsertable(boolean autoInsertable) {
        this.autoInsertable = autoInsertable;
    }

    public String getReplacementString() {
        return this.replacementString;
    }

    public int getReplacementOffset() {
        return this.replacementOffset;
    }

    public int getReplacementLength() {
        return this.replacementLength;
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    public void setDisplayString(String displayString) {
        this.setDisplayString(new StyledString(displayString));
    }

    public void setDisplayString(StyledString displayString) {
        this.displayString = displayString;
    }

    public void setReplacementString(String replacementString) {
        this.replacementString = replacementString;
    }

    public void setReplacementOffset(int replacementOffset) {
        this.replacementOffset = replacementOffset;
    }

    public void setReplacementLength(int replacementLength) {
        this.replacementLength = replacementLength;
    }

    public void setCursorPosition(int cursorPosition) {
        this.cursorPosition = cursorPosition;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public void setContextInformation(IContextInformation contextInformation) {
        this.contextInformation = contextInformation;
    }

    public void setAdditionalProposalInfo(Object additionalProposalInfo) {
        this.additionalProposalInfo = additionalProposalInfo;
    }

    public void setProposalContextResource(Resource contextResource) {
        this.contextResource = contextResource;
    }

    public int getSelectionStart() {
        return this.selectionStart;
    }

    public int getSelectionLength() {
        return this.selectionLength;
    }

    public void setSelectionLength(int selectionLength) {
        this.selectionLength = selectionLength;
    }

    public void setSelectionStart(int selectionStart) {
        this.selectionStart = selectionStart;
    }

    public void shiftOffset(int deltaLength) {
        this.cursorPosition += deltaLength;
        this.selectionStart += deltaLength;
        if (this.contextInformation instanceof ISmartContextInformation) {
            ISmartContextInformation casted = (ISmartContextInformation)this.contextInformation;
            casted.setContextInformationPosition(casted.getContextInformationPosition() + deltaLength);
        }
    }

    public void setSimpleLinkedMode(ITextViewer viewer, char ... exitChars) {
        this.linkedMode = true;
        this.viewer = viewer;
        this.exitChars = exitChars;
    }

    protected boolean isLinkedMode() {
        return this.linkedMode;
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        boolean replaceRight;
        this.setReplacementLength(offset - this.getReplacementOffset() + viewer.getSelectedRange().y);
        boolean bl = replaceRight = (stateMask & 0x40000) != 0;
        if (replaceRight) {
            this.setReplacementLength(this.getReplaceContextLength());
        }
        this.apply(viewer.getDocument());
    }

    public void apply(IDocument document, char trigger, int offset) {
        this.setReplacementLength(offset - this.getReplacementOffset() + this.viewer.getSelectedRange().y);
        this.apply(this.viewer.getDocument());
    }

    public boolean isValidFor(IDocument document, int offset) {
        return this.validate(document, offset, null);
    }

    public int getContextInformationPosition() {
        if (this.getContextInformation() == null) {
            return -1;
        }
        return this.getReplacementOffset() + this.getCursorPosition();
    }

    public char[] getTriggerCharacters() {
        return this.triggerChars;
    }

    public void setTriggerCharacters(char[] triggerChars) {
        this.triggerChars = triggerChars;
    }

    private void updateSelection(ITextViewer viewer) {
        this.rememberedSelection = viewer.getSelectedRange();
        int offset = this.rememberedSelection.x;
        int length = this.getReplaceContextLength() - (offset - this.getReplacementOffset());
        viewer.setSelectedRange(offset, length);
    }

    private void restoreSelection(ITextViewer viewer) {
        if (this.rememberedSelection != null) {
            viewer.setSelectedRange(this.rememberedSelection.x, this.rememberedSelection.y);
        }
    }

    public void selected(ITextViewer viewer, boolean smartToggle) {
        if (smartToggle) {
            this.updateSelection(viewer);
        } else {
            this.restoreSelection(viewer);
            this.rememberedSelection = null;
        }
    }

    public void unselected(ITextViewer viewer) {
        this.restoreSelection(viewer);
        this.rememberedSelection = null;
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        if (event != null) {
            int oldReplaceContextLength = this.getReplaceContextLength();
            int diff = event.getText().length() - event.getLength();
            this.setReplaceContextLength(oldReplaceContextLength + diff);
        }
        try {
            String prefix = document.get(this.replacementOffset, offset - this.replacementOffset);
            return this.matcher.isCandidateMatchingPrefix(this.replacementString, prefix);
        }
        catch (BadLocationException e) {
            log.info((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public void setMatcher(PrefixMatcher matcher) {
        this.matcher = matcher;
    }

    public PrefixMatcher getMatcher() {
        return this.matcher;
    }

    public void setReplaceContextLength(int replaceContextLength) {
        this.replaceContextLength = replaceContextLength;
    }

    public int getReplaceContextLength() {
        return this.replaceContextLength;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int getPriority() {
        return this.priority;
    }

    @Override
    public int compareTo(ConfigurableCompletionProposal other) {
        if (this.priority < other.getPriority()) {
            return 1;
        }
        if (this.priority > other.getPriority()) {
            return -1;
        }
        return this.getDisplayString().compareTo(other.getDisplayString());
    }

    protected void setUpLinkedMode(IDocument document) {
        try {
            LinkedPositionGroup group = new LinkedPositionGroup();
            group.addPosition(new LinkedPosition(document, this.getSelectionStart(), this.getSelectionLength(), -1));
            LinkedModeModel model = new LinkedModeModel();
            model.addGroup(group);
            model.forceInstall();
            LinkedModeUI ui = new LinkedModeUI(model, this.viewer);
            ui.setExitPolicy((LinkedModeUI.IExitPolicy)new ExitPolicy(this.exitChars));
            ui.setExitPosition(this.viewer, this.getCursorPosition() + this.getReplacementOffset(), 0, Integer.MAX_VALUE);
            ui.setCyclingMode(LinkedModeUI.CYCLE_NEVER);
            ui.enter();
        }
        catch (BadLocationException e) {
            log.info((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void setTextApplier(IReplacementTextApplier textApplier) {
        this.textApplier = textApplier;
    }

    public IReplacementTextApplier getTextApplier() {
        return this.textApplier;
    }

    public IInformationControlCreator getInformationControlCreator() {
        if (this.hover != null && this.hover instanceof ITextHoverExtension) {
            return ((ITextHoverExtension)this.hover).getHoverControlCreator();
        }
        return null;
    }

    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        return this.getReplacementString();
    }

    public int getPrefixCompletionStart(IDocument document, int completionOffset) {
        return this.getReplacementOffset();
    }

    public void setHover(IEObjectHover hover) {
        this.hover = hover;
    }

    public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
        if (this.hover != null) {
            Object o;
            EObject eObject = null;
            if (this.additionalProposalInfo instanceof EObject) {
                eObject = (EObject)this.additionalProposalInfo;
            } else if (this.additionalProposalInfo instanceof Provider && (o = ((Provider)this.additionalProposalInfo).get()) instanceof EObject) {
                eObject = (EObject)o;
            }
            if (eObject != null) {
                if (eObject.eIsProxy()) {
                    eObject = EcoreUtil.resolve((EObject)eObject, (Resource)this.contextResource);
                }
                if (monitor.isCanceled()) {
                    return null;
                }
                return this.hover.getHoverInfo(eObject, this.viewer, null);
            }
        }
        return this.additionalProposalInfo != null ? this.additionalProposalInfo : null;
    }

    public String toString() {
        return "Proposal: " + this.getDisplayString();
    }

    protected static class ExitPolicy
    implements LinkedModeUI.IExitPolicy {
        private final char[] exitCharacters;

        public ExitPolicy(char[] exitCharacter) {
            this.exitCharacters = exitCharacter;
        }

        public LinkedModeUI.ExitFlags doExit(LinkedModeModel environment, VerifyEvent event, int offset, int length) {
            if (event.character == '\u0000') {
                return null;
            }
            char[] cArray = this.exitCharacters;
            int n = this.exitCharacters.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (event.character == c) {
                    return new LinkedModeUI.ExitFlags(2, false);
                }
                ++n2;
            }
            switch (event.character) {
                case '\r': {
                    return new LinkedModeUI.ExitFlags(2, false);
                }
            }
            return null;
        }
    }

    public static interface IReplacementTextApplier {
        public void apply(IDocument var1, ConfigurableCompletionProposal var2) throws BadLocationException;
    }
}

