/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.formatting;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.parsetree.reconstr.impl.NodeIterator;
import org.eclipse.xtext.xbase.formatting.CommentInfo;
import org.eclipse.xtext.xbase.formatting.HiddenLeafs;
import org.eclipse.xtext.xbase.formatting.LeafInfo;
import org.eclipse.xtext.xbase.formatting.NodeModelAccess;
import org.eclipse.xtext.xbase.formatting.WhitespaceInfo;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@Deprecated
public class HiddenLeafAccess {
    @Inject
    private NodeModelAccess nodeModelAccess;

    public HiddenLeafs getHiddenLeafsBefore(INode node) {
        ILeafNode start = this.nodeModelAccess.findNextLeaf(node, (Functions.Function1<? super ILeafNode, ? extends Boolean>)((Functions.Function1)l -> !l.isHidden()));
        List<ILeafNode> nodes = this.findPreviousHiddenLeafs((INode)start);
        int offset = 0;
        if (start != null) {
            offset = nodes.isEmpty() ? start.getOffset() : ((ILeafNode)IterableExtensions.head(nodes)).getOffset();
            return this.newHiddenLeafs(offset, nodes);
        }
        if (node != null) {
            offset = node.getOffset();
        }
        return new HiddenLeafs(offset);
    }

    protected HiddenLeafs newHiddenLeafs(int offset, List<ILeafNode> nodes) {
        HiddenLeafs result = new HiddenLeafs(offset);
        boolean trailing = true;
        for (ILeafNode node : nodes) {
            boolean comment = false;
            int newLines = 0;
            if (!Strings.isNullOrEmpty((String)node.getText())) {
                int i = 0;
                while (i < node.getText().length()) {
                    char c = node.getText().charAt(i);
                    if ('\n' == c) {
                        ++newLines;
                    } else if (!Character.isWhitespace(c)) {
                        comment = true;
                    }
                    ++i;
                }
            }
            if (comment) {
                if (!(IterableExtensions.last(result.getLeafs()) instanceof WhitespaceInfo)) {
                    result.getLeafs().add(new WhitespaceInfo(result, null, 0, node.getOffset()));
                }
                result.getLeafs().add(new CommentInfo(result, node, newLines, trailing));
            } else {
                result.getLeafs().add(new WhitespaceInfo(result, node, newLines, node.getOffset()));
            }
            if (newLines <= 0) continue;
            trailing = false;
        }
        if (!(IterableExtensions.last(result.getLeafs()) instanceof WhitespaceInfo)) {
            int whitespaceOffset = 0;
            whitespaceOffset = result.getLeafs().isEmpty() ? offset : ((LeafInfo)IterableExtensions.last(result.getLeafs())).getNode().getEndOffset();
            result.getLeafs().add(new WhitespaceInfo(result, null, 0, whitespaceOffset));
        }
        return result;
    }

    public HiddenLeafs getHiddenLeafsAfter(INode node) {
        ILeafNode start = this.findPreviousLeaf(node, (Functions.Function1<? super ILeafNode, ? extends Boolean>)((Functions.Function1)l -> !l.isHidden()));
        if (start != null) {
            return this.newHiddenLeafs(start.getEndOffset(), this.findNextHiddenLeafs((INode)start));
        }
        int offset = 0;
        if (node != null) {
            offset = node.getOffset();
        }
        return new HiddenLeafs(offset);
    }

    protected List<ILeafNode> findNextHiddenLeafs(INode node) {
        ArrayList<ILeafNode> result = new ArrayList<ILeafNode>();
        NodeIterator ni = new NodeIterator(node);
        while (ni.hasNext()) {
            INode next = ni.next();
            if (!(next instanceof ILeafNode)) continue;
            if (((ILeafNode)next).isHidden()) {
                result.add((ILeafNode)next);
                continue;
            }
            return result;
        }
        return result;
    }

    protected ILeafNode findPreviousLeaf(INode node, Functions.Function1<? super ILeafNode, ? extends Boolean> matches) {
        INode current = node;
        while (current instanceof ICompositeNode) {
            current = ((ICompositeNode)current).getLastChild();
        }
        if (current instanceof ILeafNode && ((Boolean)matches.apply((Object)((ILeafNode)current))).booleanValue()) {
            return (ILeafNode)current;
        }
        if (current != null) {
            NodeIterator ni = new NodeIterator(current);
            while (ni.hasPrevious()) {
                INode previous = ni.previous();
                if (!(previous instanceof ILeafNode) || !((Boolean)matches.apply((Object)((ILeafNode)previous))).booleanValue()) continue;
                return (ILeafNode)previous;
            }
        }
        return null;
    }

    protected List<ILeafNode> findPreviousHiddenLeafs(INode node) {
        INode current = node;
        while (current instanceof ICompositeNode) {
            current = ((ICompositeNode)current).getLastChild();
        }
        ArrayList<ILeafNode> result = new ArrayList<ILeafNode>();
        if (current != null) {
            NodeIterator ni = new NodeIterator(current);
            while (ni.hasPrevious()) {
                INode previous = ni.previous();
                if (Objects.equal((Object)previous, (Object)current) || !(previous instanceof ILeafNode)) continue;
                if (((ILeafNode)previous).isHidden()) {
                    result.add((ILeafNode)previous);
                    continue;
                }
                return ListExtensions.reverse(result);
            }
        }
        return ListExtensions.reverse(result);
    }
}

