/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2.debug;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatting;

public class HiddenRegionFormattingToString
implements Function<IHiddenRegionFormatting, String> {
    public String apply(IHiddenRegionFormatting gapFormatting) {
        String space = gapFormatting.getSpace();
        Integer nlMin = gapFormatting.getNewLineMin();
        Integer nlDefault = gapFormatting.getNewLineDefault();
        Integer nlMax = gapFormatting.getNewLineMax();
        Integer autowrap = gapFormatting.getAutowrap();
        Integer indentationIncrease = gapFormatting.getIndentationIncrease();
        Integer indentationDecrease = gapFormatting.getIndentationDecrease();
        ArrayList result = Lists.newArrayList();
        if (space != null) {
            result.add("space='" + space.replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t") + "'");
        }
        if (nlDefault != null && nlDefault.equals(nlMin) && nlDefault.equals(nlMax)) {
            result.add("newLine=" + nlDefault);
        } else if (nlMin != null || nlDefault != null || nlMax != null) {
            String x = HiddenRegionFormattingToString.firstNonNull(nlMin, "?") + "-" + HiddenRegionFormattingToString.firstNonNull(nlDefault, "?") + "-" + HiddenRegionFormattingToString.firstNonNull(nlMax, "?");
            result.add("newLine=" + x);
        }
        if (autowrap != null) {
            result.add(autowrap >= 0 ? "autowrap" + (String)(autowrap > 0 ? "(" + autowrap + ")" : "") : "noAutowrap");
        }
        if (indentationIncrease != null) {
            result.add("indentInc=" + indentationIncrease);
        }
        if (indentationDecrease != null) {
            result.add("indentDec=" + indentationDecrease);
        }
        return Joiner.on((String)";").join((Iterable)result);
    }

    private static <T> T firstNonNull(T first, T second) {
        return (T)(first != null ? first : Preconditions.checkNotNull(second));
    }
}

