/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.contentassist.javadoc;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.xtend.ide.contentassist.javadoc.XtendJavaDocState;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.xtext.ui.ITypesProposalProvider;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalFactory;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class XtendJavaDocCompletionProposalComputer
implements IUnitOfWork<ICompletionProposal[], XtextResource>,
ICompletionProposalAcceptor {
    private XtendJavaDocState protocol;
    private int offset;
    private ITextViewer viewer;
    private final Collection<ICompletionProposal> proposals;

    public XtendJavaDocCompletionProposalComputer(XtendJavaDocState protocol, ITextViewer viewer, int offset) {
        this.protocol = protocol;
        this.offset = offset;
        this.viewer = viewer;
        this.proposals = new LinkedHashSet<ICompletionProposal>(30);
    }

    public ICompletionProposal[] exec(XtextResource resource) throws Exception {
        ContentAssistContext contentAssistContext;
        List<ContentAssistContext> contexts = Arrays.asList(this.protocol.getContextFactory().create(this.viewer, this.offset, resource));
        if (contexts.size() > 0 && this.isValidPositionForTypeProposal(contentAssistContext = contexts.get(contexts.size() - 1))) {
            ITypesProposalProvider typesProposalProvider = this.protocol.getTypesProposalProvider();
            typesProposalProvider.createTypeProposals((ICompletionProposalFactory)this.protocol.getProposalFactory(), contentAssistContext, TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE, (ICompletionProposalAcceptor)this);
        }
        return this.proposals.toArray(new ICompletionProposal[this.proposals.size()]);
    }

    public void accept(ICompletionProposal proposal) {
        if (proposal == null) {
            return;
        }
        this.proposals.add(proposal);
    }

    public boolean canAcceptMoreProposals() {
        return true;
    }

    protected boolean isValidPositionForTypeProposal(ContentAssistContext contentAssistContext) {
        int offsetInNode;
        INode currentNode = contentAssistContext.getCurrentNode();
        String content = currentNode.getText();
        String textInFront = content.substring(0, offsetInNode = contentAssistContext.getOffset() - currentNode.getOffset() - contentAssistContext.getPrefix().length());
        int lastIndexOfLink = textInFront.lastIndexOf("@link ");
        if (lastIndexOfLink != -1 && textInFront.substring(lastIndexOfLink, offsetInNode).trim().equals("@link")) {
            return true;
        }
        int lastIndexOfSee = textInFront.lastIndexOf("@see ");
        return lastIndexOfSee != -1 && textInFront.substring(lastIndexOfSee, offsetInNode).trim().equals("@see");
    }
}

