/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.junit.typesystem;

import com.google.common.annotations.Beta;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.junit4.util.ParseHelper;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.util.ReflectExtensions;
import org.eclipse.xtext.xbase.typesystem.IBatchTypeResolver;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.CompoundReentrantTypeResolver;
import org.eclipse.xtext.xbase.typesystem.internal.RootResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.TypeData;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.junit.Assert;
import org.junit.ComparisonFailure;

@Deprecated
@Singleton
@Beta
public class Oven
extends Assert {
    @Inject
    private IBatchTypeResolver typeResolver;
    @Inject
    private ReflectExtensions reflectExtensions;
    @Inject
    private ParseHelper<EObject> parseHelper;

    public void fireproof(CharSequence input) throws Exception {
        this.fireproof(input.toString());
    }

    public void fireproof(String input) throws Exception {
        try {
            EObject file = this.parseHelper.parse((CharSequence)input);
            IResolvedTypes resolvedTypes = this.typeResolver.resolveTypes(file);
            Assert.assertNotNull((Object)resolvedTypes);
            if (file == null) {
                return;
            }
            for (EObject content : IteratorExtensions.toIterable((Iterator)file.eAllContents())) {
                if (content instanceof XAbstractFeatureCall) {
                    this.assertExpressionTypeIsResolved((XExpression)content, resolvedTypes);
                    XAbstractFeatureCall abstractFeatureCall = (XAbstractFeatureCall)content;
                    if (abstractFeatureCall.getImplicitReceiver() != null) {
                        this.assertExpressionTypeIsResolved(abstractFeatureCall.getImplicitReceiver(), resolvedTypes);
                    }
                    if (abstractFeatureCall.getImplicitFirstArgument() == null) continue;
                    this.assertExpressionTypeIsResolved(abstractFeatureCall.getImplicitFirstArgument(), resolvedTypes);
                    continue;
                }
                if (content instanceof XClosure) {
                    this.assertExpressionTypeIsResolved((XExpression)content, resolvedTypes);
                    ((XClosure)content).getImplicitFormalParameters().forEach(it -> this.assertIdentifiableTypeIsResolved((JvmIdentifiableElement)it, resolvedTypes));
                    continue;
                }
                if (content instanceof XExpression) {
                    this.assertExpressionTypeIsResolved((XExpression)content, resolvedTypes);
                    continue;
                }
                if (!(content instanceof JvmIdentifiableElement)) continue;
                this.assertIdentifiableTypeIsResolved((JvmIdentifiableElement)content, resolvedTypes);
            }
        }
        catch (Throwable e) {
            ComparisonFailure error = new ComparisonFailure(e.getMessage(), input, "");
            error.setStackTrace(e.getStackTrace());
            throw error;
        }
    }

    public void assertExpressionTypeIsResolved(XExpression expression, IResolvedTypes types) {
        try {
            Object type;
            Object internalTypes = this.reflectExtensions.invoke((Object)types, "delegate", new Object[0]);
            if (internalTypes instanceof CompoundReentrantTypeResolver) {
                Method method = CompoundReentrantTypeResolver.class.getDeclaredMethod("getDelegate", XExpression.class);
                method.setAccessible(true);
                Object delegate = method.invoke(internalTypes, expression);
                type = delegate instanceof RootResolvedTypes ? (TypeData)this.reflectExtensions.invoke(delegate, "getTypeData", new Object[]{expression, Boolean.FALSE}) : null;
            } else {
                type = (TypeData)this.reflectExtensions.invoke(internalTypes, "getTypeData", new Object[]{expression, Boolean.FALSE});
            }
            boolean assertion = false;
            assertion = expression instanceof XAbstractFeatureCall ? ((XAbstractFeatureCall)expression).isPackageFragment() || type != null : type != null;
            Assert.assertTrue((String)("Type is not resolved. Expression: " + expression.toString()), (boolean)assertion);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw Exceptions.sneakyThrow((Throwable)e);
        }
    }

    public void assertIdentifiableTypeIsResolved(JvmIdentifiableElement identifiable, IResolvedTypes types) {
        if (identifiable.getSimpleName() == null) {
            return;
        }
        LightweightTypeReference type = types.getActualType(identifiable);
        Assert.assertNotNull((String)identifiable.toString(), (Object)type);
        Assert.assertNotNull((String)(String.valueOf(identifiable.toString()) + " / " + type), (Object)type.getIdentifier());
    }
}

