/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.ui.query;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.ui.search.ElementQuerySpecification;
import org.eclipse.jdt.ui.search.IMatchPresentation;
import org.eclipse.jdt.ui.search.IQueryParticipant;
import org.eclipse.jdt.ui.search.ISearchRequestor;
import org.eclipse.jdt.ui.search.QuerySpecification;
import org.eclipse.xtext.common.types.access.jdt.TypeURIHelper;
import org.eclipse.xtext.common.types.ui.query.JavaSearchHelper;
import org.eclipse.xtext.common.types.ui.query.UIParticipant;
import org.eclipse.xtext.resource.IResourceDescriptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryParticipant
implements IQueryParticipant {
    private final TypeURIHelper typeURIHelper;
    private final UIParticipant uiParticipant;
    private Provider<IResourceDescriptions> resourceDescriptionsProvider;
    @Inject
    private Provider<JavaSearchHelper> javaSearchHelperProvider;

    @Inject
    public QueryParticipant(Provider<IResourceDescriptions> resourceDescriptionsProvider, UIParticipant uiParticipant) {
        this.resourceDescriptionsProvider = resourceDescriptionsProvider;
        this.uiParticipant = uiParticipant;
        this.typeURIHelper = new TypeURIHelper();
    }

    public void search(ISearchRequestor requestor, QuerySpecification query, IProgressMonitor monitor) throws CoreException {
        if (!this.isHandled(query)) {
            return;
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            ElementQuerySpecification elementQuery;
            IJavaElement element;
            URI uri;
            if (query instanceof ElementQuerySpecification && (uri = this.typeURIHelper.getFullURI(element = (elementQuery = (ElementQuerySpecification)query).getElement())) != null) {
                this.createSearchHelper(requestor).search(uri, monitor);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected JavaSearchHelper createSearchHelper(ISearchRequestor requestor) {
        JavaSearchHelper searchHelper = (JavaSearchHelper)this.javaSearchHelperProvider.get();
        IResourceDescriptions descriptionsToSearch = (IResourceDescriptions)this.resourceDescriptionsProvider.get();
        if (descriptionsToSearch.isEmpty()) {
            this.waitForBuild();
            descriptionsToSearch = (IResourceDescriptions)this.resourceDescriptionsProvider.get();
        }
        searchHelper.init(requestor, descriptionsToSearch);
        return searchHelper;
    }

    protected void waitForBuild() {
        boolean wasInterrupted = false;
        do {
            try {
                Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
                wasInterrupted = false;
            }
            catch (OperationCanceledException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                wasInterrupted = true;
            }
        } while (wasInterrupted);
    }

    public int estimateTicks(QuerySpecification query) {
        if (this.isHandled(query)) {
            return 250;
        }
        return 0;
    }

    public IMatchPresentation getUIParticipant() {
        return this.uiParticipant;
    }

    private boolean isHandled(QuerySpecification query) {
        switch (query.getLimitTo()) {
            case 2: 
            case 3: {
                break;
            }
            default: {
                return false;
            }
        }
        if (query instanceof ElementQuerySpecification) {
            IJavaElement element = ((ElementQuerySpecification)query).getElement();
            return element.getElementType() == 7 || element.getElementType() == 8 || element.getElementType() == 9;
        }
        return false;
    }
}

