/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.compiler;

import com.google.inject.Inject;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmDelegateTypeReference;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmMultiTypeReference;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.IRawTypeHelper;
import org.eclipse.xtext.common.types.util.ITypeArgumentContext;
import org.eclipse.xtext.common.types.util.TypeArgumentContextProvider;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.compiler.AbstractXbaseCompiler;
import org.eclipse.xtext.xbase.compiler.IAppendable;
import org.eclipse.xtext.xbase.compiler.Later;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.typing.Closures;

public class TypeConvertingCompiler
extends AbstractXbaseCompiler {
    @Inject
    private Closures closures;
    @Inject
    private TypeArgumentContextProvider contextProvider;
    @Inject
    private IRawTypeHelper rawTypeHelper;

    protected void internalToJavaExpression(XExpression obj, IAppendable appendable) {
        JvmTypeReference expectedType = this.getTypeProvider().getExpectedType(obj);
        this.internalToConvertedExpression(obj, appendable, expectedType);
    }

    protected void internalToConvertedExpression(final XExpression obj, final IAppendable appendable, JvmTypeReference toBeConvertedTo) {
        JvmTypeReference actualType;
        if (toBeConvertedTo != null && !EcoreUtil.equals((EObject)toBeConvertedTo, (EObject)(actualType = this.getTypeProvider().getType(obj)))) {
            this.doConversion(toBeConvertedTo, actualType, appendable, obj, new Later(){

                public void exec() {
                    String finalVariable = appendable.getName(Tuples.create((Object)"Convertable", (Object)obj));
                    if (finalVariable != null) {
                        appendable.append(finalVariable);
                    } else {
                        TypeConvertingCompiler.super.internalToJavaExpression(obj, appendable);
                    }
                }
            });
            return;
        }
        super.internalToJavaExpression(obj, appendable);
    }

    protected void doConversion(JvmTypeReference left, JvmTypeReference right, IAppendable appendable, XExpression context, Later expression) {
        if (this.getPrimitives().isPrimitive(left) && !this.getPrimitives().isPrimitive(right)) {
            this.convertWrapperToPrimitive(right, this.getPrimitives().asPrimitiveIfWrapperType(right), context, appendable, expression);
        } else if (this.getPrimitives().isPrimitive(right) && !this.getPrimitives().isPrimitive(left)) {
            this.convertPrimitiveToWrapper(right, this.getPrimitives().asWrapperTypeIfPrimitive(right), context, appendable, expression);
        } else if (right instanceof JvmMultiTypeReference) {
            this.convertMultiType(left, (JvmMultiTypeReference)right, context, appendable, expression);
        } else if (right instanceof JvmDelegateTypeReference) {
            this.doConversion(left, ((JvmDelegateTypeReference)right).getDelegate(), appendable, context, expression);
        } else if (this.getTypeReferences().isArray(right) && this.isList(left)) {
            this.convertArrayToList(left, appendable, context, expression);
        } else if (this.isList(right) && this.getTypeReferences().isArray(left)) {
            this.convertListToArray(left, appendable, context, expression);
        } else if (this.isFunction(right)) {
            this.convertFunctionType(left, right, appendable, expression, context);
        } else if (this.isProcedure(right)) {
            this.convertFunctionType(left, right, appendable, expression, context);
        } else {
            expression.exec();
        }
    }

    protected boolean isFunction(JvmTypeReference typeReference) {
        return this.identifierStartWith(typeReference, Functions.class.getCanonicalName());
    }

    protected boolean isProcedure(JvmTypeReference typeReference) {
        return this.identifierStartWith(typeReference, Procedures.class.getCanonicalName());
    }

    protected boolean identifierStartWith(JvmTypeReference typeReference, String prefix) {
        if (typeReference == null || typeReference.getType() == null) {
            return false;
        }
        String identifier = typeReference.getType().getIdentifier();
        if (identifier != null) {
            return identifier.startsWith(prefix);
        }
        return false;
    }

    protected void convertMultiType(JvmTypeReference expectation, JvmMultiTypeReference multiType, XExpression context, IAppendable b, Later expression) {
        JvmTypeReference castTo = null;
        for (JvmTypeReference candidate : multiType.getReferences()) {
            if (!this.getTypeConformanceComputer().isConformant(expectation, candidate, true)) continue;
            castTo = candidate;
            break;
        }
        if (castTo != null) {
            b.append("((");
            this.serialize(castTo, context, b, true, false);
            b.append(")");
        }
        expression.exec();
        if (castTo != null) {
            b.append(")");
        }
    }

    protected void convertFunctionType(JvmTypeReference expectedType, final JvmTypeReference functionType, IAppendable appendable, Later expression, XExpression context) {
        String name;
        JvmFormalParameter p;
        if (expectedType == null || expectedType.getIdentifier().equals(Object.class.getName()) || EcoreUtil.equals((EObject)expectedType.getType(), (EObject)functionType.getType())) {
            expression.exec();
            return;
        }
        JvmOperation operation = this.closures.findImplementingOperation(expectedType, context.eResource());
        if (operation == null) {
            throw new IllegalStateException("expected type " + expectedType + " not mappable from " + functionType);
        }
        JvmDeclaredType declaringType = operation.getDeclaringType();
        final JvmParameterizedTypeReference typeReferenceWithPlaceHolder = this.getTypeReferences().createTypeRef((JvmType)declaringType, new JvmTypeReference[0]);
        ITypeArgumentContext typeArgumentContext = this.contextProvider.getTypeArgumentContext((TypeArgumentContextProvider.Request)new TypeArgumentContextProvider.AbstractRequest(){

            public JvmTypeReference getExpectedType() {
                return functionType;
            }

            public JvmTypeReference getDeclaredType() {
                return typeReferenceWithPlaceHolder;
            }

            public String toString() {
                return "TypeConvertingCompiler.convertFunctionType [expected=" + functionType + ",declared=" + typeReferenceWithPlaceHolder + "]";
            }
        });
        JvmTypeReference resolvedExpectedType = typeArgumentContext.resolve((JvmTypeReference)typeReferenceWithPlaceHolder);
        appendable.append("new ");
        this.serialize(resolvedExpectedType, null, appendable, true, false);
        appendable.append("() {");
        appendable.increaseIndentation().increaseIndentation();
        appendable.append("\npublic ");
        this.serialize(typeArgumentContext.resolve(operation.getReturnType()), null, appendable, true, false);
        appendable.append(" ").append(operation.getSimpleName()).append("(");
        EList params = operation.getParameters();
        Iterator iterator = params.iterator();
        while (iterator.hasNext()) {
            p = (JvmFormalParameter)iterator.next();
            name = p.getName();
            this.serialize(typeArgumentContext.resolve(p.getParameterType()), null, appendable, true, false);
            appendable.append(" ").append(name);
            if (!iterator.hasNext()) continue;
            appendable.append(",");
        }
        appendable.append(") {");
        appendable.increaseIndentation();
        if (!this.getTypeReferences().is(operation.getReturnType(), Void.TYPE)) {
            appendable.append("\nreturn ");
        } else {
            appendable.append("\n");
        }
        expression.exec();
        appendable.append(".apply(");
        iterator = params.iterator();
        while (iterator.hasNext()) {
            p = (JvmFormalParameter)iterator.next();
            name = p.getName();
            appendable.append(name);
            if (!iterator.hasNext()) continue;
            appendable.append(",");
        }
        appendable.append(");");
        appendable.decreaseIndentation();
        appendable.append("\n}");
        appendable.decreaseIndentation().decreaseIndentation();
        appendable.append("\n}");
    }

    protected void convertListToArray(JvmTypeReference arrayTypeReference, IAppendable appendable, XExpression context, Later expression) {
        appendable.append("((");
        this.serialize(arrayTypeReference, context, appendable);
        appendable.append(")");
        JvmTypeReference conversions = this.getTypeReferences().getTypeForName(Conversions.class, (EObject)context, new JvmTypeReference[0]);
        this.serialize(conversions, context, appendable);
        appendable.append(".unwrapArray(");
        expression.exec();
        JvmGenericArrayTypeReference rawTypeArrayReference = (JvmGenericArrayTypeReference)this.rawTypeHelper.getRawTypeReference(arrayTypeReference, context.eResource());
        appendable.append(", ");
        this.serialize(rawTypeArrayReference.getComponentType(), context, appendable);
        appendable.append(".class))");
    }

    protected void convertArrayToList(JvmTypeReference left, IAppendable appendable, XExpression context, Later expression) {
        appendable.append("((");
        this.serialize(left, context, appendable);
        appendable.append(")");
        JvmTypeReference conversions = this.getTypeReferences().getTypeForName(Conversions.class, (EObject)context, new JvmTypeReference[0]);
        this.serialize(conversions, context, appendable);
        appendable.append(".doWrapArray(");
        expression.exec();
        appendable.append("))");
    }

    protected void convertPrimitiveToWrapper(JvmTypeReference primitive, JvmTypeReference wrapper, XExpression context, IAppendable appendable, Later expression) {
        this.serialize(wrapper, null, appendable);
        appendable.append(".");
        appendable.append("valueOf(");
        expression.exec();
        appendable.append(")");
    }

    protected void convertWrapperToPrimitive(JvmTypeReference wrapper, JvmTypeReference primitive, XExpression context, IAppendable appendable, Later expression) {
        appendable.append("(");
        expression.exec();
        appendable.append(")");
        appendable.append(".");
        this.serialize(primitive, null, appendable);
        appendable.append("Value(");
        appendable.append(")");
    }

    protected boolean isList(JvmTypeReference type) {
        TypeReferences typeRefs = this.getTypeReferences();
        return typeRefs.isInstanceOf(type, Iterable.class);
    }

    protected TypeArgumentContextProvider getContextProvider() {
        return this.contextProvider;
    }
}

