/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.compiler;

import java.util.List;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.xbase.compiler.IAppendable;
import org.eclipse.xtext.xbase.compiler.ImportManager;
import org.eclipse.xtext.xbase.compiler.ScopeStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringBuilderBasedAppendable
implements IAppendable {
    private StringBuilder builder = new StringBuilder(8192);
    private int indentationlevel = 0;
    private String indentation = "  ";
    private ImportManager importManager;
    private ScopeStack scopes = new ScopeStack();

    @Override
    public IAppendable append(JvmType type) {
        this.appendType(type);
        return this;
    }

    @Override
    public IAppendable append(String string) {
        String replaced = string.replace("\n", this.getIndentationString());
        this.builder.append(replaced);
        return this;
    }

    protected CharSequence getIndentationString() {
        StringBuilder sb = new StringBuilder(10);
        sb.append("\n");
        int i = 0;
        while (i < this.indentationlevel) {
            sb.append(this.indentation);
            ++i;
        }
        return sb.toString();
    }

    public String toString() {
        return this.builder.toString();
    }

    @Override
    public IAppendable increaseIndentation() {
        ++this.indentationlevel;
        return this;
    }

    @Override
    public IAppendable decreaseIndentation() {
        if (this.indentationlevel == 0) {
            throw new IllegalStateException("Can't reduce indentation level. It's already zero.");
        }
        --this.indentationlevel;
        return this;
    }

    public void setScopeStack(ScopeStack scopes) {
        this.scopes = scopes;
    }

    public StringBuilderBasedAppendable(ImportManager typeSerializer, String indentation) {
        this.importManager = typeSerializer;
        this.indentation = indentation;
        this.openScope();
    }

    public StringBuilderBasedAppendable(ImportManager typeSerializer) {
        this.importManager = typeSerializer;
        this.openScope();
    }

    public StringBuilderBasedAppendable() {
        this(new ImportManager(false));
    }

    @Override
    public void openScope() {
        this.scopes.openScope(false);
    }

    @Override
    public void openPseudoScope() {
        this.scopes.openScope(true);
    }

    @Override
    public String declareVariable(Object key, String proposedName) {
        return this.scopes.declareVariable(key, proposedName, false);
    }

    @Override
    public String declareSyntheticVariable(Object key, String proposedName) {
        return this.scopes.declareVariable(key, proposedName, true);
    }

    @Override
    public void closeScope() {
        this.scopes.closeScope();
    }

    protected void appendType(JvmType type) {
        this.importManager.appendType(type, this.builder);
    }

    @Override
    public List<String> getImports() {
        return this.importManager.getImports();
    }

    protected ImportManager getImportManager() {
        return this.importManager;
    }

    @Override
    public String getName(Object key) {
        return this.scopes.getName(key);
    }

    @Override
    public Object getObject(String name) {
        return this.scopes.get(name);
    }
}

