/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.impl;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.access.JvmTypeChangeDispatcher;
import org.eclipse.xtext.common.types.impl.JvmDeclaredTypeImpl;
import org.eclipse.xtext.common.types.util.RawTypeHelper;
import org.eclipse.xtext.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JvmDeclaredTypeImplCustom
extends JvmDeclaredTypeImpl {
    protected Map<String, Set<JvmFeature>> allFeaturesByName;
    protected Set<String> removedOverridden = Sets.newHashSet();
    protected Set<JvmFeature> allFeatures;

    @Override
    public String getPackageName() {
        JvmDeclaredType declaringType = this.getDeclaringType();
        if (declaringType != null) {
            return declaringType.getPackageName();
        }
        return this.packageName;
    }

    @Override
    protected String computeIdentifier() {
        if (this.simpleName == null) {
            return null;
        }
        JvmDeclaredType declaringType = this.getDeclaringType();
        if (declaringType == null) {
            if (Strings.isEmpty((String)this.packageName)) {
                return this.simpleName;
            }
            return String.valueOf(this.packageName) + "." + this.simpleName;
        }
        String parentName = declaringType.getIdentifier();
        if (parentName == null) {
            return null;
        }
        return String.valueOf(parentName) + '$' + this.simpleName;
    }

    @Override
    public String getQualifiedName(char innerClassDelimiter) {
        if (this.simpleName == null) {
            return null;
        }
        JvmDeclaredType declaringType = this.getDeclaringType();
        if (declaringType == null) {
            if (Strings.isEmpty((String)this.packageName)) {
                return this.simpleName;
            }
            return String.valueOf(this.packageName) + "." + this.simpleName;
        }
        String parentName = declaringType.getQualifiedName(innerClassDelimiter);
        if (parentName == null) {
            return null;
        }
        return String.valueOf(parentName) + innerClassDelimiter + this.simpleName;
    }

    @Override
    public Iterable<JvmField> getDeclaredFields() {
        return Iterables.filter(this.getMembers(), JvmField.class);
    }

    @Override
    public Iterable<JvmOperation> getDeclaredOperations() {
        return Iterables.filter(this.getMembers(), JvmOperation.class);
    }

    @Override
    public Iterable<JvmFeature> findAllFeaturesByName(String simpleName) {
        Map<String, Set<JvmFeature>> allFeaturesByName = this.getAllFeaturesMap();
        Set<JvmFeature> result = allFeaturesByName.get(simpleName);
        if (result != null) {
            if (result.size() <= 1 || this.removedOverridden.contains(simpleName)) {
                return result;
            }
            HashSet signatures = Sets.newHashSet();
            Iterator<JvmFeature> iter = result.iterator();
            while (iter.hasNext()) {
                JvmFeature next = iter.next();
                if (next instanceof JvmOperation) {
                    EList<JvmFormalParameter> parameters = ((JvmOperation)next).getParameters();
                    StringBuilder signature = new StringBuilder(next.getSimpleName());
                    if (parameters.isEmpty()) {
                        signature.append("()");
                    } else {
                        signature.append("(");
                        for (JvmFormalParameter parameter : parameters) {
                            JvmType parameterType = this.getRawType(parameter.getParameterType());
                            if (parameterType == null) continue;
                            signature.append(parameterType.getIdentifier());
                            signature.append(",");
                        }
                        signature.replace(signature.length() - 1, signature.length(), ")");
                    }
                    if (signatures.add(signature.toString())) continue;
                    iter.remove();
                    continue;
                }
                if (!(next instanceof JvmField) || signatures.add(next.getSimpleName())) continue;
                iter.remove();
            }
            this.removedOverridden.add(simpleName);
            return result;
        }
        return Collections.emptyList();
    }

    protected Map<String, Set<JvmFeature>> getAllFeaturesMap() {
        HashSet processedSuperTypes = Sets.newHashSet();
        return this.internalGetAllFeaturesMap(processedSuperTypes);
    }

    protected Map<String, Set<JvmFeature>> internalGetAllFeaturesMap(Set<JvmDeclaredType> processedSuperTypes) {
        LinkedHashMap result = this.allFeaturesByName;
        if (result == null) {
            result = Maps.newLinkedHashMap();
            this.processMembers(result, (Collection<? extends JvmMember>)this.getMembers());
            for (JvmTypeReference superTypeReference : this.getSuperTypes()) {
                JvmType superType = this.getRawType(superTypeReference);
                if (!(superType instanceof JvmDeclaredTypeImplCustom) || superType.eIsProxy() || processedSuperTypes.contains(superType)) continue;
                processedSuperTypes.add((JvmDeclaredType)superType);
                Map<String, Set<JvmFeature>> superTypeFeatureMap = ((JvmDeclaredTypeImplCustom)superType).internalGetAllFeaturesMap(processedSuperTypes);
                processedSuperTypes.remove(superType);
                for (Set<JvmFeature> features : superTypeFeatureMap.values()) {
                    this.processMembers(result, features);
                }
            }
            Runnable runnable = new Runnable(){

                public void run() {
                    JvmDeclaredTypeImplCustom.this.removedOverridden.clear();
                    JvmDeclaredTypeImplCustom.this.allFeaturesByName = null;
                }
            };
            this.requestNotificationOnChange(runnable);
            this.allFeaturesByName = result;
        }
        return result;
    }

    protected void requestNotificationOnChange(Runnable listener) {
        Resource resource = this.eResource();
        JvmDeclaredTypeImplCustom notifier = this;
        if (resource != null) {
            notifier = resource.getResourceSet() != null ? resource.getResourceSet() : resource;
        }
        JvmTypeChangeDispatcher dispatcher = JvmTypeChangeDispatcher.findResourceChangeDispatcher((Notifier)notifier);
        dispatcher.requestNotificationOnChange((Notifier)this, listener);
    }

    protected void processMembers(Map<String, Set<JvmFeature>> result, Collection<? extends JvmMember> members) {
        for (JvmMember jvmMember : members) {
            Set<JvmFeature> knownMembers;
            if (jvmMember instanceof JvmOperation) {
                knownMembers = result.get(jvmMember.getSimpleName());
                if (knownMembers == null) {
                    knownMembers = new LinkedHashSet<JvmFeature>(2);
                    result.put(jvmMember.getSimpleName(), knownMembers);
                }
                knownMembers.add((JvmFeature)jvmMember);
                continue;
            }
            if (!(jvmMember instanceof JvmField)) continue;
            knownMembers = result.get(jvmMember.getSimpleName());
            if (knownMembers == null) {
                knownMembers = new LinkedHashSet<JvmFeature>(2);
                result.put(jvmMember.getSimpleName(), knownMembers);
            }
            knownMembers.add((JvmFeature)jvmMember);
        }
    }

    @Override
    public Iterable<JvmFeature> getAllFeatures() {
        if (this.allFeatures == null) {
            LinkedHashSet result = Sets.newLinkedHashSet();
            Map<String, Set<JvmFeature>> allFeaturesMap = this.getAllFeaturesMap();
            for (String name : allFeaturesMap.keySet()) {
                Iterables.addAll((Collection)result, this.findAllFeaturesByName(name));
            }
            Runnable runnable = new Runnable(){

                public void run() {
                    JvmDeclaredTypeImplCustom.this.allFeatures = null;
                }
            };
            this.requestNotificationOnChange(runnable);
            this.allFeatures = result;
        }
        return this.allFeatures;
    }

    protected JvmType getRawType(JvmTypeReference reference) {
        RawTypeHelper.RawTypeReferenceImplementation strategy = new RawTypeHelper.RawTypeReferenceImplementation(TypesFactory.eINSTANCE);
        JvmTypeReference result = strategy.getRawTypeReference(reference, this.eResource());
        return result.getType();
    }
}

