/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.serializer.analysis;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Singleton;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.grammaranalysis.impl.CfgAdapter;
import org.eclipse.xtext.serializer.analysis.IContextPDAProvider;
import org.eclipse.xtext.serializer.analysis.ISerState;
import org.eclipse.xtext.serializer.analysis.SerializerPDA;
import org.eclipse.xtext.util.formallang.Cfg;
import org.eclipse.xtext.util.formallang.FollowerFunction;
import org.eclipse.xtext.util.formallang.FollowerFunctionImpl;
import org.eclipse.xtext.util.formallang.Nfa;
import org.eclipse.xtext.util.formallang.NfaUtil;
import org.eclipse.xtext.util.formallang.Pda;
import org.eclipse.xtext.util.formallang.PdaFactory;
import org.eclipse.xtext.util.formallang.PdaUtil;
import org.eclipse.xtext.util.formallang.Production;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class ContextPDAProvider
implements IContextPDAProvider {
    protected Map<EObject, Pda<ISerState, RuleCall>> cache = Maps.newHashMap();

    protected Pda<ISerState, RuleCall> createPDA(EObject context) {
        SerializerCfg cfg = new SerializerCfg(context);
        SerializerFollowerFunction ff = new SerializerFollowerFunction((Production<AbstractElement, AbstractElement>)cfg, context);
        Pda pda = new PdaUtil().create((Cfg)cfg, (FollowerFunction)ff, (PdaFactory)new SerializerPDA.SerializerPDAElementFactory());
        new NfaUtil().removeOrphans((Nfa)pda);
        return pda;
    }

    @Override
    public Pda<ISerState, RuleCall> getContextPDA(EObject context) {
        Pda<ISerState, RuleCall> result = this.cache.get(context);
        if (result == null) {
            result = this.createPDA(context);
            this.cache.put(context, result);
        }
        return result;
    }

    protected static class SerializerCfg
    extends CfgAdapter {
        protected EObject context;

        public SerializerCfg(EObject context) {
            super(GrammarUtil.getGrammar(context));
            this.context = context;
        }

        public AbstractElement getCall(AbstractElement ele) {
            if (ele instanceof RuleCall && !GrammarUtil.isAssigned(ele) && ((RuleCall)ele).getRule().getType().getClassifier() instanceof EClass) {
                return ((RuleCall)ele).getRule().getAlternatives();
            }
            return null;
        }

        public AbstractElement getRoot() {
            if (this.context instanceof AbstractRule) {
                return ((AbstractRule)this.context).getAlternatives();
            }
            if (this.context instanceof Action) {
                return GrammarUtil.containingRule(this.context).getAlternatives();
            }
            return super.getRoot();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SerializerFollowerFunction
    extends FollowerFunctionImpl<AbstractElement, AbstractElement> {
        protected Action actionCtx;
        protected AbstractRule ruleCtx;

        public SerializerFollowerFunction(Production<AbstractElement, AbstractElement> production, EObject context) {
            super(production);
            this.actionCtx = context instanceof Action ? (Action)context : null;
            this.ruleCtx = context instanceof AbstractRule ? (AbstractRule)context : null;
        }

        public Iterable<AbstractElement> getFollowers(AbstractElement element) {
            LinkedHashSet result = Sets.newLinkedHashSet();
            for (AbstractElement ele : super.getFollowers((Object)element)) {
                if (ele == null) {
                    if (!this.isStop(element)) continue;
                    result.add(null);
                    continue;
                }
                if (this.actionCtx == ele) {
                    result.add(null);
                    continue;
                }
                if (GrammarUtil.isAssignedAction(ele)) continue;
                result.add(ele);
            }
            return result;
        }

        public Iterable<AbstractElement> getStarts(AbstractElement root) {
            LinkedHashSet result = Sets.newLinkedHashSet();
            for (Action act : GrammarUtil.containedActions(root)) {
                if (act.getFeature() == null) continue;
                result.add(act);
            }
            for (AbstractElement ele : super.getStarts((Object)root)) {
                if (ele == null) {
                    if (!this.isStop(root)) continue;
                    result.add(null);
                    continue;
                }
                if (this.actionCtx == ele) {
                    result.add(null);
                    continue;
                }
                if (GrammarUtil.isAssignedAction(ele)) continue;
                result.add(ele);
            }
            return result;
        }

        protected boolean isStop(AbstractElement element) {
            return this.actionCtx == null || GrammarUtil.containingRule(this.actionCtx) != GrammarUtil.containingRule(element);
        }
    }
}

