/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.junit4.parameterized;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parsetree.reconstr.impl.NodeIterator;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;
import org.junit.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Offset {
    protected int offset;
    protected XtextResource resource;

    public Offset(XtextResource resource, int offset) {
        this.resource = resource;
        this.offset = offset;
    }

    public EObject getEObject() {
        EObject object = NodeModelUtils.findActualSemanticObjectFor((INode)this.getLeafNodeAtOffset());
        Assert.assertNotNull((String)("No EObject found at offset " + this.offset), (Object)object);
        return object;
    }

    public Pair<EObject, EStructuralFeature> getEStructuralFeatureByOffset() {
        return this.getEStructuralFeatureByOffset((Predicate<EStructuralFeature>)Predicates.alwaysTrue());
    }

    public Pair<EObject, EStructuralFeature> getEStructuralFeatureByOffset(Predicate<EStructuralFeature> matches) {
        ILeafNode leaf = this.getLeafNodeAtOffset();
        NodeIterator ni = null;
        while (ni == null || ni.hasNext()) {
            EObject object;
            EStructuralFeature feat;
            Assignment ass;
            ILeafNode next;
            Object object2 = next = ni == null ? leaf : ni.next();
            if (ni == null) {
                ni = new NodeIterator((INode)leaf);
            }
            if ((ass = GrammarUtil.containingAssignment((EObject)next.getGrammarElement())) == null || (feat = (object = NodeModelUtils.findActualSemanticObjectFor((INode)next)).eClass().getEStructuralFeature(ass.getFeature())) == null || !matches.apply((Object)feat)) continue;
            return Tuples.create((Object)object, (Object)feat);
        }
        Assert.fail((String)("No EStructuralFeature found at offset " + this.offset));
        return null;
    }

    public Pair<EObject, EStructuralFeature> getEStructuralFeatureByParent() {
        ILeafNode leaf = this.getLeafNodeAtOffset();
        EObject object = NodeModelUtils.findActualSemanticObjectFor((INode)leaf);
        Assert.assertNotNull((String)("No EObject found at offset " + this.offset), (Object)object);
        Assignment ass = GrammarUtil.containingAssignment((EObject)leaf.getGrammarElement());
        while (ass == null && leaf.getParent() != null) {
            leaf = leaf.getParent();
            ass = GrammarUtil.containingAssignment((EObject)leaf.getGrammarElement());
        }
        Assert.assertNotNull((String)("No Assignment found at offset " + this.offset), (Object)ass);
        EStructuralFeature feature = object.eClass().getEStructuralFeature(ass.getFeature());
        return Tuples.create((Object)object, (Object)feature);
    }

    public ILeafNode getLeafNodeAtOffset() {
        ILeafNode node = NodeModelUtils.findLeafNodeAtOffset((INode)this.resource.getParseResult().getRootNode(), (int)this.offset);
        Assert.assertNotNull((String)("No Leaf Node found at offset " + this.offset), (Object)node);
        return node;
    }

    public int hashCode() {
        return this.offset * (this.resource != null ? this.resource.hashCode() : 1);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Offset off = (Offset)obj;
        return this.resource == off.resource && this.offset == off.offset;
    }

    public int getOffset() {
        return this.offset;
    }

    public XtextResource getResource() {
        return this.resource;
    }

    public String toString() {
        if (this.resource == null) {
            return "(resource is null)";
        }
        if (this.resource.getParseResult() == null || this.resource.getParseResult().getRootNode() == null) {
            return "(resource hs no parse result)";
        }
        String text = this.resource.getParseResult().getRootNode().getText();
        if (this.offset < 0 || this.offset > text.length()) {
            return "(offset out of range)";
        }
        int from = Math.max(0, this.offset - 5);
        int to = Math.min(text.length(), this.offset + 5);
        return String.valueOf(text.substring(from, this.offset)) + "!" + text.substring(this.offset, to);
    }
}

