/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.impl;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.internal.jobs.InternalJob;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.xtext.builder.IXtextBuilderParticipant;
import org.eclipse.xtext.builder.builderState.IBuilderState;
import org.eclipse.xtext.builder.debug.IBuildLogger;
import org.eclipse.xtext.builder.impl.BuildContext;
import org.eclipse.xtext.builder.impl.BuildData;
import org.eclipse.xtext.builder.impl.ClosedProjectsQueue;
import org.eclipse.xtext.builder.impl.IBuildFlag;
import org.eclipse.xtext.builder.impl.Messages;
import org.eclipse.xtext.builder.impl.QueuedBuildData;
import org.eclipse.xtext.builder.impl.RegistryBuilderParticipant;
import org.eclipse.xtext.builder.impl.SourceLevelURICache;
import org.eclipse.xtext.builder.impl.ToBeBuilt;
import org.eclipse.xtext.builder.impl.ToBeBuiltComputer;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.service.OperationCanceledError;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.ui.XtextProjectHelper;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;
import org.eclipse.xtext.ui.shared.contribution.ISharedStateContributionRegistry;
import org.eclipse.xtext.util.internal.Stopwatches;

public class XtextBuilder
extends IncrementalProjectBuilder {
    private static final Logger log = Logger.getLogger(XtextBuilder.class);
    public static final String BUILDER_ID = "org.eclipse.xtext.ui.shared.xtextBuilder";
    private static final String EXTERNAL_PROJECT_NAME = ".org.eclipse.jdt.core.external.folders";
    @Inject
    private ToBeBuiltComputer toBeBuiltComputer;
    @Inject
    private IBuilderState builderState;
    @Inject
    private IResourceSetProvider resourceSetProvider;
    @Inject
    private IResourceServiceProvider.Registry resourceServiceProvideRegistry;
    @Inject
    private RegistryBuilderParticipant participant;
    @Inject
    private QueuedBuildData queuedBuildData;
    @Inject
    private IBuildLogger buildLogger;
    @Inject
    private OperationCanceledManager operationCanceledManager;
    private ClosedProjectsQueue closedProjectsQueue;
    @Inject
    private BuilderPreferences preferences;
    private static final JobChangeAdapter MAKE_EGIT_JOB_SYSTEM = new JobChangeAdapter(){
        private boolean fixedTheJob = false;

        public void scheduled(IJobChangeEvent event) {
            if (this.fixedTheJob) {
                return;
            }
            Job job = event.getJob();
            if (job == null) {
                return;
            }
            Class<?> jobClazz = job.getClass();
            if (!job.isSystem() && jobClazz.getName().equals("org.eclipse.egit.core.internal.indexdiff.IndexDiffCacheEntry$5")) {
                try {
                    Field field = InternalJob.class.getDeclaredField("flags");
                    field.setAccessible(true);
                    field.set(job, (Integer)field.get(job) | 0x100);
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Made job '" + job + "' a system job."));
                    }
                    this.fixedTheJob = true;
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    };

    @Inject
    private void injectClosedProjectsQueue(ISharedStateContributionRegistry sharedState) {
        this.closedProjectsQueue = (ClosedProjectsQueue)sharedState.getSingleContributedInstance(ClosedProjectsQueue.class);
    }

    public IResourceSetProvider getResourceSetProvider() {
        return this.resourceSetProvider;
    }

    /*
     * Loose catch block
     */
    protected IProject[] build(final int kind, Map args, IProgressMonitor monitor) throws CoreException {
        block19: {
            Stopwatches.StoppedTask task;
            long startTime;
            block21: {
                if (IBuildFlag.FORGET_BUILD_STATE_ONLY.isSet(args)) {
                    this.forgetLastBuiltState();
                    return this.getProject().getReferencedProjects();
                }
                Job.getJobManager().addJobChangeListener((IJobChangeListener)MAKE_EGIT_JOB_SYSTEM);
                startTime = System.currentTimeMillis();
                task = Stopwatches.forTask((String)String.format("XtextBuilder.build[%s]", this.getKindAsString(kind)));
                try {
                    this.queuedBuildData.createCheckpoint();
                    if (this.shouldCancelBuild(kind)) {
                        throw new OperationCanceledException("Build has been interrupted");
                    }
                    task.start();
                    if (monitor /* !! */  != null) {
                        final String taskName = String.valueOf(Messages.XtextBuilder_Building) + this.getProject().getName() + ": ";
                        monitor /* !! */  = new ProgressMonitorWrapper(monitor /* !! */ ){

                            public void subTask(String name) {
                                super.subTask(String.valueOf(taskName) + name);
                            }

                            public boolean isCanceled() {
                                boolean shouldCancelBuild = XtextBuilder.this.shouldCancelBuild(kind);
                                if (shouldCancelBuild) {
                                    XtextBuilder.this.buildLogger.log("interrupted");
                                }
                                return shouldCancelBuild || super.isCanceled();
                            }
                        };
                    }
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor /* !! */ , (int)1);
                    if (kind == 6) {
                        this.fullBuild((IProgressMonitor)progress.split(1), IBuildFlag.RECOVERY_BUILD.isSet(args));
                    } else {
                        IResourceDelta delta = this.getDelta(this.getProject());
                        if (delta == null || this.isOpened(delta)) {
                            this.fullBuild((IProgressMonitor)progress.split(1), IBuildFlag.RECOVERY_BUILD.isSet(args));
                        } else {
                            this.incrementalBuild(delta, (IProgressMonitor)progress.split(1));
                        }
                    }
                }
                catch (CoreException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    throw e;
                }
                catch (OperationCanceledException e) {
                    this.handleCanceled(e);
                    this.queuedBuildData.discardCheckpoint();
                    if (monitor /* !! */  != null) {
                        monitor /* !! */ .done();
                    }
                    String message = "Build " + this.getProject().getName() + " in " + (System.currentTimeMillis() - startTime) + " ms";
                    log.info((Object)message);
                    this.buildLogger.log(message);
                    task.stop();
                    Job.getJobManager().removeJobChangeListener((IJobChangeListener)MAKE_EGIT_JOB_SYSTEM);
                    break block19;
                }
                catch (OperationCanceledError err) {
                    this.handleCanceled(err);
                    break block19;
                }
                catch (Exception e) {
                    block20: {
                        log.error((Object)e.getMessage(), (Throwable)e);
                        this.buildLogger.log(String.valueOf(e.getClass().getSimpleName()) + " while building " + this.getProject().getName() + ": " + e.getMessage() + " (see logs for details)");
                        this.forgetLastBuiltState();
                        this.queuedBuildData.discardCheckpoint();
                        if (monitor /* !! */  == null) break block20;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                        monitor /* !! */ .done();
                    }
                    String message = "Build " + this.getProject().getName() + " in " + (System.currentTimeMillis() - startTime) + " ms";
                    log.info((Object)message);
                    this.buildLogger.log(message);
                    task.stop();
                    Job.getJobManager().removeJobChangeListener((IJobChangeListener)MAKE_EGIT_JOB_SYSTEM);
                    break block19;
                }
                {
                    finally {
                        this.queuedBuildData.discardCheckpoint();
                        if (monitor /* !! */  != null) {
                            monitor /* !! */ .done();
                        }
                        String message = "Build " + this.getProject().getName() + " in " + (System.currentTimeMillis() - startTime) + " ms";
                        log.info((Object)message);
                        this.buildLogger.log(message);
                        task.stop();
                        Job.getJobManager().removeJobChangeListener((IJobChangeListener)MAKE_EGIT_JOB_SYSTEM);
                    }
                }
                this.queuedBuildData.discardCheckpoint();
                if (monitor /* !! */  == null) break block21;
                monitor /* !! */ .done();
            }
            String message = "Build " + this.getProject().getName() + " in " + (System.currentTimeMillis() - startTime) + " ms";
            log.info((Object)message);
            this.buildLogger.log(message);
            task.stop();
            Job.getJobManager().removeJobChangeListener((IJobChangeListener)MAKE_EGIT_JOB_SYSTEM);
        }
        return this.getProject().getReferencedProjects();
    }

    private boolean shouldCancelBuild(int buildKind) {
        return buildKind == 9 && this.isInterrupted();
    }

    private void handleCanceled(Throwable t) {
        if (!this.isInterrupted()) {
            this.operationCanceledManager.propagateIfCancelException(t);
        }
        this.buildLogger.log("Build interrupted.");
        this.queuedBuildData.rollback();
        this.rememberLastBuiltState();
    }

    private String getKindAsString(int kind) {
        if (kind == 6) {
            return "FULL";
        }
        if (kind == 15) {
            return "CLEAN";
        }
        if (kind == 10) {
            return "INCREMENTAL";
        }
        if (kind == 9) {
            return "AUTO";
        }
        return "UNKOWN:" + kind;
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.XtextBuilder_CollectingResources, (int)10);
        progress.subTask(Messages.XtextBuilder_CollectingResources);
        if (this.queuedBuildData.needRebuild(this.getProject())) {
            this.needRebuild();
        }
        ToBeBuilt toBeBuilt = new ToBeBuilt();
        IResourceDeltaVisitor visitor = this.createDeltaVisitor(this.toBeBuiltComputer, toBeBuilt, progress);
        delta.accept(visitor);
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        progress.worked(2);
        ClosedProjectsQueue.Task task = this.closedProjectsQueue.exhaust();
        try {
            this.addInfosFromTask(task, toBeBuilt);
            this.doBuild(toBeBuilt, (IProgressMonitor)progress.split(8), IXtextBuilderParticipant.BuildType.INCREMENTAL);
        }
        catch (Exception e) {
            task.reschedule();
            throw e;
        }
    }

    private void addInfosFromTask(ClosedProjectsQueue.Task task, ToBeBuilt toBeBuilt) {
        toBeBuilt.getToBeDeleted().addAll(task.getToBeBuilt().getToBeDeleted());
        toBeBuilt.getToBeUpdated().addAll(task.getToBeBuilt().getToBeUpdated());
    }

    protected void doBuild(ToBeBuilt toBeBuilt, IProgressMonitor monitor, IXtextBuilderParticipant.BuildType type) throws CoreException {
        boolean indexingOnly;
        this.buildLogger.log("Building " + this.getProject().getName());
        boolean bl = indexingOnly = type == IXtextBuilderParticipant.BuildType.RECOVERY;
        if (new BuildData(this.getProject().getName(), null, toBeBuilt, this.queuedBuildData, indexingOnly, () -> ((XtextBuilder)this).needRebuild()).isEmpty()) {
            return;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        ResourceSet resourceSet = this.getResourceSetProvider().get(this.getProject());
        resourceSet.getLoadOptions().put("org.eclipse.xtext.scoping.namespaces.DefaultGlobalScopeProvider.BUILDER_SCOPE", Boolean.TRUE);
        BuildData buildData = new BuildData(this.getProject().getName(), resourceSet, toBeBuilt, this.queuedBuildData, indexingOnly, () -> ((XtextBuilder)this).needRebuild());
        ImmutableList<IResourceDescription.Delta> deltas = this.builderState.update(buildData, (IProgressMonitor)progress.split(1));
        if (this.participant != null && !indexingOnly) {
            SourceLevelURICache sourceLevelURIs = buildData.getSourceLevelURICache();
            Set<URI> sources = sourceLevelURIs.getSources();
            this.participant.build(new BuildContext(this, resourceSet, (List<IResourceDescription.Delta>)deltas, sources, type), (IProgressMonitor)progress.split(1));
            try {
                this.getProject().getWorkspace().checkpoint(false);
            }
            catch (NoClassDefFoundError e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        } else {
            progress.worked(1);
        }
        resourceSet.eSetDeliver(false);
        for (Resource resource : resourceSet.getResources()) {
            resource.eSetDeliver(false);
        }
        resourceSet.getResources().clear();
        resourceSet.eAdapters().clear();
    }

    protected void fullBuild(IProgressMonitor monitor, boolean isRecoveryBuild) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        IProject project = this.getProject();
        ToBeBuilt toBeBuilt = isRecoveryBuild ? this.toBeBuiltComputer.updateProjectNewResourcesOnly(project, (IProgressMonitor)progress.split(2)) : this.toBeBuiltComputer.updateProject(project, (IProgressMonitor)progress.split(2));
        ClosedProjectsQueue.Task task = this.closedProjectsQueue.exhaust();
        try {
            this.addInfosFromTask(task, toBeBuilt);
            this.doBuild(toBeBuilt, (IProgressMonitor)progress.split(8), isRecoveryBuild ? IXtextBuilderParticipant.BuildType.RECOVERY : IXtextBuilderParticipant.BuildType.FULL);
        }
        catch (Exception e) {
            task.reschedule();
            throw e;
        }
    }

    protected IResourceDeltaVisitor createDeltaVisitor(final ToBeBuiltComputer toBeBuiltComputer, final ToBeBuilt toBeBuilt, final SubMonitor progress) {
        IResourceDeltaVisitor visitor = new IResourceDeltaVisitor(){

            public boolean visit(IResourceDelta delta) throws CoreException {
                if (progress.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (delta.getResource() instanceof IProject) {
                    return true;
                }
                if (delta.getResource() instanceof IStorage) {
                    if (delta.getKind() == 2) {
                        return toBeBuiltComputer.removeStorage(null, toBeBuilt, (IStorage)delta.getResource());
                    }
                    if (delta.getKind() == 1 || delta.getKind() == 4) {
                        return toBeBuiltComputer.updateStorage(null, toBeBuilt, (IStorage)delta.getResource());
                    }
                }
                return true;
            }
        };
        return visitor;
    }

    protected boolean isOpened(IResourceDelta delta) {
        return delta.getResource() instanceof IProject && (delta.getFlags() & 0x4000) != 0 && ((IProject)delta.getResource()).isOpen();
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        try {
            ToBeBuilt toBeBuilt = this.toBeBuiltComputer.removeProject(this.getProject(), (IProgressMonitor)progress.split(2));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            ClosedProjectsQueue.Task task = this.closedProjectsQueue.exhaust();
            try {
                this.addInfosFromTask(task, toBeBuilt);
                this.doClean(toBeBuilt, (IProgressMonitor)progress.split(8));
            }
            catch (Exception e) {
                task.reschedule();
                throw e;
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    protected void doClean(ToBeBuilt toBeBuilt, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        ImmutableList<IResourceDescription.Delta> deltas = this.builderState.clean(toBeBuilt.getToBeDeleted(), (IProgressMonitor)progress.split(1));
        if (this.participant != null) {
            Set<URI> sourceURIs = new SourceLevelURICache().getSourcesFrom(toBeBuilt.getToBeDeleted(), this.resourceServiceProvideRegistry);
            this.participant.build(new BuildContext(this, this.getResourceSetProvider().get(this.getProject()), (List<IResourceDescription.Delta>)deltas, sourceURIs, IXtextBuilderParticipant.BuildType.CLEAN), (IProgressMonitor)progress.split(1));
        } else {
            progress.worked(1);
        }
    }

    public ISchedulingRule getRule(int kind, Map<String, String> args) {
        switch (this.preferences.schedulingOption) {
            case NULL: {
                return null;
            }
            case WORKSPACE: {
                return this.getProject().getWorkspace().getRoot();
            }
            case PROJECT: {
                return this.getProject();
            }
            case ALL_XTEXT_PROJECTS: {
                return new MultiRule((ISchedulingRule[])Arrays.stream(this.getProject().getWorkspace().getRoot().getProjects()).filter(XtextProjectHelper::hasNature).toArray(ISchedulingRule[]::new));
            }
            case ALL_XTEXT_PROJECTS_AND_JDTEXTFOLDER: {
                return new MultiRule((ISchedulingRule[])Arrays.stream(this.getProject().getWorkspace().getRoot().getProjects()).filter(p -> XtextProjectHelper.hasNature((IProject)p) || EXTERNAL_PROJECT_NAME.equals(p.getName())).toArray(ISchedulingRule[]::new));
            }
        }
        throw new IllegalArgumentException();
    }

    @Singleton
    @Beta
    public static class BuilderPreferences {
        public static final String PREF_SCHEDULING_RULE = "schedulingrule";
        private SchedulingOption schedulingOption;

        public BuilderPreferences() {
            ScopedPreferenceStore preferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.xtext.builder");
            String schedulingRuleName = preferenceStore.getString(PREF_SCHEDULING_RULE);
            this.schedulingOption = schedulingRuleName.isEmpty() ? SchedulingOption.WORKSPACE : SchedulingOption.valueOf(schedulingRuleName);
            preferenceStore.addPropertyChangeListener(e -> {
                if (PREF_SCHEDULING_RULE.equals(e.getProperty())) {
                    this.schedulingOption = SchedulingOption.valueOf(e.getNewValue().toString());
                }
            });
        }
    }

    public static enum SchedulingOption {
        WORKSPACE,
        ALL_XTEXT_PROJECTS,
        ALL_XTEXT_PROJECTS_AND_JDTEXTFOLDER,
        PROJECT,
        NULL;

    }
}

