/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.util;

import com.google.common.base.Function;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.TypesSwitch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuperTypeCollector {
    public Collection<JvmType> collectSuperTypes(JvmType type) {
        Function<JvmType, JvmType> function = new Function<JvmType, JvmType>(){

            public JvmType apply(JvmType from) {
                return from;
            }
        };
        return this.doCollectSupertypeData(type, function);
    }

    public Collection<String> collectSuperTypeNames(JvmType type) {
        Function<JvmType, String> function = new Function<JvmType, String>(){

            public String apply(JvmType from) {
                return from.getCanonicalName();
            }
        };
        return this.doCollectSupertypeData(type, function);
    }

    public <Result> Collection<Result> doCollectSupertypeData(JvmType type, Function<JvmType, Result> function) {
        if (type != null) {
            Implementation<Result> implementation = new Implementation<Result>(function);
            implementation.doSwitch(type);
            Collection<Result> result = implementation.getResult();
            return result;
        }
        return Collections.emptySet();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Implementation<Result>
    extends TypesSwitch<Void> {
        private boolean collecting = false;
        private final Collection<Result> result;
        private final Function<JvmType, Result> transformation;

        public Implementation(Function<JvmType, Result> transformation) {
            this.transformation = transformation;
            this.result = Sets.newHashSet();
        }

        public Collection<Result> getResult() {
            return this.result;
        }

        @Override
        public Void caseJvmType(JvmType object) {
            return null;
        }

        @Override
        public Void caseJvmDeclaredType(JvmDeclaredType object) {
            if (!(object.eIsProxy() || this.collecting && !this.result.add(this.transformation.apply((Object)object)))) {
                this.collecting = true;
                for (JvmTypeReference superType : object.getSuperTypes()) {
                    if (superType.getType() == null) continue;
                    this.doSwitch(superType.getType());
                }
            }
            return null;
        }
    }
}

