/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.outline.transformer;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.resource.EObjectHandleImpl;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.outline.ContentOutlineNode;
import org.eclipse.xtext.ui.editor.outline.transformer.ISemanticModelTransformer;
import org.eclipse.xtext.util.concurrent.IEObjectHandle;
import org.eclipse.xtext.util.concurrent.IStateAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSemanticModelTransformer
implements ISemanticModelTransformer {
    public static final String INVISIBLE_ROOT_NODE = "Invisible Root Node";
    public static final List<EObject> NO_CHILDREN = Collections.emptyList();
    private IStateAccess<XtextResource> resourceAccess;

    @Override
    public void setResourceAccess(IStateAccess<XtextResource> resourceAccess) {
        this.resourceAccess = resourceAccess;
    }

    @Override
    public ContentOutlineNode transformSemanticModel(EObject semanticModel) {
        ContentOutlineNode outlineModel = new ContentOutlineNode(INVISIBLE_ROOT_NODE);
        if (semanticModel != null) {
            this.transformSemanticNode(semanticModel, outlineModel);
        }
        return outlineModel;
    }

    public void transformSemanticNode(EObject semanticNode, ContentOutlineNode outlineParentNode) {
        ContentOutlineNode outlineNode = this.consumeSemanticNode(semanticNode) ? this.createOutlineNode(semanticNode, outlineParentNode) : outlineParentNode;
        outlineNode.setTransformer(this);
        outlineNode.addHandleForChildren((IEObjectHandle<EObject>)new EObjectHandleImpl(semanticNode, this.getResourceAccess()));
    }

    public void transformSemanticChildNodes(EObject semanticNode, ContentOutlineNode outlineNode) {
        if (this.consumeSemanticChildNodes(semanticNode)) {
            List<EObject> list = this.getChildNodes(semanticNode);
            for (EObject semanticChildNode : list) {
                this.transformSemanticNode(semanticChildNode, outlineNode);
            }
        }
    }

    protected List<EObject> getChildNodes(EObject semanticNode) {
        return this.getChildren(semanticNode);
    }

    protected List<EObject> getChildren(EObject semanticNode) {
        return semanticNode.eContents();
    }

    protected abstract ContentOutlineNode createOutlineNode(EObject var1, ContentOutlineNode var2);

    protected abstract boolean consumeSemanticChildNodes(EObject var1);

    protected abstract boolean consumeSemanticNode(EObject var1);

    public IStateAccess<XtextResource> getResourceAccess() {
        return this.resourceAccess;
    }
}

