/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.outline.quickoutline;

import java.util.regex.Pattern;

public class StringMatcher {
    private final String expression;
    private final boolean ignoreCase;
    private Pattern pattern;

    public StringMatcher(String pattern, boolean ignoreCase) {
        this.expression = this.translatePattern(pattern);
        this.ignoreCase = ignoreCase;
    }

    private String translatePattern(String pattern) {
        String expression = pattern.replaceAll("\\*", ".*");
        expression = expression.replaceAll("\\?", ".");
        return expression;
    }

    private Pattern getPattern() {
        if (this.pattern == null) {
            this.pattern = this.ignoreCase ? Pattern.compile(this.expression, 2) : Pattern.compile(this.expression);
        }
        return this.pattern;
    }

    public boolean match(String text) {
        return this.getPattern().matcher(text).matches();
    }
}

