/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationPainter;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension2;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.xtext.ui.XtextUIMessages;
import org.eclipse.xtext.ui.editor.CompoundXtextEditorCallback;
import org.eclipse.xtext.ui.editor.ISourceViewerAware;
import org.eclipse.xtext.ui.editor.IXtextEditorAware;
import org.eclipse.xtext.ui.editor.XtextMarkerRulerAction;
import org.eclipse.xtext.ui.editor.XtextSourceViewer;
import org.eclipse.xtext.ui.editor.XtextSourceViewerConfiguration;
import org.eclipse.xtext.ui.editor.actions.IActionContributor;
import org.eclipse.xtext.ui.editor.bracketmatching.CharacterPairMatcher;
import org.eclipse.xtext.ui.editor.folding.IFoldingStructureProvider;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.XtextDocumentProvider;
import org.eclipse.xtext.ui.editor.model.XtextDocumentUtil;
import org.eclipse.xtext.ui.editor.preferences.IPreferenceStoreAccess;
import org.eclipse.xtext.ui.editor.syntaxcoloring.IHighlightingHelper;
import org.eclipse.xtext.ui.editor.toggleComments.ToggleSLCommentAction;

public class XtextEditor
extends TextEditor {
    public static final String ERROR_ANNOTATION_TYPE = "org.eclipse.xtext.ui.editor.error";
    public static final String WARNING_ANNOTATION_TYPE = "org.eclipse.xtext.ui.editor.warning";
    private static final Logger log = Logger.getLogger(XtextEditor.class);
    public static final String ID = "org.eclipse.xtext.baseEditor";
    @Inject
    private IFoldingStructureProvider foldingStructureProvider;
    @Inject(optional=true)
    private AnnotationPainter.IDrawingStrategy projectionAnnotationDrawingStrategy;
    @Inject
    private CompoundXtextEditorCallback callback;
    @Inject
    private XtextSourceViewerConfiguration sourceViewerConfiguration;
    private IContentOutlinePage outlinePage;
    @Inject(optional=true)
    private Provider<IContentOutlinePage> outlinePageProvider;
    @Inject
    private Provider<XtextDocumentProvider> documentProvider;
    @Inject
    private XtextSourceViewer.Factory sourceViewerFactory;
    @Inject
    private IHighlightingHelper highlightingHelper;
    @Inject
    private IPreferenceStoreAccess preferenceStoreAccess;
    private ISelectionChangedListener selectionChangedListener;
    private String languageName;
    @Inject
    private IActionContributor.CompositeImpl actioncontributor;
    @Inject
    private CharacterPairMatcher characterPairMatcher;
    private ProjectionSupport projectionSupport;

    public XtextEditor() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating Xtext Editor. Instance: [" + ((Object)((Object)this)).toString() + "]"));
        }
    }

    public IXtextDocument getDocument() {
        return XtextDocumentUtil.get(this.getSourceViewer());
    }

    @Inject
    public void setLanguageName(@Named(value="languageName") String name) {
        this.languageName = name;
    }

    public String getLanguageName() {
        return this.languageName;
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("doSetInput:" + input));
            log.debug((Object)("Editor instance is [" + ((Object)((Object)this)).toString() + "]"));
        }
        this.callback.beforeSetInput(this);
        super.doSetInput(input);
        this.callback.afterSetInput(this);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("init:" + input));
        }
        this.setDocumentProvider((IDocumentProvider)this.documentProvider.get());
        this.setSourceViewerConfiguration((SourceViewerConfiguration)this.sourceViewerConfiguration);
        this.setPreferenceStore(this.preferenceStoreAccess.getContextPreferenceStore(input));
        super.init(site, input);
    }

    public XtextSourceViewerConfiguration getXtextSourceViewerConfiguration() {
        return this.sourceViewerConfiguration;
    }

    public void doSaveAs() {
        super.doSaveAs();
        this.callback.afterSave(this);
    }

    public void doSave(IProgressMonitor progressMonitor) {
        super.doSave(progressMonitor);
        this.callback.afterSave(this);
    }

    public void doRevertToSaved() {
        super.doRevertToSaved();
        this.callback.afterSave(this);
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"org.eclipse.xtext.ui.XtextEditorScope"});
    }

    public IResource getResource() {
        Object adapter = this.getEditorInput().getAdapter(IResource.class);
        if (adapter != null) {
            return (IResource)adapter;
        }
        return null;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IContentOutlinePage.class)) {
            return this.getContentOutlinePage();
        }
        return super.getAdapter(adapter);
    }

    private IContentOutlinePage getContentOutlinePage() {
        if (this.outlinePage == null) {
            this.outlinePage = this.createOutlinePage();
        }
        return this.outlinePage;
    }

    private IContentOutlinePage createOutlinePage() {
        IContentOutlinePage page = null;
        if (this.outlinePageProvider != null && (page = (IContentOutlinePage)this.outlinePageProvider.get()) != null) {
            if (page instanceof ISourceViewerAware) {
                ((ISourceViewerAware)page).setSourceViewer(this.getSourceViewer());
            }
            if (page instanceof IXtextEditorAware) {
                ((IXtextEditorAware)page).setEditor(this);
            }
        }
        return page;
    }

    public void outlinePageClosed() {
        if (this.outlinePage != null) {
            this.outlinePage = null;
            this.resetHighlightRange();
        }
    }

    protected void createActions() {
        ToggleSLCommentAction action;
        super.createActions();
        if (this.getSourceViewerConfiguration().getContentFormatter(this.getSourceViewer()) != null) {
            action = new TextOperationAction(XtextUIMessages.getResourceBundle(), "Format.", (ITextEditor)this, 15);
            action.setActionDefinitionId("org.eclipse.xtext.ui.FormatAction");
            this.setAction("Format", (IAction)action);
            this.markAsStateDependentAction("Format", true);
            this.markAsSelectionDependentAction("Format", true);
        }
        action = new ToggleSLCommentAction(XtextUIMessages.getResourceBundle(), "ToggleComment.", (ITextEditor)this);
        action.setActionDefinitionId("org.eclipse.xtext.ui.ToggleCommentAction");
        this.setAction("ToggleComment", (IAction)action);
        this.markAsStateDependentAction("ToggleComment", true);
        this.markAsSelectionDependentAction("ToggleComment", true);
        this.configureToggleCommentAction(action);
        XtextMarkerRulerAction markerAction = new XtextMarkerRulerAction(XtextUIMessages.getResourceBundle(), "XtextSelectAnnotationRulerAction.", this, (IVerticalRulerInfo)this.getVerticalRuler());
        this.setAction("RulerClick", (IAction)markerAction);
        this.actioncontributor.contributeActions(this);
    }

    private void configureToggleCommentAction(ToggleSLCommentAction action) {
        ISourceViewer sourceViewer = this.getSourceViewer();
        SourceViewerConfiguration configuration = this.getSourceViewerConfiguration();
        action.configure(sourceViewer, configuration);
    }

    public boolean isContentAssistAvailable() {
        return this.getSourceViewerConfiguration().getContentAssistant(this.getSourceViewer()) != null;
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating Xtext source viewer.");
        }
        this.fAnnotationAccess = this.createAnnotationAccess();
        this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        XtextSourceViewer projectionViewer = this.sourceViewerFactory.createSourceViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)projectionViewer);
        return projectionViewer;
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        super.configureSourceViewerDecorationSupport(support);
        if (this.characterPairMatcher != null) {
            support.setCharacterPairMatcher((ICharacterPairMatcher)this.characterPairMatcher);
            support.setMatchingCharacterPainterPreferenceKeys("CharacterMatching", "CharacterMatching.Color");
        }
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ProjectionViewer projectionViewer = (ProjectionViewer)this.getSourceViewer();
        this.projectionSupport = this.installProjectionSupport(projectionViewer);
        this.installFoldingSupport(projectionViewer);
        this.installHighlightingHelper();
        this.installSelectionChangedListener();
        this.callback.afterCreatePartControl(this);
    }

    protected ProjectionSupport installProjectionSupport(ProjectionViewer projectionViewer) {
        ProjectionSupport projectionSupport = new ProjectionSupport(projectionViewer, this.getAnnotationAccess(), this.getSharedColors());
        projectionSupport.addSummarizableAnnotationType(WARNING_ANNOTATION_TYPE);
        projectionSupport.addSummarizableAnnotationType(ERROR_ANNOTATION_TYPE);
        projectionSupport.setAnnotationPainterDrawingStrategy(this.projectionAnnotationDrawingStrategy);
        projectionSupport.install();
        return projectionSupport;
    }

    protected void installFoldingSupport(ProjectionViewer projectionViewer) {
        this.foldingStructureProvider.install(this, projectionViewer);
        projectionViewer.doOperation(19);
    }

    private void installSelectionChangedListener() {
        this.selectionChangedListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                XtextEditor.this.updateStatusLine();
            }
        };
        ISelectionProvider selectionProvider = this.getSelectionProvider();
        if (selectionProvider instanceof IPostSelectionProvider) {
            IPostSelectionProvider postSelectionProvider = (IPostSelectionProvider)selectionProvider;
            postSelectionProvider.addPostSelectionChangedListener(this.selectionChangedListener);
        } else {
            this.getSelectionProvider().addSelectionChangedListener(this.selectionChangedListener);
        }
    }

    private void installHighlightingHelper() {
        if (this.highlightingHelper != null) {
            this.highlightingHelper.install(this, (XtextSourceViewer)this.getSourceViewer());
        }
    }

    private void uninstallHighlightingHelper() {
        if (this.highlightingHelper != null) {
            this.highlightingHelper.uninstall();
        }
    }

    public void dispose() {
        this.callback.beforeDispose(this);
        super.dispose();
        if (this.projectionSupport != null) {
            this.projectionSupport.dispose();
        }
        if (this.outlinePage != null) {
            this.outlinePage = null;
        }
        this.uninstallFoldingSupport();
        this.uninstallHighlightingHelper();
        this.uninstallSelectionChangedListener();
    }

    protected void uninstallFoldingSupport() {
        if (this.foldingStructureProvider != null) {
            this.foldingStructureProvider.uninstall();
            this.foldingStructureProvider = null;
        }
    }

    private void uninstallSelectionChangedListener() {
        ISelectionProvider selectionProvider = this.getSelectionProvider();
        if (selectionProvider != null) {
            if (selectionProvider instanceof IPostSelectionProvider) {
                IPostSelectionProvider postSelectionProvider = (IPostSelectionProvider)selectionProvider;
                postSelectionProvider.removePostSelectionChangedListener(this.selectionChangedListener);
            } else {
                selectionProvider.removeSelectionChangedListener(this.selectionChangedListener);
            }
        }
    }

    public ISourceViewer getInternalSourceViewer() {
        return this.getSourceViewer();
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        super.handlePreferenceStoreChanged(event);
        if (this.getSourceViewer() == null) {
            return;
        }
        boolean tokenStyleChanged = event.getProperty().contains(".syntaxColorer.tokenStyles");
        if (tokenStyleChanged) {
            this.initializeViewerColors(this.getSourceViewer());
            this.getSourceViewer().invalidateTextPresentation();
        }
    }

    protected String[] collectContextMenuPreferencePages() {
        String[] ids = super.collectContextMenuPreferencePages();
        String[] more = new String[ids.length + 4];
        more[0] = String.valueOf(this.getLanguageName()) + ".editor";
        more[1] = this.getLanguageName();
        more[2] = String.valueOf(this.getLanguageName()) + ".templates";
        more[3] = String.valueOf(this.getLanguageName()) + ".coloring";
        System.arraycopy(ids, 0, more, 4, ids.length);
        return more;
    }

    protected IAnnotationAccess createAnnotationAccess() {
        return new DefaultMarkerAnnotationAccess(){

            public int getLayer(Annotation annotation) {
                if (annotation.isMarkedDeleted()) {
                    return 0;
                }
                return super.getLayer(annotation);
            }
        };
    }

    protected void updateStatusLine() {
        ITextSelection selection = (ITextSelection)this.getSelectionProvider().getSelection();
        Annotation annotation = this.getAnnotation(selection.getOffset(), selection.getLength());
        String message = null;
        if (annotation != null) {
            this.updateMarkerViews(annotation);
            if (this.isProblemMarkerAnnotation(annotation)) {
                message = annotation.getText();
            }
        }
        this.setStatusLineMessage(message);
    }

    public boolean validateEditorInputState() {
        return this.callback.onValidateEditorInputState(this) && super.validateEditorInputState();
    }

    public void updatedTitleImage(Image image) {
        this.setTitleImage(image);
    }

    public Image getDefaultImage() {
        IEditorRegistry editorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
        IEditorDescriptor editorDesc = editorRegistry.findEditor(this.getSite().getId());
        ImageDescriptor imageDesc = editorDesc != null ? editorDesc.getImageDescriptor() : null;
        return imageDesc != null ? imageDesc.createImage() : super.getDefaultImage();
    }

    protected void rulerContextMenuAboutToShow(IMenuManager menu) {
        super.rulerContextMenuAboutToShow(menu);
        MenuManager foldingMenu = new MenuManager(XtextUIMessages.Editor_FoldingMenu_name, "projection");
        menu.appendToGroup("rulers", (IContributionItem)foldingMenu);
        IAction action = this.getAction("FoldingToggle");
        foldingMenu.add(action);
        action = this.getAction("FoldingExpandAll");
        foldingMenu.add(action);
        action = this.getAction("FoldingCollapseAll");
        foldingMenu.add(action);
        action = this.getAction("FoldingRestore");
        foldingMenu.add(action);
    }

    public void resetProjection() {
        if (this.foldingStructureProvider != null) {
            this.foldingStructureProvider.initialize();
        }
    }

    private Annotation getAnnotation(int offset, int length) {
        IAnnotationModel model = this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput());
        if (model == null) {
            return null;
        }
        Iterator iterator = model instanceof IAnnotationModelExtension2 ? ((IAnnotationModelExtension2)model).getAnnotationIterator(offset, length, true, true) : model.getAnnotationIterator();
        while (iterator.hasNext()) {
            Annotation a = (Annotation)iterator.next();
            Position p = model.getPosition(a);
            if (p == null || !p.overlapsWith(offset, length)) continue;
            return a;
        }
        return null;
    }

    private boolean isProblemMarkerAnnotation(Annotation annotation) {
        if (!(annotation instanceof MarkerAnnotation)) {
            return false;
        }
        try {
            return ((MarkerAnnotation)annotation).getMarker().isSubtypeOf("org.eclipse.core.resources.problemmarker");
        }
        catch (CoreException e) {
            return false;
        }
    }

    public void setXtextEditorCallback(CompoundXtextEditorCallback callback) {
        this.callback = callback;
    }

    public void reveal(int offset, int length) {
        if (this.getSourceViewer() == null) {
            return;
        }
        StyledText widget = this.getSourceViewer().getTextWidget();
        widget.setRedraw(false);
        this.adjustHighlightRange(offset, length);
        this.getSourceViewer().revealRange(offset, length);
        this.markInNavigationHistory();
        widget.setRedraw(true);
    }
}

