/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.parser.antlr.splitting;

import org.eclipse.xtext.generator.parser.antlr.splitting.simpleExpressions.AndExpression;
import org.eclipse.xtext.generator.parser.antlr.splitting.simpleExpressions.Comparison;
import org.eclipse.xtext.generator.parser.antlr.splitting.simpleExpressions.Expression;
import org.eclipse.xtext.generator.parser.antlr.splitting.simpleExpressions.IfCondition;
import org.eclipse.xtext.generator.parser.antlr.splitting.simpleExpressions.MethodCall;
import org.eclipse.xtext.generator.parser.antlr.splitting.simpleExpressions.NotExpression;
import org.eclipse.xtext.generator.parser.antlr.splitting.simpleExpressions.NumberLiteral;
import org.eclipse.xtext.generator.parser.antlr.splitting.simpleExpressions.OrExpression;
import org.eclipse.xtext.generator.parser.antlr.splitting.simpleExpressions.util.SimpleExpressionsSwitch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConditionSimplifier
extends SimpleExpressionsSwitch<Expression> {
    public void simplify(IfCondition condition) {
        Expression expression = this.simplifyRecursive(condition.getCondition());
        condition.setCondition(expression);
    }

    public Expression simplifyRecursive(Expression expression) {
        return (Expression)this.doSwitch(expression);
    }

    @Override
    public Expression caseAndExpression(AndExpression object) {
        Expression right;
        if (object.getRight() == null) {
            return (Expression)this.doSwitch(object.getLeft());
        }
        if (object.getLeft() == null) {
            return (Expression)this.doSwitch(object.getRight());
        }
        Expression left = (Expression)this.doSwitch(object.getLeft());
        if (this.areSemanticallyEqual(left, right = (Expression)this.doSwitch(object.getRight()))) {
            return left;
        }
        object.setLeft(left);
        object.setRight(right);
        return object;
    }

    @Override
    public Expression caseOrExpression(OrExpression object) {
        AndExpression rightAsAnd;
        Expression right;
        if (object.getRight() == null) {
            return (Expression)this.doSwitch(object.getLeft());
        }
        if (object.getLeft() == null) {
            return (Expression)this.doSwitch(object.getRight());
        }
        Expression left = (Expression)this.doSwitch(object.getLeft());
        if (this.areSemanticallyEqual(left, right = (Expression)this.doSwitch(object.getRight()))) {
            return left;
        }
        if (left instanceof AndExpression) {
            AndExpression leftAsAnd = (AndExpression)left;
            if (this.areSemanticallyEqual(leftAsAnd.getLeft(), right) || this.areSemanticallyEqual(leftAsAnd.getRight(), right)) {
                return right;
            }
        } else if (right instanceof AndExpression && (this.areSemanticallyEqual((rightAsAnd = (AndExpression)right).getLeft(), left) || this.areSemanticallyEqual(rightAsAnd.getRight(), left))) {
            return left;
        }
        object.setLeft(left);
        object.setRight(right);
        return object;
    }

    @Override
    public Expression caseNotExpression(NotExpression object) {
        if (object.getExpression() instanceof NotExpression) {
            return (Expression)this.doSwitch(((NotExpression)object.getExpression()).getExpression());
        }
        object.setExpression((Expression)this.doSwitch(object.getExpression()));
        return object;
    }

    @Override
    public Expression caseExpression(Expression object) {
        return object;
    }

    public boolean areSemanticallyEqual(Expression left, Expression right) {
        if (left.eClass() != right.eClass()) {
            return false;
        }
        if (left instanceof OrExpression) {
            OrExpression leftOrExpression = (OrExpression)left;
            OrExpression rightOrExpression = (OrExpression)right;
            return this.areSemanticallyEqual(leftOrExpression.getLeft(), rightOrExpression.getLeft()) && this.areSemanticallyEqual(leftOrExpression.getRight(), rightOrExpression.getRight()) || this.areSemanticallyEqual(leftOrExpression.getRight(), rightOrExpression.getLeft()) && this.areSemanticallyEqual(leftOrExpression.getLeft(), rightOrExpression.getRight());
        }
        if (left instanceof AndExpression) {
            AndExpression leftAndExpression = (AndExpression)left;
            AndExpression rightAndExpression = (AndExpression)right;
            return this.areSemanticallyEqual(leftAndExpression.getLeft(), rightAndExpression.getLeft()) && this.areSemanticallyEqual(leftAndExpression.getRight(), rightAndExpression.getRight()) || this.areSemanticallyEqual(leftAndExpression.getRight(), rightAndExpression.getLeft()) && this.areSemanticallyEqual(leftAndExpression.getLeft(), rightAndExpression.getRight());
        }
        if (left instanceof NotExpression) {
            return this.areSemanticallyEqual(((NotExpression)left).getExpression(), ((NotExpression)right).getExpression());
        }
        if (left instanceof Comparison) {
            Comparison leftComparison = (Comparison)left;
            Comparison rightComparison = (Comparison)right;
            return ((Comparison)left).getOperator().equals(rightComparison.getOperator()) && this.areSemanticallyEqual(leftComparison.getLeft(), rightComparison.getLeft()) && this.areSemanticallyEqual(leftComparison.getRight(), rightComparison.getRight());
        }
        if (left instanceof NumberLiteral) {
            int rightValue;
            int leftValue = ((NumberLiteral)left).getValue();
            return leftValue == (rightValue = ((NumberLiteral)right).getValue());
        }
        if (left instanceof MethodCall) {
            String leftMethod = ((MethodCall)left).getValue();
            String rightMethod = ((MethodCall)right).getValue();
            return leftMethod.equals(rightMethod);
        }
        throw new IllegalStateException(left + " - " + right);
    }
}

