/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access.jdt;

import com.google.common.collect.Lists;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMemberValuePairBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.xtext.common.types.JvmAnnotationAnnotationValue;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmAnnotationValue;
import org.eclipse.xtext.common.types.JvmArrayType;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmEnumAnnotationValue;
import org.eclipse.xtext.common.types.JvmEnumerationLiteral;
import org.eclipse.xtext.common.types.JvmEnumerationType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmLowerBound;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmReferenceTypeArgument;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeAnnotationValue;
import org.eclipse.xtext.common.types.JvmTypeArgument;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.JvmWildcardTypeArgument;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.access.impl.ITypeFactory;
import org.eclipse.xtext.common.types.access.jdt.TypeURIHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdtBasedTypeFactory
implements ITypeFactory<IType> {
    private static final Logger log = Logger.getLogger(JdtBasedTypeFactory.class);
    private final TypeURIHelper uriHelper;

    public JdtBasedTypeFactory(TypeURIHelper uriHelper) {
        this.uriHelper = uriHelper;
    }

    public JvmDeclaredType createType(IType jdtType) {
        if (jdtType.getDeclaringType() != null) {
            throw new IllegalArgumentException("Cannot create type from non-toplevel-type: '" + jdtType.getFullyQualifiedName() + "'.");
        }
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setProject(jdtType.getJavaProject());
        IBinding[] bindings = parser.createBindings(new IJavaElement[]{jdtType}, null);
        if (bindings[0] == null) {
            throw new IllegalStateException("Could not create binding for '" + jdtType.getFullyQualifiedName() + "'.");
        }
        IBinding binding = bindings[0];
        if (binding instanceof ITypeBinding) {
            JvmDeclaredType result = this.createType((ITypeBinding)binding);
            return result;
        }
        throw new IllegalStateException("Expected ITypeBinding for '" + jdtType.getFullyQualifiedName() + "', but got '" + binding.toString() + "'.");
    }

    public JvmDeclaredType createType(ITypeBinding typeBinding) {
        if (typeBinding.isAnonymous() || typeBinding.isSynthetic()) {
            throw new IllegalStateException("Cannot create type for anonymous or synthetic classes");
        }
        if (typeBinding.isAnnotation()) {
            return this.createAnnotationType(typeBinding);
        }
        if (typeBinding.isEnum()) {
            return this.createEnumerationType(typeBinding);
        }
        JvmGenericType result = TypesFactory.eINSTANCE.createJvmGenericType();
        result.setInterface(typeBinding.isInterface());
        this.setTypeModifiers(typeBinding, (JvmDeclaredType)result);
        this.setVisibility((JvmMember)result, typeBinding.getModifiers());
        result.setFullyQualifiedName(this.getQualifiedName(typeBinding));
        this.createNestedTypes(typeBinding, (JvmDeclaredType)result);
        this.createMethods(typeBinding, (JvmDeclaredType)result);
        this.createFields(typeBinding, (JvmDeclaredType)result);
        this.setSuperTypes(typeBinding, (JvmDeclaredType)result);
        ITypeBinding[] iTypeBindingArray = typeBinding.getTypeParameters();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding variable = iTypeBindingArray[n2];
            result.getTypeParameters().add((Object)this.createTypeParameter(variable, (JvmMember)result));
            ++n2;
        }
        this.createAnnotationValues((IBinding)typeBinding, (JvmAnnotationTarget)result);
        return result;
    }

    protected void createFields(ITypeBinding typeBinding, JvmDeclaredType result) {
        IVariableBinding[] iVariableBindingArray = typeBinding.getDeclaredFields();
        int n = iVariableBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IVariableBinding field = iVariableBindingArray[n2];
            if (!field.isSynthetic()) {
                result.getMembers().add((Object)this.createField(field));
            }
            ++n2;
        }
    }

    public String getQualifiedName(ITypeBinding binding) {
        return this.uriHelper.getQualifiedName(binding);
    }

    public void createAnnotationValues(IBinding annotated, JvmAnnotationTarget result) {
        if (annotated.getAnnotations().length == 0) {
            return;
        }
        IAnnotationBinding[] iAnnotationBindingArray = annotated.getAnnotations();
        int n = iAnnotationBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotationBinding annotation = iAnnotationBindingArray[n2];
            this.createAnnotationReference(result, annotation);
            ++n2;
        }
    }

    public JvmAnnotationReference createAnnotationReference(JvmAnnotationTarget result, IAnnotationBinding annotation) {
        JvmAnnotationReference annotationReference = TypesFactory.eINSTANCE.createJvmAnnotationReference();
        result.getAnnotations().add((Object)annotationReference);
        annotationReference.setAnnotation(this.createAnnotationProxy(annotation.getAnnotationType()));
        IMemberValuePairBinding[] iMemberValuePairBindingArray = annotation.getAllMemberValuePairs();
        int n = iMemberValuePairBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemberValuePairBinding memberValuePair = iMemberValuePairBindingArray[n2];
            ITypeBinding originalTypeBinding = memberValuePair.getMethodBinding().getReturnType();
            ITypeBinding typeBinding = originalTypeBinding;
            if (typeBinding.isArray()) {
                typeBinding = typeBinding.getComponentType();
            }
            if (typeBinding.isParameterizedType()) {
                typeBinding = typeBinding.getErasure();
            }
            JvmAnnotationValue annotationValue = originalTypeBinding.isArray() ? this.createArrayAnnotationValue(memberValuePair, this.createAnnotationValue(typeBinding)) : this.createAnnotationValue(memberValuePair, this.createAnnotationValue(typeBinding));
            annotationReference.getValues().add((Object)annotationValue);
            annotationValue.setOperation(this.createMethodProxy(annotation.getAnnotationType(), memberValuePair.getName()));
            ++n2;
        }
        return annotationReference;
    }

    public JvmAnnotationValue createArrayAnnotationValue(IMemberValuePairBinding memberValuePair, JvmAnnotationValue result) {
        Object value = memberValuePair.getValue();
        if (value != null) {
            int length;
            boolean valueIsArray = value.getClass().isArray();
            int n = length = valueIsArray ? Array.getLength(value) : 1;
            if (length > 0) {
                int i;
                ArrayList valuesAsList = Lists.newArrayListWithExpectedSize((int)length);
                if (result instanceof JvmTypeAnnotationValue) {
                    i = 0;
                    while (i < length) {
                        ITypeBinding referencedType = (ITypeBinding)(valueIsArray ? Array.get(value, i) : value);
                        JvmTypeReference typeReference = this.createTypeReference(referencedType);
                        valuesAsList.add(typeReference);
                        ++i;
                    }
                } else if (result instanceof JvmAnnotationAnnotationValue) {
                    i = 0;
                    while (i < length) {
                        IAnnotationBinding nestedAnnotation = (IAnnotationBinding)(valueIsArray ? Array.get(value, i) : value);
                        this.createAnnotationReference((JvmAnnotationTarget)result, nestedAnnotation);
                        ++i;
                    }
                } else if (result instanceof JvmEnumAnnotationValue) {
                    i = 0;
                    while (i < length) {
                        IVariableBinding variableBinding = (IVariableBinding)(valueIsArray ? Array.get(value, i) : value);
                        JvmEnumerationLiteral proxy = this.createEnumLiteralProxy(variableBinding);
                        valuesAsList.add(proxy);
                        ++i;
                    }
                } else {
                    i = 0;
                    while (i < length) {
                        valuesAsList.add(valueIsArray ? Array.get(value, i) : value);
                        ++i;
                    }
                }
                if (!(result instanceof JvmAnnotationAnnotationValue)) {
                    EStructuralFeature structuralFeature = result.eClass().getEStructuralFeature("values");
                    if (structuralFeature.getEType() instanceof EDataType) {
                        ArrayList convertedValues = Lists.newArrayListWithExpectedSize((int)valuesAsList.size());
                        for (Object wrongType : valuesAsList) {
                            Object convertedValue = EcoreFactory.eINSTANCE.createFromString((EDataType)structuralFeature.getEType(), wrongType.toString());
                            convertedValues.add(convertedValue);
                        }
                        result.eSet(structuralFeature, (Object)convertedValues);
                    } else {
                        result.eSet(structuralFeature, (Object)valuesAsList);
                    }
                }
            }
        }
        return result;
    }

    public JvmType createProxy(ITypeBinding typeBinding) {
        InternalEObject proxy = (InternalEObject)TypesFactory.eINSTANCE.createJvmVoid();
        URI uri = this.uriHelper.getFullURI(typeBinding);
        proxy.eSetProxyURI(uri);
        return (JvmType)proxy;
    }

    public JvmType createProxyForType(String fqn) {
        InternalEObject proxy = (InternalEObject)TypesFactory.eINSTANCE.createJvmVoid();
        URI uri = this.uriHelper.getFullURIForClass(fqn);
        proxy.eSetProxyURI(uri);
        return (JvmType)proxy;
    }

    public JvmAnnotationValue createAnnotationValue(IMemberValuePairBinding memberValuePair, JvmAnnotationValue result) {
        Object value = memberValuePair.getValue();
        if (result instanceof JvmTypeAnnotationValue) {
            ITypeBinding referencedType = (ITypeBinding)value;
            JvmTypeReference typeReference = this.createTypeReference(referencedType);
            result.eSet(result.eClass().getEStructuralFeature("values"), Collections.singleton(typeReference));
        } else if (result instanceof JvmAnnotationAnnotationValue) {
            IAnnotationBinding nestedAnnotation = (IAnnotationBinding)value;
            this.createAnnotationReference((JvmAnnotationTarget)result, nestedAnnotation);
        } else if (result instanceof JvmEnumAnnotationValue) {
            IVariableBinding variableBinding = (IVariableBinding)value;
            JvmEnumerationLiteral proxy = this.createEnumLiteralProxy(variableBinding);
            result.eSet(result.eClass().getEStructuralFeature("values"), Collections.singleton(proxy));
        } else if (value != null) {
            EStructuralFeature structuralFeature = result.eClass().getEStructuralFeature("values");
            Object convertedValue = EcoreFactory.eINSTANCE.createFromString((EDataType)structuralFeature.getEType(), value.toString());
            result.eSet(structuralFeature, Collections.singleton(convertedValue));
        }
        return result;
    }

    public JvmAnnotationValue createAnnotationValue(ITypeBinding type) {
        if (String.class.getName().equals(type.getQualifiedName())) {
            return TypesFactory.eINSTANCE.createJvmStringAnnotationValue();
        }
        if (Class.class.getName().equals(type.getQualifiedName())) {
            return TypesFactory.eINSTANCE.createJvmTypeAnnotationValue();
        }
        if (type.isAnnotation()) {
            return TypesFactory.eINSTANCE.createJvmAnnotationAnnotationValue();
        }
        if (type.isEnum()) {
            return TypesFactory.eINSTANCE.createJvmEnumAnnotationValue();
        }
        if (Integer.TYPE.getName().equals(type.getQualifiedName())) {
            return TypesFactory.eINSTANCE.createJvmIntAnnotationValue();
        }
        if (Boolean.TYPE.getName().equals(type.getQualifiedName())) {
            return TypesFactory.eINSTANCE.createJvmBooleanAnnotationValue();
        }
        if (Long.TYPE.getName().equals(type.getQualifiedName())) {
            return TypesFactory.eINSTANCE.createJvmLongAnnotationValue();
        }
        if (Byte.TYPE.getName().equals(type.getQualifiedName())) {
            return TypesFactory.eINSTANCE.createJvmByteAnnotationValue();
        }
        if (Short.TYPE.getName().equals(type.getQualifiedName())) {
            return TypesFactory.eINSTANCE.createJvmShortAnnotationValue();
        }
        if (Float.TYPE.getName().equals(type.getQualifiedName())) {
            return TypesFactory.eINSTANCE.createJvmFloatAnnotationValue();
        }
        if (Double.TYPE.getName().equals(type.getQualifiedName())) {
            return TypesFactory.eINSTANCE.createJvmDoubleAnnotationValue();
        }
        if (Character.TYPE.getName().equals(type.getQualifiedName())) {
            return TypesFactory.eINSTANCE.createJvmCharAnnotationValue();
        }
        throw new IllegalArgumentException("Unexpected type: " + type);
    }

    public JvmOperation createMethodProxy(ITypeBinding typeBinding, String methodName) {
        InternalEObject proxy = (InternalEObject)TypesFactory.eINSTANCE.createJvmOperation();
        URI uri = this.uriHelper.getFullURI(typeBinding, methodName);
        proxy.eSetProxyURI(uri);
        return (JvmOperation)proxy;
    }

    public JvmEnumerationLiteral createEnumLiteralProxy(IVariableBinding binding) {
        InternalEObject proxy = (InternalEObject)TypesFactory.eINSTANCE.createJvmEnumerationLiteral();
        URI uri = this.uriHelper.getFullURI(binding);
        proxy.eSetProxyURI(uri);
        return (JvmEnumerationLiteral)proxy;
    }

    public JvmAnnotationType createAnnotationProxy(ITypeBinding annotation) {
        InternalEObject proxy = (InternalEObject)TypesFactory.eINSTANCE.createJvmAnnotationType();
        URI uri = this.uriHelper.getFullURI(annotation);
        proxy.eSetProxyURI(uri);
        return (JvmAnnotationType)proxy;
    }

    public void setSuperTypes(ITypeBinding binding, JvmDeclaredType result) {
        if (!binding.isInterface()) {
            if (binding.getSuperclass() != null) {
                result.getSuperTypes().add((Object)this.createTypeReference(binding.getSuperclass()));
            } else if (!Object.class.getName().equals(binding.getQualifiedName())) {
                result.getSuperTypes().add((Object)this.createTypeReference(Object.class.getName()));
            }
        }
        ITypeBinding[] iTypeBindingArray = binding.getInterfaces();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding intf = iTypeBindingArray[n2];
            result.getSuperTypes().add((Object)this.createTypeReference(intf));
            ++n2;
        }
    }

    public void createMethods(ITypeBinding typeBinding, JvmDeclaredType result) {
        IMethodBinding[] iMethodBindingArray = typeBinding.getDeclaredMethods();
        int n = iMethodBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodBinding method = iMethodBindingArray[n2];
            if (!method.isSynthetic() && !"<clinit>".equals(method.getName())) {
                if (method.isConstructor()) {
                    result.getMembers().add((Object)this.createConstructor(method));
                } else {
                    result.getMembers().add((Object)this.createOperation(method));
                }
            }
            ++n2;
        }
    }

    public void createNestedTypes(ITypeBinding typeBinding, JvmDeclaredType result) {
        ITypeBinding[] iTypeBindingArray = typeBinding.getDeclaredTypes();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding declaredType = iTypeBindingArray[n2];
            if (!declaredType.isAnonymous() && !declaredType.isSynthetic()) {
                result.getMembers().add((Object)this.createType(declaredType));
            }
            ++n2;
        }
    }

    public void setTypeModifiers(ITypeBinding binding, JvmDeclaredType result) {
        result.setAbstract(Modifier.isAbstract((int)binding.getModifiers()));
        result.setFinal(Modifier.isFinal((int)binding.getModifiers()));
        result.setStatic(Modifier.isStatic((int)binding.getModifiers()));
    }

    public JvmAnnotationType createAnnotationType(ITypeBinding binding) {
        JvmAnnotationType result = TypesFactory.eINSTANCE.createJvmAnnotationType();
        result.setFullyQualifiedName(this.getQualifiedName(binding));
        this.setVisibility((JvmMember)result, binding.getModifiers());
        this.setTypeModifiers(binding, (JvmDeclaredType)result);
        this.createNestedTypes(binding, (JvmDeclaredType)result);
        this.createMethods(binding, (JvmDeclaredType)result);
        this.setSuperTypes(binding, (JvmDeclaredType)result);
        this.createAnnotationValues((IBinding)binding, (JvmAnnotationTarget)result);
        return result;
    }

    public JvmEnumerationType createEnumerationType(ITypeBinding binding) {
        JvmEnumerationType result = TypesFactory.eINSTANCE.createJvmEnumerationType();
        result.setFullyQualifiedName(this.getQualifiedName(binding));
        this.setVisibility((JvmMember)result, binding.getModifiers());
        this.setTypeModifiers(binding, (JvmDeclaredType)result);
        this.createNestedTypes(binding, (JvmDeclaredType)result);
        this.createMethods(binding, (JvmDeclaredType)result);
        this.createFields(binding, (JvmDeclaredType)result);
        this.setSuperTypes(binding, (JvmDeclaredType)result);
        this.createAnnotationValues((IBinding)binding, (JvmAnnotationTarget)result);
        return result;
    }

    public JvmTypeParameter createTypeParameter(ITypeBinding parameter, JvmMember container) {
        JvmTypeParameter result = TypesFactory.eINSTANCE.createJvmTypeParameter();
        result.setName(parameter.getName());
        if (parameter.getTypeBounds().length != 0) {
            ITypeBinding[] iTypeBindingArray = parameter.getTypeBounds();
            int n = iTypeBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeBinding bound = iTypeBindingArray[n2];
                JvmUpperBound upperBound = TypesFactory.eINSTANCE.createJvmUpperBound();
                upperBound.setTypeReference(this.createTypeReference(bound));
                result.getConstraints().add((Object)upperBound);
                ++n2;
            }
        } else {
            JvmUpperBound upperBound = TypesFactory.eINSTANCE.createJvmUpperBound();
            upperBound.setTypeReference(this.createTypeReference(Object.class.getName()));
            result.getConstraints().add((Object)upperBound);
        }
        return result;
    }

    public JvmTypeReference createTypeReference(ITypeBinding typeBinding) {
        if (typeBinding.isArray()) {
            ITypeBinding componentType = typeBinding.getComponentType();
            JvmTypeReference componentTypeReference = this.createTypeReference(componentType);
            JvmArrayType resultArray = TypesFactory.eINSTANCE.createJvmArrayType();
            resultArray.setComponentType(componentTypeReference);
            JvmGenericArrayTypeReference typeReference = TypesFactory.eINSTANCE.createJvmGenericArrayTypeReference();
            typeReference.setType(resultArray);
            return typeReference;
        }
        ITypeBinding[] typeArguments = typeBinding.getTypeArguments();
        if (typeArguments.length != 0) {
            ITypeBinding erasure = typeBinding.getErasure();
            JvmParameterizedTypeReference result = TypesFactory.eINSTANCE.createJvmParameterizedTypeReference();
            result.setType(this.createProxy(erasure));
            int i = 0;
            while (i < typeArguments.length) {
                JvmTypeArgument argument = this.createTypeArgument(typeArguments[i]);
                result.getArguments().add((Object)argument);
                ++i;
            }
            return result;
        }
        JvmParameterizedTypeReference result = TypesFactory.eINSTANCE.createJvmParameterizedTypeReference();
        result.setType(this.createProxy(typeBinding));
        return result;
    }

    public JvmTypeReference createTypeReference(String qualifiedName) {
        JvmParameterizedTypeReference result = TypesFactory.eINSTANCE.createJvmParameterizedTypeReference();
        result.setType(this.createProxyForType(qualifiedName));
        return result;
    }

    public JvmTypeArgument createTypeArgument(ITypeBinding argument) {
        if (argument.isWildcardType()) {
            JvmWildcardTypeArgument result = TypesFactory.eINSTANCE.createJvmWildcardTypeArgument();
            if (argument.getBound() == null) {
                JvmUpperBound upperBound = TypesFactory.eINSTANCE.createJvmUpperBound();
                JvmTypeReference reference = this.createTypeReference(Object.class.getName());
                upperBound.setTypeReference(reference);
                result.getConstraints().add((Object)upperBound);
            } else {
                ITypeBinding bound = argument.getBound();
                if (argument.isUpperbound()) {
                    JvmUpperBound upperBound = TypesFactory.eINSTANCE.createJvmUpperBound();
                    JvmTypeReference reference = this.createTypeReference(bound);
                    upperBound.setTypeReference(reference);
                    result.getConstraints().add((Object)upperBound);
                } else {
                    JvmUpperBound upperBound = TypesFactory.eINSTANCE.createJvmUpperBound();
                    JvmTypeReference objectReference = this.createTypeReference(Object.class.getName());
                    upperBound.setTypeReference(objectReference);
                    result.getConstraints().add((Object)upperBound);
                    JvmLowerBound lowerBound = TypesFactory.eINSTANCE.createJvmLowerBound();
                    JvmTypeReference reference = this.createTypeReference(bound);
                    lowerBound.setTypeReference(reference);
                    result.getConstraints().add((Object)lowerBound);
                }
            }
            return result;
        }
        JvmReferenceTypeArgument result = TypesFactory.eINSTANCE.createJvmReferenceTypeArgument();
        JvmTypeReference typeReference = this.createTypeReference(argument);
        result.setTypeReference(typeReference);
        return result;
    }

    public JvmField createField(IVariableBinding field) {
        Object result = !field.isEnumConstant() ? TypesFactory.eINSTANCE.createJvmField() : TypesFactory.eINSTANCE.createJvmEnumerationLiteral();
        String typeName = this.getQualifiedName(field.getDeclaringClass());
        String fqn = String.valueOf(typeName) + "." + field.getName();
        result.setFullyQualifiedName(fqn);
        result.setFinal(Modifier.isFinal((int)field.getModifiers()));
        result.setStatic(Modifier.isStatic((int)field.getModifiers()));
        this.setVisibility((JvmMember)result, field.getModifiers());
        result.setType(this.createTypeReference(field.getType()));
        this.createAnnotationValues((IBinding)field, (JvmAnnotationTarget)result);
        return result;
    }

    public void setVisibility(JvmMember result, int modifiers) {
        if (Modifier.isPrivate((int)modifiers)) {
            result.setVisibility(JvmVisibility.PRIVATE);
        } else if (Modifier.isProtected((int)modifiers)) {
            result.setVisibility(JvmVisibility.PROTECTED);
        } else if (Modifier.isPublic((int)modifiers)) {
            result.setVisibility(JvmVisibility.PUBLIC);
        } else {
            result.setVisibility(JvmVisibility.DEFAULT);
        }
    }

    public JvmConstructor createConstructor(IMethodBinding method) {
        JvmConstructor result = TypesFactory.eINSTANCE.createJvmConstructor();
        this.enhanceGenericDeclaration((JvmExecutable)result, method.getTypeParameters());
        this.enhanceExecutable((JvmExecutable)result, method);
        this.createAnnotationValues((IBinding)method, (JvmAnnotationTarget)result);
        return result;
    }

    public void enhanceExecutable(JvmExecutable result, IMethodBinding method) {
        String[] parameterNames;
        ITypeBinding[] parameterTypes;
        block7: {
            StringBuilder fqName = new StringBuilder(48);
            fqName.append(this.getQualifiedName(method.getDeclaringClass()));
            fqName.append('.');
            fqName.append(method.getName());
            fqName.append('(');
            parameterTypes = method.getParameterTypes();
            int i = 0;
            while (i < parameterTypes.length) {
                if (i != 0) {
                    fqName.append(',');
                }
                fqName.append(this.getQualifiedName(parameterTypes[i]));
                ++i;
            }
            fqName.append(')');
            result.setFullyQualifiedName(fqName.toString());
            this.setVisibility((JvmMember)result, method.getModifiers());
            IMethod javaMethod = (IMethod)method.getJavaElement();
            parameterNames = null;
            if (javaMethod != null) {
                try {
                    parameterNames = javaMethod.getParameterNames();
                }
                catch (JavaModelException ex) {
                    if (ex.isDoesNotExist()) break block7;
                    log.warn((Object)"IMethod.getParameterNames failed", (Throwable)ex);
                }
            }
        }
        int i = 0;
        while (i < parameterTypes.length) {
            String parameterName = parameterNames != null ? parameterNames[i] : "p" + i;
            IAnnotationBinding[] parameterAnnotations = method.getParameterAnnotations(i);
            result.getParameters().add((Object)this.createFormalParameter(parameterTypes[i], parameterName, parameterAnnotations));
            ++i;
        }
        ITypeBinding[] iTypeBindingArray = method.getExceptionTypes();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding exceptionType = iTypeBindingArray[n2];
            result.getExceptions().add((Object)this.createTypeReference(exceptionType));
            ++n2;
        }
    }

    public void enhanceGenericDeclaration(JvmExecutable result, ITypeBinding[] parameters) {
        ITypeBinding[] iTypeBindingArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding parameter = iTypeBindingArray[n2];
            result.getTypeParameters().add((Object)this.createTypeParameter(parameter, (JvmMember)result));
            ++n2;
        }
    }

    public JvmOperation createOperation(IMethodBinding method) {
        JvmOperation result = TypesFactory.eINSTANCE.createJvmOperation();
        this.enhanceGenericDeclaration((JvmExecutable)result, method.getTypeParameters());
        this.enhanceExecutable((JvmExecutable)result, method);
        result.setFinal(Modifier.isFinal((int)method.getModifiers()));
        result.setStatic(Modifier.isStatic((int)method.getModifiers()));
        result.setReturnType(this.createTypeReference(method.getReturnType()));
        this.createAnnotationValues((IBinding)method, (JvmAnnotationTarget)result);
        return result;
    }

    public JvmFormalParameter createFormalParameter(ITypeBinding parameterType, String paramName, IAnnotationBinding[] annotations) {
        JvmFormalParameter result = TypesFactory.eINSTANCE.createJvmFormalParameter();
        result.setName(paramName);
        result.setParameterType(this.createTypeReference(parameterType));
        IAnnotationBinding[] iAnnotationBindingArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotationBinding annotation = iAnnotationBindingArray[n2];
            this.createAnnotationReference((JvmAnnotationTarget)result, annotation);
            ++n2;
        }
        return result;
    }
}

