/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.impl.AliasedEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.MapBasedScope;
import org.eclipse.xtext.xbase.XFunction;
import org.eclipse.xtext.xbase.scoping.XtypeScopeProvider;
import org.eclipse.xtext.xbase.typing.ExpressionsTypeResolver;
import org.eclipse.xtext.xbase.typing.OperatorMapping;
import org.eclipse.xtext.xpression.XBlockExpression;
import org.eclipse.xtext.xpression.XClosure;
import org.eclipse.xtext.xpression.XExpression;
import org.eclipse.xtext.xpression.XFeatureCall;
import org.eclipse.xtext.xpression.XMemberFeatureCall;
import org.eclipse.xtext.xpression.XVariableDeclaration;
import org.eclipse.xtext.xpression.XpressionPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XpressionScopeProvider
extends XtypeScopeProvider {
    @Inject
    private OperatorMapping operatorMapping;
    @Inject
    private ExpressionsTypeResolver typeResolver;

    @Override
    public IScope getScope(EObject context, EReference reference) {
        if (this.isFeatureScope(reference)) {
            return this.getFeatureScope(context, reference);
        }
        return super.getScope(context, reference);
    }

    protected boolean isFeatureScope(EReference reference) {
        return reference == XpressionPackage.Literals.XFEATURE_CALL__FEATURE;
    }

    protected IScope getFeatureScope(EObject context, EReference reference) {
        if (context instanceof XMemberFeatureCall) {
            XMemberFeatureCall call = (XMemberFeatureCall)context;
            XExpression target = (XExpression)call.getParams().get(0);
            JvmTypeReference jvmTypeReference = this.typeResolver.doSwitch(target, null);
            IScope parent = this.getAllFeatures(jvmTypeReference.getType(), IScope.NULLSCOPE, this.createCallableFeaturePredicate(call));
            return parent;
        }
        if (context instanceof XFeatureCall) {
            XFeatureCall call = (XFeatureCall)context;
            return this.getLocalVariableScope(context, reference, this.createCallableFeaturePredicate(call));
        }
        return IScope.NULLSCOPE;
    }

    protected Predicate<EObject> createCallableFeaturePredicate(final XFeatureCall call) {
        return new Predicate<EObject>(){

            public boolean apply(EObject input) {
                if (input instanceof JvmField && call.getParams().size() > 1) {
                    return false;
                }
                return !(input instanceof XFunction ? call.getParams().size() != ((JvmOperation)input).getParameters().size() : input instanceof JvmOperation && call.getParams().size() - 1 != ((JvmOperation)input).getParameters().size());
            }
        };
    }

    protected IScope getLocalVariableScope(EObject context, EReference reference, Predicate<EObject> featurePredicate) {
        if (context == null) {
            return IScope.NULLSCOPE;
        }
        IScope parentScope = this.getLocalVariableScope(context.eContainer(), reference, featurePredicate);
        if (context.eContainer() instanceof XBlockExpression) {
            XBlockExpression block = (XBlockExpression)context.eContainer();
            parentScope = this.localVarScopeForBlock(parentScope, block, block.getExpressions().indexOf((Object)context), featurePredicate);
        }
        if (context instanceof XClosure) {
            parentScope = this.localVarScopeForClosure(parentScope, (XClosure)context, featurePredicate);
        }
        return parentScope;
    }

    protected IScope localVarScopeForBlock(IScope parentScope, XBlockExpression block, int indexOfContextExpressionInBlock, Predicate<EObject> featurePredicate) {
        HashMap vars = Maps.newHashMap();
        int i = 0;
        while (i < indexOfContextExpressionInBlock) {
            XVariableDeclaration varDecl;
            XExpression expression = (XExpression)block.getExpressions().get(i);
            if (expression instanceof XVariableDeclaration && featurePredicate.apply((Object)(varDecl = (XVariableDeclaration)expression))) {
                EObjectDescription desc = this.createEObjectDescription(varDecl);
                vars.put(desc.getName(), desc);
            }
            ++i;
        }
        if (vars.isEmpty()) {
            return parentScope;
        }
        return new MapBasedScope(parentScope, (Map)vars);
    }

    protected EObjectDescription createEObjectDescription(XVariableDeclaration varDecl) {
        return new EObjectDescription(varDecl.getName(), (EObject)varDecl, Collections.emptyMap());
    }

    protected IScope localVarScopeForClosure(IScope parentScope, XClosure closure, Predicate<EObject> featurePredicate) {
        EList<JvmFormalParameter> params = closure.getParams();
        HashMap descriptions = Maps.newHashMap();
        for (JvmFormalParameter p : params) {
            if (!featurePredicate.apply((Object)p)) continue;
            EObjectDescription desc = this.createEObjectDescription(p);
            descriptions.put(desc.getName(), desc);
        }
        return new MapBasedScope(parentScope, (Map)descriptions);
    }

    protected EObjectDescription createEObjectDescription(JvmFormalParameter p) {
        return new EObjectDescription(p.getName(), (EObject)p, Collections.emptyMap());
    }

    protected IScope getAllFeatures(JvmType type, IScope parent, Predicate<EObject> featurePredicate) {
        if (type instanceof JvmDeclaredType) {
            JvmDeclaredType declType = (JvmDeclaredType)type;
            EList types = declType.getSuperTypes();
            for (JvmTypeReference jvmTypeReference : types) {
                parent = this.getAllFeatures(jvmTypeReference.getType(), parent, featurePredicate);
            }
        }
        HashMap<String, IEObjectDescription> map = this.createFeatureMap(type, featurePredicate);
        return new MapBasedScope(parent, map);
    }

    protected HashMap<String, IEObjectDescription> createFeatureMap(JvmType jvmType, Predicate<EObject> featurePredicate) {
        HashMap map = Maps.newHashMap();
        if (jvmType instanceof JvmGenericType) {
            JvmGenericType genType = (JvmGenericType)jvmType;
            List features = EcoreUtil2.typeSelect((List)genType.getMembers(), JvmFeature.class);
            for (JvmFeature jvmFeature : features) {
                if (!featurePredicate.apply((Object)jvmFeature)) continue;
                IEObjectDescription desc = this.createEObjectDescription(jvmFeature);
                map.put(desc.getName(), desc);
                String operator = this.operatorMapping.getOperator(desc.getName());
                if (operator == null) continue;
                AliasedEObjectDescription description = new AliasedEObjectDescription(operator, desc);
                map.put(description.getName(), description);
            }
        }
        return map;
    }

    protected IEObjectDescription createEObjectDescription(JvmFeature jvmFeature) {
        return new EObjectDescription(jvmFeature.getSimpleName(), (EObject)jvmFeature, null);
    }
}

