/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ast.env;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.m2m.internal.qvt.oml.ast.env.IVirtualOperationTable;
import org.eclipse.m2m.internal.qvt.oml.ast.env.InternalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalParserUtil;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalUtil;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ThisInstanceResolver;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.SendSignalAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VirtualTable
implements IVirtualOperationTable {
    private List<EOperation> fOperations;

    protected VirtualTable() {
    }

    protected abstract EOperation getOwningOperation();

    public void addOperation(EOperation operation) {
        if (operation == null) {
            throw new IllegalArgumentException();
        }
        if (this.fOperations == null) {
            this.fOperations = new LinkedList<EOperation>();
        }
        if (!this.fOperations.contains(operation)) {
            this.fOperations.add(operation);
        }
    }

    @Override
    public EOperation lookupActualOperation(EClassifier actualContextType, Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> env, InternalEvaluationEnv evalEnv) {
        return this.lookupActualOperation(actualContextType, env, null, evalEnv);
    }

    @Override
    public EOperation lookupActualOperation(EClassifier actualContextType, Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> env, Module scope, InternalEvaluationEnv evalEnv) {
        if (actualContextType == null || env == null) {
            throw new IllegalArgumentException();
        }
        EOperation formalOperation = this.getOwningOperation();
        if (formalOperation == null) {
            return null;
        }
        if (env.getUMLReflection().getOwningClassifier((Object)formalOperation) == actualContextType) {
            return formalOperation;
        }
        Collection<EOperation> candidateOperations = QvtOperationalUtil.filterOverriddenOperations(this.getOperations());
        for (EOperation nextOperation : candidateOperations) {
            if (env.getUMLReflection().getOwningClassifier((Object)nextOperation) != actualContextType || !this.isOperationInScope(nextOperation, evalEnv)) continue;
            return nextOperation;
        }
        if (actualContextType instanceof EClass) {
            for (EClass superClass : ((EClass)actualContextType).getESuperTypes()) {
                EOperation superOperation = this.lookupActualOperation((EClassifier)superClass, env, scope, evalEnv);
                if (superOperation == null) continue;
                return superOperation;
            }
        }
        return null;
    }

    public Collection<EOperation> getOperations() {
        return this.fOperations != null ? this.fOperations : Collections.emptySet();
    }

    private boolean isOperationInScope(EOperation operation, InternalEvaluationEnv evalEnv) {
        if (evalEnv != null && operation != null) {
            Module module = QvtOperationalParserUtil.getOwningModule(operation);
            if (module != null) {
                ThisInstanceResolver thisResolver = evalEnv.getThisResolver();
                return thisResolver != null && thisResolver.getThisInstanceOf(module) != null;
            }
            return true;
        }
        return false;
    }
}

