/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.jdt.debug.ui.launch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.m2m.internal.qvt.oml.jdt.debug.ui.launch.QVTOApplicationConfiguration;
import org.eclipse.m2m.qvt.oml.debug.core.QVTODebugCore;
import org.eclipse.m2m.qvt.oml.debug.core.QVTODebugTarget;
import org.eclipse.m2m.qvt.oml.debug.core.app.SocketUtil;
import org.eclipse.m2m.qvt.oml.debug.core.vm.IQVTOVirtualMachineShell;
import org.eclipse.m2m.qvt.oml.debug.core.vm.QVTOVirtualMachineProxy;

public class QVTODebugApplicationConfiguration
extends QVTOApplicationConfiguration {
    private int fPort = -1;

    public String[] getProgramArguments(ILaunchConfiguration configuration) throws CoreException {
        String[] programArguments = super.getProgramArguments(configuration);
        ArrayList<String> result = new ArrayList<String>(Arrays.asList(programArguments));
        result.add(QVTODebugApplicationConfiguration.createArgStr("-port", String.valueOf(this.getPort())));
        return result.toArray(new String[result.size()]);
    }

    ILaunchConfiguration validateLaunchConfiguration(ILaunchConfiguration configuration) {
        try {
            ILaunchConfigurationWorkingCopy workingCopy = configuration.getWorkingCopy();
            workingCopy.setAttribute("application", "org.eclipse.m2m.qvt.oml.debug.core.QVTODebugApplication");
            return workingCopy.doSave();
        }
        catch (CoreException e) {
            QVTODebugCore.log((IStatus)e.getStatus());
            return configuration;
        }
    }

    public void launch(ILaunchConfiguration configuration, String mode, final ILaunch launch, IProgressMonitor monitor) throws CoreException {
        QVTOVirtualMachineProxy vm;
        super.launch(configuration, mode, launch, monitor);
        int port = this.getPort();
        if (port == -1) {
            throw new CoreException(QVTODebugCore.createStatus((int)4, (String)"Failed to find free debugging port"));
        }
        try {
            BasicMonitor connectMonitor = new BasicMonitor(){

                public boolean isCanceled() {
                    IProcess p = QVTODebugApplicationConfiguration.this.getProcess(launch);
                    return p != null ? p.isTerminated() : false;
                }
            };
            vm = new QVTOVirtualMachineProxy("localhost", port, (Monitor)connectMonitor);
        }
        catch (IOException e) {
            IProcess p = this.getProcess(launch);
            if (p != null && p.isTerminated() && p.getExitValue() != 0) {
                return;
            }
            throw new CoreException(QVTODebugCore.createStatus((int)4, (String)"Failed to connect to QVTO VM", (Throwable)e));
        }
        try {
            IProcess p = this.getProcess(launch);
            if (p == null) {
                return;
            }
            QVTODebugTarget debugTarget = new QVTODebugTarget(p, (IQVTOVirtualMachineShell)vm){

                protected URI computeBreakpointURI(URI sourceURI) {
                    URI platformPluginURI = QVTODebugCore.getDefault().resolvePlatformPluginURI(sourceURI);
                    if (platformPluginURI != null) {
                        return platformPluginURI;
                    }
                    if (sourceURI.isPlatformResource()) {
                        URI baseURI = URI.createURI((String)ResourcesPlugin.getWorkspace().getRoot().getLocationURI().toString());
                        return URI.createURI((String)(String.valueOf(baseURI.toString()) + sourceURI.toPlatformString(true)), (boolean)true);
                    }
                    return sourceURI;
                }
            };
            launch.addDebugTarget((IDebugTarget)debugTarget);
        }
        finally {
            this.fPort = -1;
        }
    }

    protected void reset() {
        super.reset();
        this.fPort = -1;
    }

    private int getPort() {
        if (this.fPort == -1) {
            this.fPort = SocketUtil.findFreePort();
        }
        return this.fPort;
    }
}

