/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtimperative.evaluation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.domain.ids.IdManager;
import org.eclipse.ocl.examples.domain.ids.OperationId;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.OperationCallExp;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtimperative.MiddlePropertyAssignment;
import org.eclipse.qvtd.pivot.qvtimperative.MiddlePropertyCallExp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QVTiTransformationAnalysis {
    @NonNull
    protected final MetaModelManager metaModelManager;
    @NonNull
    private Set<Type> allInstancesTypes = new HashSet<Type>();
    @NonNull
    private Map<Property, Integer> property2cacheIndex = new HashMap<Property, Integer>();

    public QVTiTransformationAnalysis(@NonNull MetaModelManager metaModelManager) {
        this.metaModelManager = metaModelManager;
    }

    public void analyzeTransformation(@NonNull Transformation transformation) {
        Class oclElementType = this.metaModelManager.getOclElementType();
        OperationId allInstancesOperationId = oclElementType.getTypeId().getOperationId(0, "allInstances", IdManager.getParametersId((TypeId[])new TypeId[0]));
        ArrayList<MiddlePropertyAssignment> middlePropertyAssignments = new ArrayList<MiddlePropertyAssignment>();
        TreeIterator tit = transformation.eAllContents();
        while (tit.hasNext()) {
            Type sourceType;
            OCLExpression source;
            OperationCallExp operationCallExp;
            Operation referredOperation;
            EObject eObject = (EObject)tit.next();
            if (eObject instanceof MiddlePropertyCallExp) {
                MiddlePropertyCallExp middlePropertyCallExp = (MiddlePropertyCallExp)eObject;
                Property navigableProperty = middlePropertyCallExp.getReferredProperty();
                if (navigableProperty == null) continue;
                int cacheIndex = this.getCacheIndex(navigableProperty);
                middlePropertyCallExp.setCacheIndex(cacheIndex);
                continue;
            }
            if (eObject instanceof MiddlePropertyAssignment) {
                middlePropertyAssignments.add((MiddlePropertyAssignment)eObject);
                continue;
            }
            if (!(eObject instanceof OperationCallExp) || (referredOperation = (operationCallExp = (OperationCallExp)eObject).getReferredOperation()) == null || referredOperation.getOperationId() != allInstancesOperationId || (source = operationCallExp.getSource()) == null || (sourceType = source.getType()) == null) continue;
            this.allInstancesTypes.add(sourceType);
        }
        for (MiddlePropertyAssignment middlePropertyAssignment : middlePropertyAssignments) {
            Integer cacheIndex;
            Property navigableProperty = middlePropertyAssignment.getTargetProperty();
            if (navigableProperty == null || (cacheIndex = this.property2cacheIndex.get(navigableProperty)) == null) continue;
            middlePropertyAssignment.setCacheIndex(cacheIndex);
        }
    }

    @NonNull
    public Set<Type> getAllInstancesTypes() {
        return this.allInstancesTypes;
    }

    protected int getCacheIndex(@NonNull Property navigableProperty) {
        Integer cacheIndex = this.property2cacheIndex.get(navigableProperty);
        if (cacheIndex == null) {
            cacheIndex = this.property2cacheIndex.size();
            this.property2cacheIndex.put(navigableProperty, cacheIndex);
        }
        return cacheIndex;
    }

    public int getCacheIndexes() {
        return this.property2cacheIndex.size();
    }

    @NonNull
    public MetaModelManager getMetaModelManager() {
        return this.metaModelManager;
    }
}

