/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtimperative.evaluation;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainTypedElement;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtcorebase.Area;
import org.eclipse.qvtd.pivot.qvtcorebase.BottomPattern;
import org.eclipse.qvtd.pivot.qvtcorebase.CoreDomain;
import org.eclipse.qvtd.pivot.qvtimperative.Mapping;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiAbstractTracingEvaluationVisitor;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiEvaluationVisitor;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiModelManager;

public class QVTiTracingEvaluationVisitor
extends QVTiAbstractTracingEvaluationVisitor {
    protected static final String DEFAULT_INDENT = "  ";
    static int VERBOSE_LEVEL_LOW = 0;
    static int VERBOSE_LEVEL_MED = 1;
    static int VERBOSE_LEVEL_HIGH = 2;
    private int indentLevel = 0;

    public QVTiTracingEvaluationVisitor(@NonNull QVTiEvaluationVisitor decorated) {
        this(decorated, 0);
    }

    protected QVTiTracingEvaluationVisitor(@NonNull QVTiEvaluationVisitor decorated, int indentLevel) {
        super(decorated);
        this.indentLevel = indentLevel;
    }

    @NonNull
    public QVTiEvaluationVisitor createNestedEvaluator() {
        return new QVTiTracingEvaluationVisitor(super.createNestedEvaluator(), this.indentLevel);
    }

    @Nullable
    public Object visitBottomPattern(@NonNull BottomPattern bottomPattern) {
        if (bottomPattern.getArea() instanceof CoreDomain) {
            logger.info((Object)(String.valueOf(this.getIndent()) + "Visiting CoreDomain BottomPattern"));
        }
        if (bottomPattern.getArea() instanceof Mapping) {
            logger.info((Object)(String.valueOf(this.getIndent()) + "Visiting Mapping BottomPattern"));
        }
        ++this.indentLevel;
        Object result = ((QVTiEvaluationVisitor)this.delegate).visitBottomPattern(bottomPattern);
        if (bottomPattern.getArea() instanceof Mapping) {
            for (Domain d : ((Mapping)bottomPattern.getArea()).getDomain()) {
                logger.info((Object)(String.valueOf(this.getIndent()) + "RealizedVariables for CoreDomain " + d.getName()));
                ++this.indentLevel;
                for (Variable v : ((Area)d).getBottomPattern().getRealizedVariable()) {
                    logger.info((Object)(String.valueOf(this.getIndent()) + "RealizedVariable " + v.getName() + ": " + this.prettyPrint(((QVTiEvaluationVisitor)this.delegate).getEvaluationEnvironment().getValueOf((DomainTypedElement)v))));
                }
                --this.indentLevel;
            }
        }
        --this.indentLevel;
        if (bottomPattern.getArea() instanceof Mapping && verboseLevel == VERBOSE_LEVEL_HIGH) {
            logger.info((Object)"==============================");
            logger.info((Object)"Output Model");
            TypedModel tm = ((Domain)((Mapping)bottomPattern.getArea()).getDomain().get(0)).getTypedModel();
            for (EObject eo : ((QVTiModelManager)((QVTiEvaluationVisitor)this.delegate).getModelManager()).getTypeModelEObjectList(tm)) {
                logger.info((Object)this.prettyPrintUnident(eo));
            }
            logger.info((Object)"==============================");
        }
        return result;
    }
}

