/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.text.atl;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.m2m.atl.adt.ui.editor.AtlEditor;
import org.eclipse.m2m.atl.adt.ui.text.atl.AtlModelAnalyser;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.AtlTypesProcessor;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.OclAnyType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.UnitType;
import org.eclipse.m2m.atl.engine.parser.AtlSourceManager;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.osgi.framework.Bundle;

public final class OpenDeclarationUtils {
    private OpenDeclarationUtils() {
    }

    public static OclAnyType getType(AtlEditor editor, int offset, int length) throws BadLocationException {
        int[] savePosition;
        int savedOffset = offset;
        if (editor.isDirty() && (savePosition = editor.getComparator().current2savePosition(new int[]{offset, offset + length})) != null) {
            savedOffset = savePosition[0];
        }
        AtlSourceManager manager = editor.getSourceManager();
        AtlModelAnalyser analyser = editor.getModelAnalyser();
        EObject locatedElement = analyser.getLocatedElement(savedOffset);
        if (locatedElement != null) {
            IFileEditorInput editorInput = (IFileEditorInput)editor.getEditorInput();
            AtlTypesProcessor processor = new AtlTypesProcessor();
            processor.update(editorInput.getFile(), analyser, manager);
            return processor.getType(locatedElement);
        }
        return null;
    }

    public static String getInformation(AtlEditor editor, int offset, int length) throws BadLocationException {
        int[] savePosition;
        int savedOffset = offset;
        if (editor.isDirty() && (savePosition = editor.getComparator().current2savePosition(new int[]{offset, offset + length})) != null) {
            savedOffset = savePosition[0];
        }
        AtlSourceManager manager = editor.getSourceManager();
        AtlModelAnalyser analyser = editor.getModelAnalyser();
        EObject locatedElement = analyser.getLocatedElement(savedOffset);
        if (locatedElement != null) {
            IFileEditorInput editorInput = (IFileEditorInput)editor.getEditorInput();
            AtlTypesProcessor processor = new AtlTypesProcessor();
            processor.update(editorInput.getFile(), analyser, manager);
            return processor.getInformation(locatedElement);
        }
        return null;
    }

    public static Object getDeclaration(AtlEditor editor, int offset, int length) throws BadLocationException {
        int[] savePosition;
        int savedOffset = offset;
        if (editor.isDirty() && (savePosition = editor.getComparator().current2savePosition(new int[]{offset, offset + length})) != null) {
            savedOffset = savePosition[0];
        }
        AtlSourceManager manager = editor.getSourceManager();
        AtlModelAnalyser analyser = editor.getModelAnalyser();
        EObject locatedElement = analyser.getLocatedElement(savedOffset);
        if (locatedElement != null) {
            IFileEditorInput editorInput = (IFileEditorInput)editor.getEditorInput();
            AtlTypesProcessor processor = new AtlTypesProcessor();
            processor.update(editorInput.getFile(), analyser, manager);
            return processor.getDeclaration(locatedElement);
        }
        return null;
    }

    public static void openDeclaration(UnitType unit, EObject target, AtlEditor editor) throws BadLocationException {
        if (target instanceof EClassifier || target instanceof EStructuralFeature || target instanceof EOperation) {
            OpenDeclarationUtils.showEObject(editor.getSite().getPage(), target.eResource().getURI(), target);
        } else {
            AtlEditor atlEditor;
            int[] location;
            AtlEditor targetEditor = null;
            if (unit != null && unit.getFile() != null && !unit.getFile().equals((Object)((IFileEditorInput)editor.getEditorInput()).getFile())) {
                IWorkbenchPage page = editor.getSite().getPage();
                IEditorDescriptor editorDescriptor = page.getWorkbenchWindow().getWorkbench().getEditorRegistry().findEditor("org.eclipse.m2m.atl.adt.editor.AtlEditor");
                if (editorDescriptor != null) {
                    try {
                        targetEditor = page.openEditor((IEditorInput)new FileEditorInput(unit.getFile()), editorDescriptor.getId());
                    }
                    catch (PartInitException partInitException) {}
                }
            } else {
                targetEditor = editor;
            }
            if (targetEditor instanceof AtlEditor && (location = (atlEditor = targetEditor).getModelAnalyser().getHelper().getElementOffsets(target, 0)) != null) {
                if (!atlEditor.isDirty()) {
                    atlEditor.selectAndReveal(location[0], location[1] - location[0]);
                } else {
                    int[] newLocation = atlEditor.getComparator().save2currentPosition(location);
                    atlEditor.selectAndReveal(newLocation[0], newLocation[1] - newLocation[0]);
                }
            }
        }
    }

    public static void showEObject(IWorkbenchPage page, URI fileURI, EObject eObject) {
        URI newFileURI;
        IWorkbench workbench = page.getWorkbenchWindow().getWorkbench();
        if (fileURI != null && eObject != null && (newFileURI = OpenDeclarationUtils.formatURI(fileURI)) != null) {
            String lastSegment;
            IEditorDescriptor editorDescriptor;
            Object fileObject = OpenDeclarationUtils.getIFileXorIOFile(newFileURI);
            if (fileObject instanceof IFile) {
                newFileURI = URI.createPlatformResourceURI((String)((IFile)fileObject).getFullPath().toString(), (boolean)false);
            }
            if ((editorDescriptor = (lastSegment = newFileURI.lastSegment()).endsWith(".ecore") || lastSegment.endsWith(".xmi") || lastSegment.endsWith(".uml") ? OpenDeclarationUtils.getXMIEditor() : workbench.getEditorRegistry().getDefaultEditor(lastSegment)) != null) {
                try {
                    IEditorPart newEditor = page.openEditor((IEditorInput)new URIEditorInput(newFileURI), editorDescriptor.getId());
                    OpenDeclarationUtils.selectAndReveal(newEditor, eObject);
                }
                catch (PartInitException partInitException) {
                    // empty catch block
                }
            }
        }
    }

    private static void selectAndReveal(IEditorPart newEditor, EObject eObject) {
        IEditingDomainProvider editor = (IEditingDomainProvider)newEditor;
        String eObjectFragmentURI = eObject.eResource().getURIFragment(eObject);
        if (editor.getEditingDomain() != null && editor.getEditingDomain().getResourceSet() != null && editor.getEditingDomain().getResourceSet().getResources().size() > 0 && eObjectFragmentURI != null) {
            EObject newObject = ((Resource)editor.getEditingDomain().getResourceSet().getResources().get(0)).getEObject(eObjectFragmentURI);
            if (editor instanceof IViewerProvider) {
                OpenDeclarationUtils.setSelectionToViewer(newObject, ((IViewerProvider)editor).getViewer());
            }
        }
    }

    private static URI formatURI(URI fileURI) {
        if (fileURI.toString().startsWith("http")) {
            IConfigurationElement member;
            int j;
            IConfigurationElement[] members;
            IExtension extension;
            int i;
            IExtension[] extensions;
            URI result = null;
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.emf.ecore.generated_package");
            if (extensionPoint != null && extensionPoint.getExtensions().length > 0) {
                extensions = extensionPoint.getExtensions();
                i = 0;
                while (result == null && i < extensions.length) {
                    extension = extensions[i];
                    members = extension.getConfigurationElements();
                    j = 0;
                    while (result == null && j < members.length) {
                        member = members[j];
                        String mURI = member.getAttribute("uri");
                        String genModelPath = member.getAttribute("genModel");
                        String bundleID = member.getNamespaceIdentifier();
                        if (mURI != null && mURI.equals(fileURI.toString()) && Platform.getBundle((String)bundleID) != null && genModelPath != null) {
                            String ecoreName = new Path(genModelPath).removeFileExtension().addFileExtension("ecore").lastSegment();
                            result = OpenDeclarationUtils.findEcore(Platform.getBundle((String)bundleID), ecoreName);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            extensionPoint = registry.getExtensionPoint("org.eclipse.emf.ecore.uri_mapping");
            if (result == null && extensionPoint != null && extensionPoint.getExtensions().length > 0) {
                extensions = extensionPoint.getExtensions();
                i = 0;
                while (result == null && i < extensions.length) {
                    extension = extensions[i];
                    members = extension.getConfigurationElements();
                    j = 0;
                    while (result == null && j < members.length) {
                        member = members[j];
                        String sourceURI = member.getAttribute("source");
                        String targetURI = member.getAttribute("target");
                        if (sourceURI != null && sourceURI.equals(fileURI.toString()) && targetURI != null) {
                            result = URI.createURI((String)targetURI, (boolean)false);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            return result;
        }
        return fileURI;
    }

    private static URI findEcore(Bundle bundle, String ecoreName) {
        Enumeration entries = bundle.findEntries("/", ecoreName, true);
        if (entries != null) {
            while (entries.hasMoreElements()) {
                URL entry = (URL)entries.nextElement();
                if (entry == null) continue;
                IPath path = new Path(bundle.getSymbolicName()).append(entry.getPath());
                return URI.createPlatformPluginURI((String)path.toString(), (boolean)false);
            }
        }
        return null;
    }

    private static IEditorDescriptor getXMIEditor() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IEditorDescriptor editorDescriptor = workbench.getEditorRegistry().findEditor("org.eclipse.emf.ecore.presentation.EcoreEditorID");
        if (editorDescriptor == null && (editorDescriptor = workbench.getEditorRegistry().getDefaultEditor("Ecore.ecore")) == null) {
            editorDescriptor = workbench.getEditorRegistry().getDefaultEditor("Ecore.xmi");
        }
        return editorDescriptor;
    }

    private static void setSelectionToViewer(final EObject selectedEObject, final Viewer viewer) {
        if (selectedEObject != null && viewer != null) {
            Runnable runnable = new Runnable(){

                public void run() {
                    viewer.setSelection((ISelection)new StructuredSelection((Object)selectedEObject), true);
                }
            };
            viewer.getControl().getDisplay().asyncExec(runnable);
        }
    }

    public static Object getIFileXorIOFile(URI fileURI) {
        IFile tmpFile;
        String absolutePath;
        IFile workspaceFile = null;
        File absoluteFile = null;
        String platformString = fileURI.toPlatformString(true);
        Path platformPath = platformString != null ? new Path(platformString) : null;
        if (platformPath != null && platformPath.segmentCount() > 1) {
            if (ResourcesPlugin.getWorkspace().getRoot().exists((IPath)platformPath)) {
                workspaceFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)platformPath);
            } else {
                String pluginName = platformPath.segment(0);
                Bundle bundle = Platform.getBundle((String)pluginName);
                if (bundle != null) {
                    absoluteFile = OpenDeclarationUtils.getAbsoluteFile(bundle, platformPath.removeFirstSegments(1).toString());
                }
            }
        }
        if ((absolutePath = fileURI.toFileString()) != null) {
            absoluteFile = new File(absolutePath);
        }
        if (workspaceFile == null && fileURI.isFile() && absoluteFile != null && (tmpFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(absolutePath))) != null && tmpFile.exists()) {
            workspaceFile = tmpFile;
        }
        if (absoluteFile != null && !absoluteFile.exists()) {
            absoluteFile = null;
        }
        if (workspaceFile != null) {
            return workspaceFile;
        }
        return absoluteFile;
    }

    private static File getAbsoluteFile(Bundle bundle, String entryPath) {
        File absoluteFile;
        block5: {
            URL entry = bundle.getEntry(entryPath);
            if (entry != null) {
                try {
                    entry = FileLocator.toFileURL((URL)entry);
                    if (entry != null) {
                        absoluteFile = new Path(entry.getPath()).toFile();
                        break block5;
                    }
                    absoluteFile = null;
                }
                catch (IOException e1) {
                    absoluteFile = null;
                }
            } else {
                absoluteFile = null;
            }
        }
        return absoluteFile;
    }

    public static IRegion findWord(IDocument document, int offset) {
        int start = -2;
        int end = -1;
        try {
            char c;
            int pos = offset;
            while (pos >= 0) {
                c = document.getChar(pos);
                if (!OpenDeclarationUtils.isAtlIdentifierPart(c)) break;
                --pos;
            }
            start = pos;
            pos = offset;
            int length = document.getLength();
            while (pos < length) {
                c = document.getChar(pos);
                if (!OpenDeclarationUtils.isAtlIdentifierPart(c)) break;
                ++pos;
            }
            end = pos;
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (start >= -1 && end > -1) {
            if (start == offset && end == offset) {
                return new Region(offset, 0);
            }
            if (start == offset) {
                return new Region(start, end - start);
            }
            return new Region(start + 1, end - start - 1);
        }
        return null;
    }

    private static boolean isAtlIdentifierPart(char ch) {
        return !Character.isWhitespace(ch) && ch != '.' && ch != '(' && ch != ')' && ch != '{' && ch != '}' && ch != '.' && ch != ';' && ch != ',' && ch != ':' && ch != '|' && ch != '+' && ch != '-' && ch != '<' && ch != '=' && ch != '>' && ch != '*' && ch != '/' && ch != '!';
    }
}

