/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.debug.core.ocl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.m2m.atl.adt.debug.core.ocl.OclEvaluator;
import org.eclipse.m2m.atl.engine.vm.ASM;
import org.eclipse.m2m.atl.engine.vm.ASMExecEnv;
import org.eclipse.m2m.atl.engine.vm.ASMOperation;
import org.eclipse.m2m.atl.engine.vm.ASMStackFrame;
import org.eclipse.m2m.atl.engine.vm.Debugger;
import org.eclipse.m2m.atl.engine.vm.SimpleDebugger;
import org.eclipse.m2m.atl.engine.vm.StackFrame;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModule;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclAny;

public class OclHelper
extends OclEvaluator {
    private String helper;
    private List parameters;
    private ASM compiledHelper;

    public OclHelper(String helper, List parameters) {
        this.helper = helper;
        this.parameters = parameters;
        this.compiledHelper = null;
    }

    public static ASMOclAny eval(String helper, Map arguments) throws Exception {
        ArrayList params = new ArrayList(arguments.keySet());
        ArrayList args = new ArrayList();
        Iterator i = params.iterator();
        while (i.hasNext()) {
            args.add(arguments.get(i.next()));
        }
        OclHelper oh = new OclHelper(helper, params);
        return oh.eval(args);
    }

    public ASM compile() throws IOException {
        String params = "";
        Iterator i = this.parameters.iterator();
        while (i.hasNext()) {
            if (!params.equals("")) {
                params = String.valueOf(params) + ", ";
            }
            params = String.valueOf(params) + i.next() + " : OclAny";
        }
        String query = "library test; helper def: test(" + params + ") : OclAny = " + this.helper + ";";
        this.compiledHelper = this.compile(query);
        return this.compiledHelper;
    }

    public ASMOclAny eval(List arguments) throws Exception {
        return this.eval(arguments, Collections.EMPTY_MAP);
    }

    public ASMOclAny eval(List arguments, Map models) throws Exception {
        ASMOclAny ret = null;
        ArrayList<ASMModule> computationArguments = new ArrayList<ASMModule>(arguments);
        if (this.compiledHelper == null) {
            this.compile();
        }
        SimpleDebugger debugger = new SimpleDebugger(false, new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), true, false);
        ASMOperation op = this.compiledHelper.getOperation("test");
        ASMModule asmModule = new ASMModule(this.compiledHelper);
        computationArguments.add(0, asmModule);
        ASMExecEnv env = new ASMExecEnv(asmModule, (Debugger)debugger);
        for (String mname : models.keySet()) {
            env.addModel(mname, (ASMModel)models.get(mname));
        }
        env.registerOperations(this.compiledHelper);
        ASMStackFrame frame = ASMStackFrame.rootFrame((ASMExecEnv)env, (ASMOperation)op, computationArguments);
        ret = op.exec((StackFrame)frame);
        return ret;
    }
}

