/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.asm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.engine.asm.ASM;
import org.eclipse.m2m.atl.engine.asm.ASMInstruction;
import org.eclipse.m2m.atl.engine.asm.ASMInstructionWithOperand;
import org.eclipse.m2m.atl.engine.asm.ASMParameter;

public class ASMOperation {
    private static Pattern pattern1 = Pattern.compile("^.*\\(");
    private static Pattern simple = Pattern.compile("^J|I|B|S|D|A|(M|N)[^;]*;|L");
    private static Pattern pattern2 = Pattern.compile("^(Q|G|C|E|O).*");
    private Map lineNumberEntries = new HashMap();
    private String lastLNE;
    private Map localVariableEntries = new HashMap();
    private List slots = new ArrayList();
    private String name;
    private String context;
    private List parameters = new ArrayList();
    private List instructions = new ArrayList();
    private Map labels = new HashMap();
    private List lineNumberTable = new ArrayList();
    private List localVariableTable = new ArrayList();
    private ASM asm;

    public ASMOperation(ASM asm, String name) {
        this.name = name;
        this.asm = asm;
    }

    public String getName() {
        return this.name;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getContextSignature() {
        return this.context;
    }

    public void addParameter(ASMParameter parameter) {
        this.parameters.add(parameter);
    }

    public List getParameters() {
        return this.parameters;
    }

    public void addInstruction(ASMInstruction instruction) {
        this.instructions.add(instruction);
    }

    public void addLabeledInstruction(ASMInstructionWithOperand instruction, String labelName) {
        int index;
        this.instructions.add(instruction);
        Label label = (Label)this.labels.get(labelName);
        if (label == null) {
            label = new Label(labelName);
            this.labels.put(labelName, label);
        }
        if ((index = label.getIndex()) != -1) {
            instruction.setOperand("" + index);
        } else {
            label.addInstruction(instruction);
        }
    }

    public List getInstructions() {
        return this.instructions;
    }

    public void addLabel(String labelName) {
        Label label = (Label)this.labels.get(labelName);
        if (label == null) {
            label = new Label(labelName);
            this.labels.put(labelName, label);
        }
        label.setIndex(this.instructions.size());
    }

    public void addVariableInstruction(ASMInstructionWithOperand instruction, String varId) {
        LocalVariableEntry lve = (LocalVariableEntry)this.localVariableEntries.get(varId);
        if (lve == null) {
            ATLLogger.severe((String)("No slot reserved for variable: " + varId + " used at " + this.lastLNE + "."));
        } else {
            instruction.setOperand("" + lve.slot);
            this.instructions.add(instruction);
        }
    }

    public String getSignature() {
        return "<TODO>";
    }

    public String toString() {
        StringBuffer ret = new StringBuffer(this.context);
        ret.append(".");
        ret.append(this.name);
        ret.append("(");
        Iterator i = this.parameters.iterator();
        while (i.hasNext()) {
            ret.append(i.next());
            if (!i.hasNext()) continue;
            ret.append(", ");
        }
        ret.append(") : ??");
        return ret.toString();
    }

    private static int getNbArgs(String s) {
        int ret = 0;
        s = pattern1.matcher(s).replaceFirst("");
        while (!s.startsWith(")") && s.length() > 0) {
            ++ret;
            s = ASMOperation.removeFirst(s);
        }
        return ret;
    }

    private static String removeFirst(String s) {
        if (s.startsWith("T")) {
            s = s.substring(1);
            while (!s.startsWith(";")) {
                s = ASMOperation.removeFirst(s);
            }
            s = s.substring(1);
        } else {
            s = pattern2.matcher(s).matches() ? ASMOperation.removeFirst(s.substring(1)) : simple.matcher(s).replaceFirst("");
        }
        return s;
    }

    private static String getOpName(String s) {
        return s.substring(s.indexOf(".") + 1, s.indexOf("("));
    }

    public void beginLineNumberEntry(String id) {
        this.lastLNE = id;
        this.lineNumberEntries.put(id, new LineNumberEntry(id, this.instructions.size(), -1));
    }

    public void endLineNumberEntry(String id) {
        LineNumberEntry lne = (LineNumberEntry)this.lineNumberEntries.remove(id);
        lne.end = this.instructions.size() - 1;
        this.lineNumberTable.add(lne);
    }

    public void addLineNumberEntry(String id, int begin, int end) {
        this.lineNumberTable.add(new LineNumberEntry(id, begin, end));
    }

    public List getLineNumberTable() {
        return this.lineNumberTable;
    }

    public String resolveLineNumber(int l) {
        String ret = null;
        Iterator i = this.lineNumberTable.iterator();
        while (i.hasNext() && ret == null) {
            LineNumberEntry lne = (LineNumberEntry)i.next();
            if (l < lne.begin || l > lne.end) continue;
            ret = lne.id;
        }
        return ret;
    }

    public int beginLocalVariableEntry(String id, String name) {
        LocalVariableEntry lve = (LocalVariableEntry)this.localVariableEntries.get(id);
        if (lve != null) {
            throw new Error("variable id already in use: " + id);
        }
        int slot = this.reserveSlot();
        this.localVariableEntries.put(id, new LocalVariableEntry(slot, name, this.instructions.size(), -1));
        return slot;
    }

    public int endLocalVariableEntry(String id) {
        LocalVariableEntry lve = (LocalVariableEntry)this.localVariableEntries.remove(id);
        if (lve == null) {
            ATLLogger.severe((String)("Variable id not defined: " + id));
            return -1;
        }
        lve.end = this.instructions.size() - 1;
        this.localVariableTable.add(lve);
        this.freeSlot(lve.slot);
        return lve.slot;
    }

    public void addLocalVariableEntry(int slot, String name, int begin, int end) {
        this.localVariableTable.add(new LocalVariableEntry(slot, name, begin, end));
    }

    public List getLocalVariableTable() {
        return this.localVariableTable;
    }

    public String resolveVariableName(int slot, int l) {
        String ret = null;
        Iterator i = this.localVariableTable.iterator();
        while (i.hasNext() & ret == null) {
            LocalVariableEntry lve = (LocalVariableEntry)i.next();
            if (slot != lve.slot || l < lve.begin || l > lve.end) continue;
            ret = lve.name;
        }
        return ret;
    }

    public ASM getASM() {
        return this.asm;
    }

    private int reserveSlot() {
        int ret = -1;
        int i = 0;
        while (i < this.slots.size() && ret == -1) {
            if (!((Boolean)this.slots.get(i)).booleanValue()) {
                ret = i;
                this.slots.set(ret, new Boolean(true));
            }
            ++i;
        }
        if (ret == -1) {
            ret = this.slots.size();
            this.slots.add(new Boolean(true));
        }
        return ret;
    }

    private void freeSlot(int slot) {
        this.slots.set(slot, new Boolean(false));
    }

    private class Label {
        private String name;
        private int index = -1;
        private ArrayList instr = new ArrayList();

        public Label(String name) {
            this.name = name;
        }

        public int getIndex() {
            return this.index;
        }

        public void addInstruction(ASMInstruction i) {
            this.instr.add(i);
        }

        public void setIndex(int index) {
            this.index = index;
            String id = "" + index;
            Iterator i = this.instr.iterator();
            while (i.hasNext()) {
                ((ASMInstructionWithOperand)i.next()).setOperand(id);
            }
        }

        public String getName() {
            return this.name;
        }
    }

    public class LineNumberEntry {
        public String id;
        public int begin;
        public int end;

        public LineNumberEntry(String id, int begin, int end) {
            this.id = id;
            this.begin = begin;
            this.end = end;
        }
    }

    public class LocalVariableEntry {
        public int slot;
        public String name;
        public int begin;
        public int end;

        public LocalVariableEntry(int slot, String name, int begin, int end) {
            this.slot = slot;
            this.name = name;
            this.begin = begin;
            this.end = end;
        }
    }
}

