/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.asm;

import java.io.PrintWriter;
import java.util.Iterator;
import org.eclipse.m2m.atl.engine.asm.ASM;
import org.eclipse.m2m.atl.engine.asm.ASMField;
import org.eclipse.m2m.atl.engine.asm.ASMInstruction;
import org.eclipse.m2m.atl.engine.asm.ASMInstructionWithOperand;
import org.eclipse.m2m.atl.engine.asm.ASMOperation;
import org.eclipse.m2m.atl.engine.asm.ASMParameter;
import org.eclipse.m2m.atl.engine.asm.ASMWriter;

public class ASMTextualWriter
extends ASMWriter {
    private PrintWriter out;

    public ASMTextualWriter(PrintWriter out) {
        this.out = out;
    }

    public void print(ASM asm) {
        this.printASM(asm);
    }

    private void printASM(ASM asm) {
        String name = asm.getName();
        this.out.println("asm " + name + " {");
        this.out.println();
        Iterator i = asm.getFields().iterator();
        while (i.hasNext()) {
            this.printField((ASMField)i.next());
        }
        i = asm.getOperations().iterator();
        while (i.hasNext()) {
            this.printOperation((ASMOperation)i.next());
        }
        this.out.println("}");
    }

    private void printField(ASMField f) {
        String name = f.getName();
        String type = f.getType();
        this.out.println("\tdef: " + name + " : " + type + ";");
        this.out.println();
    }

    private void printOperation(ASMOperation op) {
        String name = op.getName();
        String context = op.getContextSignature();
        this.out.print("\tcontext " + context + " def: " + name + "(");
        Iterator i = op.getParameters().iterator();
        while (i.hasNext()) {
            this.printParameter(op, (ASMParameter)i.next());
            if (!i.hasNext()) continue;
            this.out.print(", ");
        }
        this.out.println(") {");
        int k = 0;
        Iterator i2 = op.getInstructions().iterator();
        while (i2.hasNext()) {
            this.out.print("\t\t" + this.conv(k) + ": ");
            this.printInstruction(op, (ASMInstruction)i2.next(), k++);
            String location = op.resolveLineNumber(k - 1);
            if (location != null) {
                this.out.print("\t\t// " + location);
            }
            this.out.println();
        }
        this.out.println("\t}");
        this.out.println();
    }

    private String conv(int i) {
        if (i < 10) {
            return "000" + i;
        }
        if (i < 100) {
            return "00" + i;
        }
        if (i < 1000) {
            return "0" + i;
        }
        return "" + i;
    }

    private void printParameter(ASMOperation op, ASMParameter param) {
        String name = op.resolveVariableName(Integer.parseInt(param.getName()), 0);
        String type = param.getType();
        this.out.print(String.valueOf(name) + " : " + type);
    }

    private void printInstruction(ASMOperation op, ASMInstruction instr, int index) {
        String mn = instr.getMnemonic();
        if (instr instanceof ASMInstructionWithOperand) {
            String operand = ((ASMInstructionWithOperand)instr).getOperand();
            if (mn.equals("load") || mn.equals("store")) {
                operand = op.resolveVariableName(Integer.parseInt(operand), index);
                this.out.print(String.valueOf(mn) + " " + operand + ";");
            } else {
                this.out.print(String.valueOf(mn) + " '" + operand + "';");
            }
        } else {
            this.out.print(String.valueOf(mn) + ";");
        }
    }
}

