/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.actions;

import java.util.ResourceBundle;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.m2m.atl.adt.ui.AtlUIPlugin;
import org.eclipse.m2m.atl.adt.ui.editor.AtlEditor;
import org.eclipse.m2m.atl.adt.ui.text.AtlHeuristicScanner;
import org.eclipse.m2m.atl.adt.ui.text.AtlIndenter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorExtension3;
import org.eclipse.ui.texteditor.TextEditorAction;

public class IndentAction
extends TextEditorAction {
    private int fCaretOffset;
    private final boolean fIsTabAction;

    public IndentAction(ResourceBundle bundle, String prefix, ITextEditor editor, boolean isTabAction) {
        super(bundle, prefix, editor);
        this.fIsTabAction = isTabAction;
    }

    private IDocument getDocument() {
        ITextEditor editor = this.getTextEditor();
        if (editor != null) {
            IDocumentProvider provider = editor.getDocumentProvider();
            IEditorInput input = editor.getEditorInput();
            if (provider != null && input != null) {
                return provider.getDocument((Object)input);
            }
        }
        return null;
    }

    private ITextSelection getSelection() {
        ISelection selection;
        ISelectionProvider provider = this.getSelectionProvider();
        if (provider != null && (selection = provider.getSelection()) instanceof ITextSelection) {
            return (ITextSelection)selection;
        }
        return TextSelection.emptySelection();
    }

    private ISelectionProvider getSelectionProvider() {
        ITextEditor editor = this.getTextEditor();
        if (editor != null) {
            return editor.getSelectionProvider();
        }
        return null;
    }

    private String getTabEquivalent() {
        String tab;
        if (AtlUIPlugin.getDefault().getPreferenceStore().getBoolean("Atl.Typing.SpacesForTabs")) {
            int size = AtlUIPlugin.getDefault().getPreferenceStore().getInt("tabWidth");
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < size) {
                buf.append(' ');
                ++i;
            }
            tab = buf.toString();
        } else {
            tab = "\t";
        }
        return tab;
    }

    private boolean indentLine(IDocument document, int line, int caret, AtlIndenter indenter, AtlHeuristicScanner scanner) throws BadLocationException {
        int lineLength;
        int end;
        int offset;
        IRegion currentLine = document.getLineInformation(line);
        int wsStart = offset = currentLine.getOffset();
        String indent = null;
        if (offset < document.getLength()) {
            ITypedRegion partition = TextUtilities.getPartition((IDocument)document, (String)"partitioning", (int)offset, (boolean)true);
            String type = partition.getType();
            if (type.equals("documentation") || type.equals("singleline_comment")) {
                int start = 0;
                if (line > 0) {
                    IRegion previousLine = document.getLineInformation(line - 1);
                    start = previousLine.getOffset() + previousLine.getLength();
                }
                DocumentCommand command = new DocumentCommand(){};
                command.text = "\n";
                command.offset = start;
                int to = 1;
                while (to < command.text.length() && Character.isWhitespace(command.text.charAt(to))) {
                    ++to;
                }
                indent = command.text.substring(1, to);
            } else if (!this.fIsTabAction && partition.getOffset() == offset && type.equals("singleline_comment")) {
                int slashes = 2;
                while (slashes < document.getLength() - 1 && document.get(offset + slashes, 2).equals("//")) {
                    slashes += 2;
                }
                wsStart = offset + slashes;
                StringBuffer computed = indenter.computeIndentation(offset);
                int tabSize = AtlUIPlugin.getDefault().getPreferenceStore().getInt("tabWidth");
                while (slashes > 0 && computed.length() > 0) {
                    char c = computed.charAt(0);
                    if (c == '\t') {
                        if (slashes <= tabSize) break;
                        slashes -= tabSize;
                    } else {
                        if (c != ' ') break;
                        --slashes;
                    }
                    computed.deleteCharAt(0);
                }
                indent = String.valueOf(document.get(offset, wsStart - offset)) + computed;
            }
        }
        if (indent == null) {
            StringBuffer computed = indenter.computeIndentation(offset);
            indent = computed != null ? computed.toString() : new String();
        }
        if ((end = scanner.findNonWhitespaceForwardInAnyPartition(wsStart, offset + (lineLength = currentLine.getLength()))) == -1) {
            end = offset + lineLength;
        }
        int length = end - offset;
        String currentIndent = document.get(offset, length);
        if (this.fIsTabAction && caret == end && this.whiteSpaceLength(currentIndent) >= this.whiteSpaceLength(indent)) {
            String tab = this.getTabEquivalent();
            document.replace(caret, 0, tab);
            this.fCaretOffset = caret + tab.length();
            return true;
        }
        this.fCaretOffset = caret >= offset && caret <= end ? offset + indent.length() : -1;
        if (!indent.equals(currentIndent)) {
            document.replace(offset, length, indent);
            if (this.fIsTabAction && indent.length() > currentIndent.length() && AtlUIPlugin.getDefault().getPreferenceStore().getBoolean("Atl.Editor.SmartBackspace")) {
                ITextEditor iTextEditor = this.getTextEditor();
            }
            return true;
        }
        return false;
    }

    private boolean isSmartMode() {
        ITextEditor editor = this.getTextEditor();
        if (editor instanceof ITextEditorExtension3) {
            return ((ITextEditorExtension3)editor).getInsertMode() == ITextEditorExtension3.SMART_INSERT;
        }
        return false;
    }

    private boolean isValidSelection() {
        ITextSelection selection = this.getSelection();
        if (selection.isEmpty()) {
            return false;
        }
        int offset = selection.getOffset();
        int length = selection.getLength();
        IDocument document = this.getDocument();
        if (document == null) {
            return false;
        }
        try {
            IRegion firstLine = document.getLineInformationOfOffset(offset);
            int lineOffset = firstLine.getOffset();
            if (length == 0) {
                return document.get(lineOffset, offset - lineOffset).trim().length() == 0;
            }
            return false;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    public void run() {
        if (!this.isEnabled() || !this.validateEditorInputState()) {
            return;
        }
        ITextSelection selection = this.getSelection();
        final IDocument document = this.getDocument();
        if (document != null) {
            int nLines;
            int firstLine;
            final int offset = selection.getOffset();
            final int length = selection.getLength();
            final Position end = new Position(offset + length);
            this.fCaretOffset = -1;
            try {
                document.addPosition(end);
                firstLine = document.getLineOfOffset(offset);
                int minusOne = length == 0 ? 0 : 1;
                nLines = document.getLineOfOffset(offset + length - minusOne) - firstLine + 1;
            }
            catch (BadLocationException e) {
                AtlUIPlugin.log(e);
                return;
            }
            Runnable runnable = new Runnable(){

                public void run() {
                    IRewriteTarget target = (IRewriteTarget)IndentAction.this.getTextEditor().getAdapter(IRewriteTarget.class);
                    if (target != null) {
                        target.beginCompoundChange();
                        target.setRedraw(false);
                    }
                    try {
                        try {
                            int newLength;
                            int newOffset;
                            AtlHeuristicScanner scanner = new AtlHeuristicScanner(document);
                            AtlIndenter indenter = new AtlIndenter(document, scanner);
                            boolean hasChanged = false;
                            int i = 0;
                            while (i < nLines) {
                                hasChanged |= IndentAction.this.indentLine(document, firstLine + i, offset, indenter, scanner);
                                ++i;
                            }
                            if (IndentAction.this.fIsTabAction) {
                                newOffset = IndentAction.this.fCaretOffset;
                                newLength = 0;
                            } else if (nLines > 1) {
                                newOffset = offset;
                                newLength = end.getOffset() - offset;
                            } else {
                                newOffset = IndentAction.this.fCaretOffset;
                                newLength = 0;
                            }
                            if (newOffset != -1 && (hasChanged || newOffset != offset || newLength != length)) {
                                IndentAction.this.selectAndReveal(newOffset, newLength);
                            }
                            document.removePosition(end);
                        }
                        catch (BadLocationException e) {
                            AtlUIPlugin.log(e);
                            if (target != null) {
                                target.endCompoundChange();
                                target.setRedraw(true);
                            }
                        }
                    }
                    finally {
                        if (target != null) {
                            target.endCompoundChange();
                            target.setRedraw(true);
                        }
                    }
                }
            };
            if (nLines > 50) {
                Display display = this.getTextEditor().getEditorSite().getWorkbenchWindow().getShell().getDisplay();
                BusyIndicator.showWhile((Display)display, (Runnable)runnable);
            } else {
                runnable.run();
            }
        }
    }

    private void selectAndReveal(int newOffset, int newLength) {
        Assert.isTrue((newOffset >= 0 ? 1 : 0) != 0);
        Assert.isTrue((newLength >= 0 ? 1 : 0) != 0);
        ITextEditor editor = this.getTextEditor();
        if (editor instanceof AtlEditor) {
            ISourceViewer viewer = ((AtlEditor)editor).getViewer();
            if (viewer != null) {
                viewer.setSelectedRange(newOffset, newLength);
            }
        } else {
            this.getTextEditor().selectAndReveal(newOffset, newLength);
        }
    }

    public void update() {
        super.update();
        if (this.isEnabled()) {
            if (this.fIsTabAction) {
                this.setEnabled(this.canModifyEditor() && this.isSmartMode() && this.isValidSelection());
            } else {
                this.setEnabled(this.canModifyEditor() && !this.getSelection().isEmpty());
            }
        }
    }

    private int whiteSpaceLength(String indent) {
        if (indent == null) {
            return 0;
        }
        int size = 0;
        int l = indent.length();
        int tabSize = AtlUIPlugin.getDefault().getPreferenceStore().getInt("tabWidth");
        int i = 0;
        while (i < l) {
            size += indent.charAt(i) == '\t' ? tabSize : 1;
            ++i;
        }
        return size;
    }
}

