/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.ecore.genmodel.util;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.codegen.ecore.generator.Generator;
import org.eclipse.emf.codegen.ecore.genmodel.GenAnnotation;
import org.eclipse.emf.codegen.ecore.genmodel.GenBase;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelFactory;
import org.eclipse.emf.codegen.merge.java.JControlModel;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenModelUtil {
    public static String getAnnotation(GenBase genBase, String sourceURI, String key) {
        GenAnnotation genAnnotation = genBase.getGenAnnotation(sourceURI);
        return genAnnotation == null ? null : (String)genAnnotation.getDetails().get((Object)key);
    }

    public static void setAnnotation(GenBase genBase, String sourceURI, String key, String value) {
        GenAnnotation genAnnotation = genBase.getGenAnnotation(sourceURI);
        if (genAnnotation == null) {
            genAnnotation = GenModelFactory.eINSTANCE.createGenAnnotation();
            genAnnotation.setSource(sourceURI);
            genBase.getGenAnnotations().add((Object)genAnnotation);
        }
        genAnnotation.getDetails().put((Object)key, (Object)value);
    }

    private static IJavaProject getJavaProject(GenModel genModel) {
        String modelDirectory = genModel.getModelDirectory();
        try {
            URI uri = URI.createURI((String)modelDirectory);
            IJavaProject javaProject = GenModelUtil.getJavaProject(uri);
            if (javaProject != null) {
                return javaProject;
            }
        }
        catch (Throwable uri) {
            // empty catch block
        }
        Resource resource = genModel.eResource();
        if (resource != null) {
            return GenModelUtil.getJavaProject(resource.getURI());
        }
        return null;
    }

    private static IJavaProject getJavaProject(URI uri) {
        IWorkspaceRoot workspaceRoot;
        String projectName = null;
        if (uri != null) {
            if (uri.isPlatformResource()) {
                projectName = uri.segment(1);
            } else if (uri.isHierarchical() && uri.segmentCount() > 1) {
                projectName = uri.segment(0);
            }
        }
        if (projectName != null && (workspaceRoot = EcorePlugin.getWorkspaceRoot()) != null) {
            IProject project = workspaceRoot.getProject(projectName);
            try {
                if (project.isAccessible() && project.hasNature("org.eclipse.jdt.core.javanature")) {
                    return JavaCore.create((IProject)project);
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Map<String, String> getJavaOptions(GenModel genModel) {
        IJavaProject javaProject = GenModelUtil.getJavaProject(genModel);
        Hashtable options = javaProject != null ? javaProject.getOptions(true) : JavaCore.getOptions();
        return options;
    }

    public static Generator createGenerator(GenModel genModel) {
        Generator generator = new Generator();
        generator.setInput(genModel);
        JControlModel jControlModel = generator.getJControlModel();
        if (genModel.isCodeFormatting()) {
            jControlModel.setLeadingTabReplacement(null);
            jControlModel.setConvertToStandardBraceStyle(false);
        } else {
            Map<String, String> options = GenModelUtil.getJavaOptions(genModel);
            String tabSize = options.get("org.eclipse.jdt.core.formatter.tabulation.size");
            String braceStyle = options.get("org.eclipse.jdt.core.formatter.brace_position_for_type_declaration");
            String tabCharacter = options.get("org.eclipse.jdt.core.formatter.tabulation.char");
            if ("tab".equals(tabCharacter)) {
                jControlModel.setLeadingTabReplacement("\t");
            } else {
                String spaces = "";
                int i = Integer.parseInt(tabSize);
                while (i > 0) {
                    spaces = String.valueOf(spaces) + " ";
                    --i;
                }
                jControlModel.setLeadingTabReplacement(spaces);
            }
            jControlModel.setConvertToStandardBraceStyle("end_of_line".equals(braceStyle));
        }
        return generator;
    }
}

