/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.example;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDCardinality;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDEnumerationFacet;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDFractionDigitsFacet;
import org.eclipse.xsd.XSDLengthFacet;
import org.eclipse.xsd.XSDMaxExclusiveFacet;
import org.eclipse.xsd.XSDMaxInclusiveFacet;
import org.eclipse.xsd.XSDMaxLengthFacet;
import org.eclipse.xsd.XSDMinExclusiveFacet;
import org.eclipse.xsd.XSDMinInclusiveFacet;
import org.eclipse.xsd.XSDMinLengthFacet;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTerm;
import org.eclipse.xsd.XSDTotalDigitsFacet;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDVariety;
import org.eclipse.xsd.XSDWhiteSpaceFacet;
import org.eclipse.xsd.XSDWildcard;
import org.eclipse.xsd.impl.XSDNamedComponentImpl;
import org.eclipse.xsd.util.XSDResourceFactoryImpl;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSDGenerateHTML
implements IApplication {
    public Map<String, String> schemaTypeToJavaClassMap;
    public Map<String, String> contentDocumentationMap;
    public Map<String, String> elementDeclarationMarkupMap;
    public Map<String, String> attributeDeclarationMarkupMap;
    public Map<XSDElementDeclaration, XSDElementDeclaration> specialAnchorMap;
    protected List<String> part1Anchors;
    List<String> part1Components;
    protected List<String> part2Anchors;
    protected List<String> part2Components;
    protected String errata;
    public static final String REQUIRES = "requires";
    public static final String ALLOWS = "allows";
    public static final String FUTURE = "future";
    public static final String NEVER = "never";

    public XSDGenerateHTML() {
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("xsd", new XSDResourceFactoryImpl());
        this.schemaTypeToJavaClassMap = new HashMap<String, String>();
        this.contentDocumentationMap = new HashMap<String, String>();
        this.elementDeclarationMarkupMap = new HashMap<String, String>();
        this.attributeDeclarationMarkupMap = new HashMap<String, String>();
        this.specialAnchorMap = new HashMap<XSDElementDeclaration, XSDElementDeclaration>();
        this.part1Anchors = Arrays.asList("all", "annotation", "any", "anyAttribute", "appinfo", "attribute", "attributeGroup", "choice", "complexContent", "complexContent::extension", "complexContent::restriction", "complexType", "documentation", "element", "field", "group", "import", "include", "key", "keyref", "list", "notation", "redefine", "restriction", "schema", "selector", "sequence", "simpleContent", "simpleContent::extension", "simpleContent::restriction", "simpleType", "union", "unique");
        this.part1Components = Arrays.asList("all", "Model_Group_details Particle_details", "annotation", "Annotation_details", "any", "Wildcard_details", "anyAttribute", "Wildcard_details", "appinfo", "Annotation_details", "attribute", "Attribute_Declaration_details AU_details", "attributeGroup", "Attribute_Group_Definition_details", "choice", "Model_Group_details Particle_details", "complexContent", "Complex_Type_Definition_details", "complexContent::extension", "Complex_Type_Definition_details", "complexContent::restriction", "Complex_Type_Definition_details", "complexType", "Complex_Type_Definition_details", "documentation", "Annotation_details", "element", "Element_Declaration_details Particle_details", "field", "Identity-constraint_Definition_details", "group", "Model_Group_Definition_details Particle_details", "import", "", "include", "", "key", "Identity-constraint_Definition_details", "keyref", "Identity-constraint_Definition_details", "list", "Simple_Type_Definition_details", "notation", "Notation_Declaration_details", "redefine", "", "restriction", "Simple_Type_Definition_details", "schema", "Schema_details", "selector", "Identity-constraint_Definition_details", "sequence", "Model_Group_details Particle_details", "simpleContent", "Complex_Type_Definition_details", "simpleContent::extension", "Complex_Type_Definition_details", "simpleContent::restriction", "Complex_Type_Definition_details", "simpleType", "Simple_Type_Definition_details", "union", "Simple_Type_Definition_details", "unique", "Identity-constraint_Definition_details");
        this.part2Anchors = Arrays.asList("enumeration", "fractionDigits", "length", "list", "maxExclusive", "maxInclusive", "maxLength", "minExclusive", "minInclusive", "minLength", "pattern", "restriction", "simpleType", "totalDigits", "union", "whiteSpace");
        this.part2Components = Arrays.asList("enumeration", "dc-enumeration", "fractionDigits", "dc-fractionDigits", "length", "dc-length", "list", "dc-defn", "maxExclusive", "dc-maxExclusive", "maxInclusive", "dc-maxInclusive", "maxLength", "dc-maxLength", "minExclusive", "dc-minExclusive", "minInclusive", "dc-minInclusive", "minLength", "dc-minLength", "pattern", "dc-pattern", "restriction", "dc-defn", "simpleType", "dc-defn", "totalDigits", "dc-totalDigits", "union", "dc-defn", "whiteSpace", "dc-whiteSpace");
        this.errata = "http://www.w3.org/2001/05/xmlschema-rec-comments";
    }

    public void readMarkup(String fileName) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(false);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(fileName);
            Node child = document.getDocumentElement().getFirstChild();
            while (child != null) {
                if ("elementAnnotation".equals(child.getLocalName())) {
                    this.handleMarkup(this.elementDeclarationMarkupMap, (Element)child);
                } else if ("attributeAnnotation".equals(child.getLocalName())) {
                    this.handleMarkup(this.attributeDeclarationMarkupMap, (Element)child);
                } else if ("content".equals(child.getLocalName())) {
                    this.handleMarkup(this.contentDocumentationMap, (Element)child);
                } else if ("typeMap".equals(child.getLocalName())) {
                    Element markupElement = (Element)child;
                    String schemaType = markupElement.getAttribute("schemaType");
                    String javaClass = markupElement.getAttribute("javaClass");
                    this.schemaTypeToJavaClassMap.put(schemaType, javaClass);
                }
                child = child.getNextSibling();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public void handleMarkup(Map<String, String> markupMap, Element markupElement) {
        String keyList = markupElement.getAttribute("key");
        StringTokenizer stringTokenizer = new StringTokenizer(keyList);
        while (stringTokenizer.hasMoreTokens()) {
            String key = stringTokenizer.nextToken();
            String markup = markupElement.getAttribute("markup");
            if (markup.length() <= 0) continue;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                Node grandChild = markupElement.getFirstChild();
                while (grandChild != null) {
                    if (grandChild.getNodeType() == 1) {
                        transformer.transform(new DOMSource(grandChild), new StreamResult(out));
                    }
                    grandChild = grandChild.getNextSibling();
                }
                String serialization = out.toString();
                serialization = serialization.substring(serialization.indexOf("<div>"));
                markupMap.put(key, String.valueOf(markup) + "@" + serialization);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
    }

    public String getContentDocumentation(String key) {
        String result = this.contentDocumentationMap.get(key);
        if (result != null && (result = result.substring(result.indexOf("@") + 1)).length() == 0) {
            result = null;
        }
        return result;
    }

    public String getElementDeclarationMarkup(String key) {
        String result = this.elementDeclarationMarkupMap.get(key);
        if (result != null && (result = result.substring(0, result.indexOf("@"))).length() == 0) {
            result = null;
        }
        return result;
    }

    public String getElementDeclarationDocumentation(String key) {
        String result = this.elementDeclarationMarkupMap.get(key);
        if (result != null && (result = result.substring(result.indexOf("@") + 1)).length() == 0) {
            result = null;
        }
        return result;
    }

    public String getAttributeDeclarationMarkup(String key) {
        String result = this.attributeDeclarationMarkupMap.get(key);
        if (result != null && (result = result.substring(0, result.indexOf("@"))).length() == 0) {
            result = null;
        }
        return result;
    }

    public String getAttributeDeclarationDocumentation(String key) {
        String result = this.attributeDeclarationMarkupMap.get(key);
        if (result != null && (result = result.substring(result.indexOf("@") + 1)).length() == 0) {
            result = null;
        }
        return result;
    }

    public String getStandardLink(XSDElementDeclaration xsdElementDeclaration) {
        String result = xsdElementDeclaration.getName();
        XSDElementDeclaration parentElementDeclaration = this.specialAnchorMap.get(xsdElementDeclaration);
        result = parentElementDeclaration != null ? "<a target='Part1' href='http://www.w3.org/TR/xmlschema-1/#element-" + parentElementDeclaration.getName() + "::" + result : (this.part2Anchors.contains(result) ? "<a target='Part2' href='http://www.w3.org/TR/xmlschema-2/#element-" + result : "<a target='Part1' href='http://www.w3.org/TR/xmlschema-1/#element-" + result);
        return String.valueOf(result) + "'>";
    }

    public String getComponentLinks(XSDElementDeclaration xsdElementDeclaration) {
        String name = xsdElementDeclaration.getName();
        XSDElementDeclaration parentElementDeclaration = this.specialAnchorMap.get(xsdElementDeclaration);
        if (parentElementDeclaration != null) {
            name = String.valueOf(parentElementDeclaration.getName()) + "::" + name;
        }
        int part = 0;
        String anchors = null;
        int index = this.part2Components.indexOf(name);
        if (index != -1) {
            part = 2;
            anchors = this.part2Components.get(index + 1);
        } else {
            index = this.part1Components.indexOf(name);
            if (index != -1) {
                part = 1;
                anchors = this.part1Components.get(index + 1);
            }
        }
        if (part != 0) {
            StringBuffer result = new StringBuffer();
            int count = 0;
            StringTokenizer stringTokenizer = new StringTokenizer(anchors);
            while (stringTokenizer.hasMoreTokens()) {
                String anchor = stringTokenizer.nextToken();
                result.append("&nbsp;&nbsp;<a target='Part");
                result.append(part);
                result.append("' href='");
                result.append(part == 1 ? "http://www.w3.org/TR/xmlschema-1/" : "http://www.w3.org/TR/xmlschema-2/");
                result.append("#");
                result.append(anchor);
                result.append("'><font size=-2>");
                result.append(++count);
                result.append("</font></a>");
            }
            return result.length() > 0 ? result.toString() : null;
        }
        return null;
    }

    public String getSimpleTypeDefinitionLink(XSDSimpleTypeDefinition xsdSimpleTypeDefinition) {
        String reference = xsdSimpleTypeDefinition.getName();
        StringBuffer result = new StringBuffer();
        if ("anyType".equals(reference)) {
            result.append("<a target='Part1' href='");
            result.append("http://www.w3.org/TR/xmlschema-1/");
        } else {
            result.append("<a target='Part2' href='");
            result.append("http://www.w3.org/TR/xmlschema-2/");
        }
        result.append("#");
        if ("anyType".equals(reference)) {
            reference = "ur-type-itself";
        } else if ("anySimpleType".equals(reference)) {
            reference = "anySimpleType-component";
        } else if ("anyListType".equals(reference)) {
            reference = "element-list";
        } else if ("anyUnionType".equals(reference)) {
            reference = "element-union";
        }
        result.append(reference);
        result.append("'>");
        result.append(xsdSimpleTypeDefinition.getName());
        result.append("</a>");
        return result.toString();
    }

    public String getLocalAnchor(XSDElementDeclaration xsdElementDeclaration) {
        String result = xsdElementDeclaration.getName();
        XSDElementDeclaration parentElementDeclaration = this.specialAnchorMap.get(xsdElementDeclaration);
        result = parentElementDeclaration != null ? "element-" + parentElementDeclaration.getName() + "::" + result : (this.part2Anchors.contains(result) ? "element-2-" + result : "element-" + result);
        return result;
    }

    public Object start(IApplicationContext context) throws Exception {
        String[] arguments = (String[])context.getArguments().get("application.args");
        return this.run(arguments == null ? new String[]{} : arguments);
    }

    public void stop() {
    }

    public Object run(Object object) {
        try {
            String[] arguments = (String[])object;
            if (arguments.length > 0 && "-pdelaunch".equals(arguments[0])) {
                String[] oldArguments = arguments;
                arguments = new String[arguments.length - 1];
                System.arraycopy(oldArguments, 1, arguments, 0, arguments.length);
            }
            this.readMarkup(arguments[0]);
            this.printHeader();
            int i = 1;
            while (i < arguments.length) {
                System.out.println("<!-- << " + arguments[i] + " >> -->");
                this.loadAndPrint(arguments[i]);
                ++i;
            }
            this.printFooter();
            return 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 1;
        }
    }

    public void printHeader() {
        System.out.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">");
        System.out.println("<html>");
        System.out.println("<style type='text/css'>");
        System.out.println("  code { font-family: monospace; font-size: 100%}");
        System.out.println("  div.reprdef { border: 4px double gray; margin: 0em 1em; padding: 0em }");
        System.out.println("  span.reprdef { color: #A52A2A }");
        System.out.println("  div.reprHeader { margin: 4px; font-weight: bold }");
        System.out.println("  div.reprBody { border-top-width: 4px; border-top-style: double; border-top-color: #d3d3d3; padding: 4px ; margin: 0em}");
        System.out.println("  div.never, span.never { color : #7F7F7F }");
        System.out.println("  div.allows, span.allows { color : #7FAF7F }");
        System.out.println("  div.future, span.future { color : #7F7FAF }");
        System.out.println("</style>");
    }

    public void printFooter() {
        System.out.println("</html>");
    }

    public void loadAndPrint(String xsdFile) throws Exception {
        XSDFactory xsdFactory = XSDFactory.eINSTANCE;
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        XSDResourceImpl xsdResource = (XSDResourceImpl)resourceSet.getResource(URI.createFileURI((String)xsdFile), true);
        XSDSchema xsdSchema = xsdResource.getSchema();
        String elementContentHeaderDocumentation = this.getContentDocumentation("element-header");
        if (elementContentHeaderDocumentation != null) {
            System.out.println(elementContentHeaderDocumentation);
        }
        List<XSDElementDeclaration> all = new ArrayList(xsdSchema.getElementDeclarations());
        XSDElementDeclaration simpleContent = xsdSchema.resolveElementDeclaration("simpleContent");
        XSDElementDeclaration complexContent = xsdSchema.resolveElementDeclaration("complexContent");
        int i = 0;
        while (i <= 1) {
            int j = 0;
            while (j <= 1) {
                XSDElementDeclaration parentElement = i == 0 ? complexContent : simpleContent;
                XSDComplexTypeDefinition xsdComplexTypeDefinition = (XSDComplexTypeDefinition)parentElement.getTypeDefinition();
                XSDElementDeclaration specialElementDeclaration = (XSDElementDeclaration)((XSDParticle)((XSDModelGroup)((XSDParticle)((XSDModelGroup)((XSDParticle)xsdComplexTypeDefinition.getContentType()).getTerm()).getParticles().get(1)).getTerm()).getParticles().get(j)).getTerm();
                all.add(specialElementDeclaration);
                this.specialAnchorMap.put(specialElementDeclaration, parentElement);
                ++j;
            }
            ++i;
        }
        List aux = XSDNamedComponentImpl.sortNamedComponents(all);
        all = aux;
        for (XSDElementDeclaration xsdElementDeclaration : all) {
            XSDElementDeclaration parentElementDeclaration = this.specialAnchorMap.get(xsdElementDeclaration);
            String elementDeclarationName = xsdElementDeclaration.getName();
            String key = String.valueOf(parentElementDeclaration == null ? "" : String.valueOf(parentElementDeclaration.getName()) + "::") + elementDeclarationName;
            String elementDeclarationMarkup = this.getElementDeclarationMarkup(key);
            System.out.print("<h2>");
            System.out.print(elementDeclarationName.substring(0, 1).toUpperCase());
            System.out.print(elementDeclarationName.substring(1));
            System.out.println("</h2>");
            System.out.println("<div class='reprdef'>");
            System.out.println("<table cols=1 width='100%'><tr><td>");
            System.out.print("<div class='reprHeader'><span class='reprdef'>XML&nbsp;Representation&nbsp;Summary:&nbsp;</span><code>");
            System.out.print("<a name='" + this.getLocalAnchor(xsdElementDeclaration) + "'>");
            System.out.print(this.getStandardLink(xsdElementDeclaration));
            System.out.print(elementDeclarationName);
            System.out.print("</a></a></code>");
            System.out.print("&nbsp;Element&nbsp;Information&nbsp;Item&nbsp;");
            if (parentElementDeclaration != null) {
                System.out.print("<small>(");
                System.out.print("<a href='#" + this.getLocalAnchor(parentElementDeclaration) + "'>");
                System.out.print(parentElementDeclaration.getName());
                System.out.print("</a>)</small>");
            } else if ("restriction".equals(elementDeclarationName)) {
                System.out.print("<small>(simpleType)</small>");
            }
            System.out.println("</div>");
            System.out.println("<div class='reprBody'>");
            if (elementDeclarationMarkup != null) {
                System.out.print("<div class='" + elementDeclarationMarkup + "'>");
            }
            System.out.print("<tt>&lt;");
            System.out.print(elementDeclarationName);
            System.out.print("</tt>");
            String string = this.getComponentLinks(xsdElementDeclaration);
            if (string != null) {
                System.out.print(string);
            }
            System.out.println("<br>");
            StringBuffer attributeDocumentationBuffer = new StringBuffer();
            HashMap<String, Integer> repeatedDocumentationMap = new HashMap<String, Integer>();
            XSDTypeDefinition xsdTypeDefinition = xsdElementDeclaration.getTypeDefinition();
            XSDComplexTypeDefinition generalType = xsdSchema.resolveComplexTypeDefinitionURI(xsdElementDeclaration.getURI());
            if (generalType.getContainer() != null) {
                xsdTypeDefinition = generalType;
            }
            if (xsdTypeDefinition instanceof XSDSimpleTypeDefinition) {
                System.out.println("<tt>></tt><br>");
            } else if (xsdTypeDefinition instanceof XSDComplexTypeDefinition) {
                XSDComplexTypeDefinition xsdComplexTypeDefinition = (XSDComplexTypeDefinition)xsdTypeDefinition;
                Iterator attributeUses = xsdComplexTypeDefinition.getAttributeUses().iterator();
                while (attributeUses.hasNext()) {
                    XSDAttributeUse xsdAttributeUse = (XSDAttributeUse)attributeUses.next();
                    XSDAttributeDeclaration xsdAttributeDeclaration = xsdAttributeUse.getAttributeDeclaration();
                    String attributeDeclarationName = xsdAttributeDeclaration.getName();
                    System.out.print("<tt>&nbsp;&nbsp;");
                    if (xsdAttributeDeclaration.getTargetNamespace() != null) {
                        System.out.print("xml:");
                    }
                    String attributeDeclarationMarkup = null;
                    String attributeDeclarationDocumentation = null;
                    if (!"ignored".equals(elementDeclarationMarkup)) {
                        attributeDeclarationMarkup = this.getAttributeDeclarationMarkup(attributeDeclarationName);
                        if (attributeDeclarationMarkup == null) {
                            attributeDeclarationMarkup = this.getAttributeDeclarationMarkup(String.valueOf(elementDeclarationName) + "." + attributeDeclarationName);
                        }
                        if ((attributeDeclarationDocumentation = this.getAttributeDeclarationDocumentation(attributeDeclarationName)) == null) {
                            attributeDeclarationDocumentation = this.getAttributeDeclarationDocumentation(String.valueOf(elementDeclarationName) + "." + attributeDeclarationName);
                        }
                    }
                    if (attributeDeclarationDocumentation != null) {
                        Integer oldInsertIndex = (Integer)repeatedDocumentationMap.get(attributeDeclarationDocumentation);
                        if (oldInsertIndex != null) {
                            String insertion = "<br>" + attributeDeclarationName;
                            attributeDocumentationBuffer.insert((int)oldInsertIndex, insertion);
                            repeatedDocumentationMap.put(attributeDeclarationDocumentation, oldInsertIndex + insertion.length());
                        } else {
                            if (attributeDocumentationBuffer.length() == 0) {
                                attributeDocumentationBuffer.append("<table cols=2 width='100%'>\n");
                                attributeDocumentationBuffer.append("<tr>\n<th width=25% valign=top align=left><b>Attribute</b></th>\n");
                                attributeDocumentationBuffer.append("<th width=75% valign=top align=left><b>Description</b></th>\n</tr>\n");
                            }
                            attributeDocumentationBuffer.append("<tr><td><b>");
                            if (attributeDeclarationMarkup != null) {
                                attributeDocumentationBuffer.append("<span class='" + attributeDeclarationMarkup + "'>");
                            }
                            attributeDocumentationBuffer.append(attributeDeclarationName);
                            int insertIndex = attributeDocumentationBuffer.length();
                            if (attributeDeclarationMarkup != null) {
                                attributeDocumentationBuffer.append("</span>");
                            }
                            attributeDocumentationBuffer.append("</b></td>\n<td valign=top>\n");
                            attributeDocumentationBuffer.append(attributeDeclarationDocumentation);
                            attributeDocumentationBuffer.append("</td></tr>");
                            repeatedDocumentationMap.put(attributeDeclarationDocumentation, insertIndex);
                        }
                    }
                    if (attributeDeclarationMarkup != null) {
                        System.out.print("<span class='" + attributeDeclarationMarkup + "'>");
                    }
                    if (xsdAttributeUse.isRequired()) {
                        System.out.print("<b>");
                        System.out.print(attributeDeclarationName);
                        System.out.print("</b>");
                    } else {
                        System.out.print(attributeDeclarationName);
                    }
                    if (attributeDeclarationMarkup != null) {
                        System.out.print("</span>");
                    }
                    System.out.print("&nbsp;=&nbsp;</tt>");
                    XSDSimpleTypeDefinition xsdSimpleTypeDefinition = xsdAttributeDeclaration.getTypeDefinition();
                    this.printSimpleTypeDefinition(xsdSimpleTypeDefinition);
                    if (xsdAttributeUse.getLexicalValue() != null) {
                        System.out.print("&nbsp;:&nbsp;");
                        if ("".equals(xsdAttributeUse.getLexicalValue())) {
                            System.out.print("\"\"");
                        } else {
                            System.out.print(xsdAttributeUse.getLexicalValue());
                        }
                    }
                    if (!attributeUses.hasNext()) continue;
                    System.out.println("<br>");
                }
                if (xsdComplexTypeDefinition.getAttributeWildcard() != null) {
                    System.out.println("<br>");
                    System.out.println("<span class='allows'><tt><em>&nbsp;&nbsp;{&nbsp;any&nbsp;attributes&nbsp;with&nbsp;non-schema&nbsp;namespace&nbsp;.&nbsp;.&nbsp;.&nbsp;}</em></tt></span>");
                }
                System.out.println("<tt>></tt><br>");
                if (xsdComplexTypeDefinition.getContentType() instanceof XSDParticle) {
                    System.out.print("<tt><em>&nbsp;&nbsp;Content:</em>&nbsp;");
                    this.printParticle((XSDParticle)xsdComplexTypeDefinition.getContentType(), elementDeclarationMarkup);
                    System.out.print("</tt>");
                } else if (xsdComplexTypeDefinition.getContentType() instanceof XSDSimpleTypeDefinition) {
                    System.out.print("<b>***** simple</b>");
                } else {
                    System.out.print("<b>{ **** empty }</b>");
                }
                System.out.println("<br>");
            }
            System.out.print("<tt>&lt;/");
            System.out.print(elementDeclarationName);
            System.out.println("></tt>");
            if (elementDeclarationMarkup != null) {
                System.out.print("</div>");
            }
            System.out.println("</div>");
            String elementDeclarationDocumentation = this.getElementDeclarationDocumentation(key);
            if (elementDeclarationDocumentation != null) {
                System.out.println("<div class='reprBody'>");
                System.out.println(elementDeclarationDocumentation);
                System.out.println("</div>");
            }
            if (attributeDocumentationBuffer.length() > 0) {
                System.out.println("<div class='reprBody'>");
                System.out.print(attributeDocumentationBuffer);
                System.out.println("</table>");
                System.out.println("</div>");
            }
            System.out.println("</td></tr></table>");
            System.out.println("</div>");
        }
        String typeContentHeaderDocumentation = this.getContentDocumentation("type-header");
        if (typeContentHeaderDocumentation != null) {
            System.out.println(typeContentHeaderDocumentation);
        }
        System.out.println("<table border=true cols=3 width='100%'>");
        System.out.println("<tr>");
        System.out.println("<th width=33% valign=top align=left><b>Type</b></th>");
        System.out.println("<th width=33% valign=top align=left><b>Properties&nbsp;&amp;&nbsp;Facets</b></th>");
        System.out.println("<th width=34% valign=top align=left><b>Effective&nbsp;Value</b></th>");
        System.out.println("</tr>");
        XSDSimpleTypeDefinition anyTypeDefinition = xsdSchema.getSchemaForSchema().resolveSimpleTypeDefinition("anyType");
        XSDSimpleTypeDefinition anySimpleTypeDefinition = xsdSchema.getSchemaForSchema().resolveSimpleTypeDefinition("anySimpleType");
        XSDSimpleTypeDefinition anyListTypeDefinition = xsdFactory.createXSDSimpleTypeDefinition();
        anyListTypeDefinition.setVariety(XSDVariety.LIST_LITERAL);
        anyListTypeDefinition.setName("anyListType");
        anyListTypeDefinition.setItemTypeDefinition(anySimpleTypeDefinition);
        xsdSchema.getContents().add((Object)anyListTypeDefinition);
        anyListTypeDefinition.getElement().setAttribute("id", "anyListType");
        XSDSimpleTypeDefinition anyUnionTypeDefinition = xsdFactory.createXSDSimpleTypeDefinition();
        anyUnionTypeDefinition.setVariety(XSDVariety.UNION_LITERAL);
        anyUnionTypeDefinition.setName("anyUnionType");
        anyUnionTypeDefinition.getMemberTypeDefinitions().add((Object)anySimpleTypeDefinition);
        xsdSchema.getContents().add((Object)anyUnionTypeDefinition);
        anyUnionTypeDefinition.getElement().setAttribute("id", "anyUnionType");
        ArrayList<XSDSimpleTypeDefinition> allTypeDefinitions = new ArrayList<XSDSimpleTypeDefinition>((Collection<XSDSimpleTypeDefinition>)xsdSchema.getTypeDefinitions());
        allTypeDefinitions.add(0, anySimpleTypeDefinition);
        allTypeDefinitions.add(0, anyTypeDefinition);
        for (XSDTypeDefinition xSDTypeDefinition : allTypeDefinitions) {
            boolean isPrimitive;
            if (!(xSDTypeDefinition instanceof XSDSimpleTypeDefinition) || xSDTypeDefinition.getElement() == null || !xSDTypeDefinition.getName().equals(xSDTypeDefinition.getElement().getAttribute("id"))) continue;
            XSDSimpleTypeDefinition xsdSimpleTypeDefinition = (XSDSimpleTypeDefinition)xSDTypeDefinition;
            System.out.println("<tr>");
            System.out.println("<a name='" + xsdSimpleTypeDefinition.getName() + "-simple-type'>");
            System.out.println("<td>");
            boolean bl = isPrimitive = XSDVariety.ATOMIC_LITERAL == xsdSimpleTypeDefinition.getVariety() && xsdSimpleTypeDefinition.getBaseTypeDefinition() == anySimpleTypeDefinition;
            if (isPrimitive) {
                System.out.print("<b>");
            }
            System.out.print(this.getSimpleTypeDefinitionLink(xsdSimpleTypeDefinition));
            if (isPrimitive) {
                System.out.print("</b>");
            }
            XSDSimpleTypeDefinition baseTypeDefinition = xsdSimpleTypeDefinition;
            while (true) {
                String javaClass;
                if ((javaClass = this.schemaTypeToJavaClassMap.get(baseTypeDefinition.getName())) != null) {
                    System.out.println("<br>&nbsp;<br>");
                    if (baseTypeDefinition == xsdSimpleTypeDefinition) {
                        System.out.print("<b>");
                    }
                    int dotIndex = javaClass.lastIndexOf(".");
                    System.out.print("<font size=-2>");
                    System.out.print(javaClass.substring(0, dotIndex + 1));
                    System.out.print("</font><br>&nbsp;&nbsp;");
                    System.out.print(javaClass.substring(dotIndex + 1));
                    if (baseTypeDefinition == xsdSimpleTypeDefinition) {
                        System.out.print("<b>");
                    }
                    break;
                }
                baseTypeDefinition = baseTypeDefinition.getBaseTypeDefinition();
            }
            System.out.println();
            System.out.println("<br>");
            System.out.println("</td>");
            System.out.println("</a>");
            StringBuffer validFacets = new StringBuffer();
            StringBuffer effectiveFacetValues = new StringBuffer();
            validFacets.append("variety<br>\n");
            effectiveFacetValues.append(xsdSimpleTypeDefinition.isSetVariety() ? "<b>" + xsdSimpleTypeDefinition.getVariety() + "</b>" : "<em>absent</em>");
            effectiveFacetValues.append("<br>\n");
            validFacets.append("base type definition<br>\n");
            XSDSimpleTypeDefinition baseTypeDefinition2 = xsdSimpleTypeDefinition.getBaseTypeDefinition();
            while (baseTypeDefinition2.getName() == null) {
                baseTypeDefinition2 = baseTypeDefinition2.getBaseTypeDefinition();
            }
            effectiveFacetValues.append("<a href='#");
            effectiveFacetValues.append(baseTypeDefinition2.getName());
            effectiveFacetValues.append("-simple-type'>");
            effectiveFacetValues.append(baseTypeDefinition2.getName());
            effectiveFacetValues.append("</a><br>\n");
            validFacets.append("ordered<br>\n");
            effectiveFacetValues.append("anyUnionType".equals(xsdSimpleTypeDefinition.getName()) ? "*" : xsdSimpleTypeDefinition.getOrderedFacet().getValue().getName());
            effectiveFacetValues.append("<br>\n");
            validFacets.append("bounded<br>\n");
            effectiveFacetValues.append("anyUnionType".equals(xsdSimpleTypeDefinition.getName()) ? "*" : (xsdSimpleTypeDefinition.getBoundedFacet().isValue() ? "true" : "false"));
            effectiveFacetValues.append("<br>\n");
            validFacets.append("cardinality<br>\n");
            effectiveFacetValues.append("anyUnionType".equals(xsdSimpleTypeDefinition.getName()) ? "*" : (XSDCardinality.COUNTABLY_INFINITE_LITERAL == xsdSimpleTypeDefinition.getCardinalityFacet().getValue() ? "countably infinite" : xsdSimpleTypeDefinition.getCardinalityFacet().getValue().getName()));
            effectiveFacetValues.append("<br>\n");
            validFacets.append("numeric<br>\n");
            effectiveFacetValues.append("anyUnionType".equals(xsdSimpleTypeDefinition.getName()) ? "*" : (xsdSimpleTypeDefinition.getNumericFacet().isValue() ? "true" : "false"));
            effectiveFacetValues.append("<br>\n");
            if (xsdSimpleTypeDefinition.getValidFacets().contains((Object)"length")) {
                validFacets.append("length<br>\n");
                if (xsdSimpleTypeDefinition.getEffectiveLengthFacet() != null) {
                    XSDLengthFacet xsdLengthFacet = xsdSimpleTypeDefinition.getEffectiveLengthFacet();
                    if (xsdLengthFacet.isFixed()) {
                        effectiveFacetValues.append("<b>");
                    }
                    effectiveFacetValues.append(xsdLengthFacet.getValue());
                    if (xsdLengthFacet.isFixed()) {
                        effectiveFacetValues.append("</b>");
                    }
                }
                effectiveFacetValues.append("<br>\n");
            }
            if (xsdSimpleTypeDefinition.getValidFacets().contains((Object)"minLength")) {
                validFacets.append("minLength<br>\n");
                if (xsdSimpleTypeDefinition.getEffectiveMinLengthFacet() != null) {
                    XSDMinLengthFacet xsdMinLengthFacet = xsdSimpleTypeDefinition.getEffectiveMinLengthFacet();
                    if (xsdMinLengthFacet.isFixed()) {
                        effectiveFacetValues.append("<b>");
                    }
                    effectiveFacetValues.append(xsdMinLengthFacet.getValue());
                    if (xsdMinLengthFacet.isFixed()) {
                        effectiveFacetValues.append("</b>");
                    }
                }
                effectiveFacetValues.append("<br>\n");
            }
            if (xsdSimpleTypeDefinition.getValidFacets().contains((Object)"maxLength")) {
                validFacets.append("maxLength<br>\n");
                if (xsdSimpleTypeDefinition.getEffectiveMaxLengthFacet() != null) {
                    XSDMaxLengthFacet xsdMaxLengthFacet = xsdSimpleTypeDefinition.getEffectiveMaxLengthFacet();
                    if (xsdMaxLengthFacet.isFixed()) {
                        effectiveFacetValues.append("<b>");
                    }
                    effectiveFacetValues.append(xsdMaxLengthFacet.getValue());
                    if (xsdMaxLengthFacet.isFixed()) {
                        effectiveFacetValues.append("</b>");
                    }
                }
                effectiveFacetValues.append("<br>\n");
            }
            if (xsdSimpleTypeDefinition.getValidFacets().contains((Object)"pattern")) {
                validFacets.append("pattern<br>\n");
                if (xsdSimpleTypeDefinition.getEffectivePatternFacet() != null) {
                    effectiveFacetValues.append("*");
                }
                effectiveFacetValues.append("<br>\n");
            }
            if (xsdSimpleTypeDefinition.getValidFacets().contains((Object)"enumeration")) {
                validFacets.append("enumeration<br>\n");
                if (xsdSimpleTypeDefinition.getEffectiveEnumerationFacet() != null) {
                    XSDEnumerationFacet xsdEnumerationFacet = xsdSimpleTypeDefinition.getEffectiveEnumerationFacet();
                    for (String enumerator : xsdEnumerationFacet.getValue()) {
                        effectiveFacetValues.append(enumerator);
                        effectiveFacetValues.append("&nbsp;");
                    }
                }
                effectiveFacetValues.append("<br>\n");
            }
            if (xsdSimpleTypeDefinition.getValidFacets().contains((Object)"whiteSpace")) {
                validFacets.append("whiteSpace<br>\n");
                if (xsdSimpleTypeDefinition.getEffectiveWhiteSpaceFacet() != null) {
                    XSDWhiteSpaceFacet xsdWhiteSpaceFacet = xsdSimpleTypeDefinition.getEffectiveWhiteSpaceFacet();
                    if (xsdWhiteSpaceFacet.isFixed()) {
                        effectiveFacetValues.append("<b>");
                    }
                    effectiveFacetValues.append(xsdWhiteSpaceFacet.getValue());
                    if (xsdWhiteSpaceFacet.isFixed()) {
                        effectiveFacetValues.append("</b>");
                    }
                }
                effectiveFacetValues.append("<br>\n");
            }
            if (xsdSimpleTypeDefinition.getValidFacets().contains((Object)"maxInclusive")) {
                validFacets.append("maxInclusive<br>\n");
                if (xsdSimpleTypeDefinition.getEffectiveMaxFacet() instanceof XSDMaxInclusiveFacet) {
                    XSDMaxInclusiveFacet xsdMaxInclusiveFacet = (XSDMaxInclusiveFacet)xsdSimpleTypeDefinition.getEffectiveMaxFacet();
                    if (xsdMaxInclusiveFacet.isFixed()) {
                        effectiveFacetValues.append("<b>");
                    }
                    effectiveFacetValues.append(xsdMaxInclusiveFacet.getValue());
                    if (xsdMaxInclusiveFacet.isFixed()) {
                        effectiveFacetValues.append("</b>");
                    }
                }
                effectiveFacetValues.append("<br>\n");
            }
            if (xsdSimpleTypeDefinition.getValidFacets().contains((Object)"maxExclusive")) {
                validFacets.append("maxExclusive<br>\n");
                if (xsdSimpleTypeDefinition.getEffectiveMaxFacet() instanceof XSDMaxExclusiveFacet) {
                    XSDMaxExclusiveFacet xsdMaxExclusiveFacet = (XSDMaxExclusiveFacet)xsdSimpleTypeDefinition.getEffectiveMaxFacet();
                    if (xsdMaxExclusiveFacet.isFixed()) {
                        effectiveFacetValues.append("<b>");
                    }
                    effectiveFacetValues.append(xsdMaxExclusiveFacet.getValue());
                    if (xsdMaxExclusiveFacet.isFixed()) {
                        effectiveFacetValues.append("</b>");
                    }
                }
                effectiveFacetValues.append("<br>\n");
            }
            if (xsdSimpleTypeDefinition.getValidFacets().contains((Object)"minInclusive")) {
                validFacets.append("maxInclusive<br>\n");
                if (xsdSimpleTypeDefinition.getEffectiveMinFacet() instanceof XSDMinInclusiveFacet) {
                    XSDMinInclusiveFacet xsdMinInclusiveFacet = (XSDMinInclusiveFacet)xsdSimpleTypeDefinition.getEffectiveMinFacet();
                    if (xsdMinInclusiveFacet.isFixed()) {
                        effectiveFacetValues.append("<b>");
                    }
                    effectiveFacetValues.append(xsdMinInclusiveFacet.getValue());
                    if (xsdMinInclusiveFacet.isFixed()) {
                        effectiveFacetValues.append("</b>");
                    }
                }
                effectiveFacetValues.append("<br>\n");
            }
            if (xsdSimpleTypeDefinition.getValidFacets().contains((Object)"minExclusive")) {
                validFacets.append("maxExclusive<br>\n");
                if (xsdSimpleTypeDefinition.getEffectiveMinFacet() instanceof XSDMinExclusiveFacet) {
                    XSDMinExclusiveFacet xsdMinExclusiveFacet = (XSDMinExclusiveFacet)xsdSimpleTypeDefinition.getEffectiveMinFacet();
                    if (xsdMinExclusiveFacet.isFixed()) {
                        effectiveFacetValues.append("<b>");
                    }
                    effectiveFacetValues.append(xsdMinExclusiveFacet.getValue());
                    if (xsdMinExclusiveFacet.isFixed()) {
                        effectiveFacetValues.append("</b>");
                    }
                }
                effectiveFacetValues.append("<br>\n");
            }
            if (xsdSimpleTypeDefinition.getValidFacets().contains((Object)"totalDigits")) {
                validFacets.append("totalDigits<br>\n");
                if (xsdSimpleTypeDefinition.getEffectiveTotalDigitsFacet() != null) {
                    XSDTotalDigitsFacet xsdTotalDigitsFacet = xsdSimpleTypeDefinition.getEffectiveTotalDigitsFacet();
                    if (xsdTotalDigitsFacet.isFixed()) {
                        effectiveFacetValues.append("<b>");
                    }
                    effectiveFacetValues.append(xsdTotalDigitsFacet.getValue());
                    if (xsdTotalDigitsFacet.isFixed()) {
                        effectiveFacetValues.append("</b>");
                    }
                }
                effectiveFacetValues.append("<br>\n");
            }
            if (xsdSimpleTypeDefinition.getValidFacets().contains((Object)"fractionDigits")) {
                validFacets.append("fractionDigits<br>\n");
                if (xsdSimpleTypeDefinition.getEffectiveFractionDigitsFacet() != null) {
                    XSDFractionDigitsFacet xsdFractionDigitsFacet = xsdSimpleTypeDefinition.getEffectiveFractionDigitsFacet();
                    if (xsdFractionDigitsFacet.isFixed()) {
                        effectiveFacetValues.append("<b>");
                    }
                    effectiveFacetValues.append(xsdFractionDigitsFacet.getValue());
                    if (xsdFractionDigitsFacet.isFixed()) {
                        effectiveFacetValues.append("</b>");
                    }
                }
                effectiveFacetValues.append("<br>\n");
            }
            System.out.println("<td>");
            System.out.print(validFacets);
            System.out.println("</td>");
            System.out.print("<td>");
            System.out.println(effectiveFacetValues);
            System.out.println("</td>");
            System.out.println("</tr>");
        }
        System.out.println("</table>");
        String string = this.getContentDocumentation("appendix-header");
        if (string != null) {
            System.out.println(string);
        }
    }

    public void printParticle(XSDParticle xsdParticle, String rootElementDeclarationMarkup) {
        int minOccurs = xsdParticle.getMinOccurs();
        int maxOccurs = xsdParticle.getMaxOccurs();
        XSDTerm xsdTerm = xsdParticle.getTerm();
        if (xsdTerm instanceof XSDElementDeclaration) {
            XSDElementDeclaration xsdElementDeclaration = (XSDElementDeclaration)xsdTerm;
            String elementDeclarationName = xsdElementDeclaration.getName();
            String elementDeclarationMarkup = null;
            if (rootElementDeclarationMarkup == null) {
                elementDeclarationMarkup = this.getElementDeclarationMarkup(elementDeclarationName);
            }
            if (elementDeclarationMarkup != null) {
                System.out.print("<span class='");
                System.out.print(elementDeclarationMarkup);
                System.out.print("'>");
            }
            System.out.print("<a href='#" + this.getLocalAnchor(xsdElementDeclaration) + "'>");
            System.out.print(elementDeclarationName.charAt(0));
            System.out.print("</a>");
            System.out.print(elementDeclarationName.substring(1));
            if (elementDeclarationMarkup != null) {
                System.out.print("</span>");
            }
            if (minOccurs == 0) {
                if (maxOccurs == 1) {
                    System.out.print("?");
                } else {
                    System.out.print("*");
                }
            } else if (maxOccurs == -1) {
                System.out.print("+");
            }
        } else if (xsdTerm instanceof XSDModelGroup) {
            boolean isRedundant;
            XSDModelGroup xsdModelGroup = (XSDModelGroup)xsdTerm;
            EList particles = xsdModelGroup.getParticles();
            boolean bl = isRedundant = particles.size() == 1 && minOccurs == 1 && maxOccurs == 1 && ((XSDParticle)particles.get(0)).getTerm() instanceof XSDModelGroup;
            if (!isRedundant) {
                System.out.print("(");
            }
            String separator = XSDCompositor.CHOICE_LITERAL == xsdModelGroup.getCompositor() ? " | " : (XSDCompositor.SEQUENCE_LITERAL == xsdModelGroup.getCompositor() ? ",  " : "  &  ");
            Iterator i = xsdModelGroup.getParticles().iterator();
            while (i.hasNext()) {
                XSDParticle childParticle = (XSDParticle)i.next();
                this.printParticle(childParticle, rootElementDeclarationMarkup);
                if (!i.hasNext()) continue;
                System.out.print(separator);
            }
            if (!isRedundant) {
                System.out.print(")");
                if (minOccurs == 0) {
                    if (maxOccurs == 1) {
                        System.out.print("?");
                    } else {
                        System.out.print("*");
                    }
                } else if (maxOccurs == -1) {
                    System.out.print("+");
                }
            }
        } else if (xsdTerm instanceof XSDWildcard) {
            System.out.print("<em>{any}</em>");
        }
    }

    public void printSimpleTypeDefinition(XSDSimpleTypeDefinition xsdSimpleTypeDefinition) {
        if (xsdSimpleTypeDefinition != null) {
            if (xsdSimpleTypeDefinition.getEffectiveEnumerationFacet() != null) {
                EList value = xsdSimpleTypeDefinition.getEffectiveEnumerationFacet().getValue();
                if (value.size() > 1) {
                    System.out.print("(");
                }
                Iterator enumerators = value.iterator();
                while (enumerators.hasNext()) {
                    String enumerator = enumerators.next().toString();
                    System.out.print("<em>");
                    System.out.print(enumerator);
                    System.out.print("</em>");
                    if (!enumerators.hasNext()) continue;
                    System.out.print("&nbsp;|&nbsp;");
                }
                if (value.size() > 1) {
                    System.out.print(")");
                }
            } else if (xsdSimpleTypeDefinition.getElement() != null && xsdSimpleTypeDefinition.getElement().hasAttribute("id")) {
                System.out.print("<a href='#" + xsdSimpleTypeDefinition.getName() + "-simple-type'>");
                System.out.print(xsdSimpleTypeDefinition.getName());
                System.out.print("</a>");
            } else if (XSDVariety.UNION_LITERAL == xsdSimpleTypeDefinition.getVariety()) {
                System.out.print("(");
                Iterator members = xsdSimpleTypeDefinition.getMemberTypeDefinitions().iterator();
                while (members.hasNext()) {
                    XSDSimpleTypeDefinition memberTypeDefinition = (XSDSimpleTypeDefinition)members.next();
                    this.printSimpleTypeDefinition(memberTypeDefinition);
                    if (!members.hasNext()) continue;
                    System.out.print("&nbsp;|&nbsp;");
                }
                System.out.print(")");
            } else if (XSDVariety.UNION_LITERAL == xsdSimpleTypeDefinition.getVariety()) {
                System.out.print("List&nbsp;of&nbsp;");
                this.printSimpleTypeDefinition(xsdSimpleTypeDefinition.getItemTypeDefinition());
            } else if (xsdSimpleTypeDefinition.getName() != null) {
                if ("public".equals(xsdSimpleTypeDefinition.getName())) {
                    System.out.print("<a target='Part2' href='http://www.w3.org/TR/xmlschema-2/#anyURI'>anyURI</a>&nbsp;&nbsp;");
                    System.out.print("<a target='Errata' href='" + this.errata + "#pfipublic'><em>public</em></a>");
                } else {
                    System.out.print("<b><em>");
                    System.out.print(xsdSimpleTypeDefinition.getName());
                    System.out.print("</em></b>");
                }
            } else if (xsdSimpleTypeDefinition.getEffectivePatternFacet() != null) {
                System.out.print("<em>");
                System.out.print("<a target='Part1' href='http://www.w3.org/TR/xmlschema-1/#coss-identity-constraint'>");
                System.out.print("a restricted xpath expression");
                System.out.print("</a>");
                System.out.print("</em>");
            } else {
                System.out.print("***");
            }
        }
    }
}

