/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.provider;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.plugin.RegistryReader;
import org.eclipse.emf.ecore.provider.EcoreEditPlugin;
import org.eclipse.emf.ecore.provider.annotation.EAnnotationItemProviderAdapterFactory;

class AnnotationItemProviderAdapterFactoryRegistryReader
extends RegistryReader {
    static final String TAG_FACTORY = "factory";
    static final String ATT_URI = "uri";
    static final String ATT_CLASS = "class";

    public AnnotationItemProviderAdapterFactoryRegistryReader() {
        super(RegistryFactory.getRegistry(), EcoreEditPlugin.INSTANCE.getSymbolicName(), "annotation_item_provider_adapter_factory");
    }

    protected boolean readElement(IConfigurationElement element, boolean add) {
        if (element.getName().equals(TAG_FACTORY)) {
            String uri = element.getAttribute(ATT_URI);
            if (uri == null) {
                this.logMissingAttribute(element, ATT_URI);
            } else if (element.getAttribute(ATT_CLASS) == null) {
                this.logMissingAttribute(element, ATT_CLASS);
            } else {
                if (add) {
                    AnnotationItemProviderAdapterFactoryDescriptor previous = EAnnotationItemProviderAdapterFactory.Registry.INSTANCE.put(uri, new AnnotationItemProviderAdapterFactoryDescriptor(element, ATT_CLASS));
                    if (previous instanceof AnnotationItemProviderAdapterFactoryDescriptor) {
                        AnnotationItemProviderAdapterFactoryDescriptor descriptor = previous;
                        EcorePlugin.INSTANCE.log((Object)("Both '" + descriptor.getElement().getContributor().getName() + "' and '" + element.getContributor().getName() + "' register an annotation item provider adapter factory for '" + uri + "'"));
                    }
                    return true;
                }
                EAnnotationItemProviderAdapterFactory.Registry.INSTANCE.remove(uri);
                return true;
            }
        }
        return false;
    }

    static class AnnotationItemProviderAdapterFactoryDescriptor
    extends RegistryReader.PluginClassDescriptor
    implements EAnnotationItemProviderAdapterFactory.Factory {
        public AnnotationItemProviderAdapterFactoryDescriptor(IConfigurationElement e, String attrName) {
            super(e, attrName);
        }

        public EAnnotationItemProviderAdapterFactory createEAnnotationItemProviderAdapterFactory() {
            return (EAnnotationItemProviderAdapterFactory)((Object)this.createInstance());
        }

        public IConfigurationElement getElement() {
            return this.element;
        }
    }
}

