/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.examples.databinding.project.core.internal.xmi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.OverrideableCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.examples.databinding.project.core.IModelResource;
import org.eclipse.emf.examples.databinding.project.core.model.project.Foundation;
import org.eclipse.emf.examples.databinding.project.core.model.project.ProjectFactory;

public class XMIModelResource
implements IModelResource {
    private Resource resource;
    private EditingDomain wrappedEditingDomain;
    private int changes = -1;
    private boolean skipEvent;
    private EditingDomain editingDomain = new EditingDomain(){

        public TreeIterator<?> treeIterator(Object object) {
            return XMIModelResource.this.wrappedEditingDomain.treeIterator(object);
        }

        public void setClipboard(Collection<Object> clipboard) {
            XMIModelResource.this.wrappedEditingDomain.setClipboard(clipboard);
        }

        public Resource loadResource(String fileNameURI) {
            return XMIModelResource.this.wrappedEditingDomain.createResource(fileNameURI);
        }

        public boolean isReadOnly(Resource resource) {
            return XMIModelResource.this.wrappedEditingDomain.isReadOnly(resource);
        }

        public boolean isControllable(Object object) {
            return XMIModelResource.this.wrappedEditingDomain.isControllable(object);
        }

        public List<?> getTreePath(Object object) {
            return XMIModelResource.this.wrappedEditingDomain.getTreePath(object);
        }

        public Object getRoot(Object object) {
            return XMIModelResource.this.wrappedEditingDomain.getRoot(object);
        }

        public ResourceSet getResourceSet() {
            return XMIModelResource.this.wrappedEditingDomain.getResourceSet();
        }

        public Object getParent(Object object) {
            return XMIModelResource.this.wrappedEditingDomain.getParent(object);
        }

        public boolean getOptimizeCopy() {
            return XMIModelResource.this.wrappedEditingDomain.getOptimizeCopy();
        }

        public Collection<?> getNewChildDescriptors(Object object, Object sibling) {
            return XMIModelResource.this.wrappedEditingDomain.getNewChildDescriptors(object, sibling);
        }

        public CommandStack getCommandStack() {
            return new CommandStack(){

                public void undo() {
                    if (this.canUndo()) {
                        try {
                            XMIModelResource.this.skipEvent = true;
                            XMIModelResource xMIModelResource = XMIModelResource.this;
                            xMIModelResource.changes = xMIModelResource.changes - 1;
                            XMIModelResource.this.wrappedEditingDomain.getCommandStack().undo();
                        }
                        finally {
                            XMIModelResource.this.skipEvent = false;
                        }
                    }
                }

                public void removeCommandStackListener(CommandStackListener listener) {
                    XMIModelResource.this.wrappedEditingDomain.getCommandStack().removeCommandStackListener(listener);
                }

                public void redo() {
                    if (this.canRedo()) {
                        try {
                            XMIModelResource.this.skipEvent = true;
                            XMIModelResource xMIModelResource = XMIModelResource.this;
                            xMIModelResource.changes = xMIModelResource.changes + 1;
                            XMIModelResource.this.wrappedEditingDomain.getCommandStack().redo();
                        }
                        finally {
                            XMIModelResource.this.skipEvent = false;
                        }
                    }
                }

                public Command getUndoCommand() {
                    return XMIModelResource.this.wrappedEditingDomain.getCommandStack().getUndoCommand();
                }

                public Command getRedoCommand() {
                    return XMIModelResource.this.wrappedEditingDomain.getCommandStack().getRedoCommand();
                }

                public Command getMostRecentCommand() {
                    return XMIModelResource.this.wrappedEditingDomain.getCommandStack().getMostRecentCommand();
                }

                public void flush() {
                    XMIModelResource.this.wrappedEditingDomain.getCommandStack().flush();
                }

                public void execute(Command command) {
                    XMIModelResource.this.wrappedEditingDomain.getCommandStack().execute(command);
                }

                public boolean canUndo() {
                    return XMIModelResource.this.wrappedEditingDomain.getCommandStack().canUndo();
                }

                public boolean canRedo() {
                    return XMIModelResource.this.wrappedEditingDomain.getCommandStack().canRedo();
                }

                public void addCommandStackListener(CommandStackListener listener) {
                    XMIModelResource.this.wrappedEditingDomain.getCommandStack().addCommandStackListener(listener);
                }
            };
        }

        public Collection<Object> getClipboard() {
            return XMIModelResource.this.wrappedEditingDomain.getClipboard();
        }

        public Collection<?> getChildren(Object object) {
            return XMIModelResource.this.wrappedEditingDomain.getChildren(object);
        }

        public Resource createResource(String fileNameURI) {
            return XMIModelResource.this.wrappedEditingDomain.createResource(fileNameURI);
        }

        public Command createOverrideCommand(OverrideableCommand command) {
            return XMIModelResource.this.wrappedEditingDomain.createOverrideCommand(command);
        }

        public Command createCommand(Class<? extends Command> commandClass, CommandParameter commandParameter) {
            return XMIModelResource.this.wrappedEditingDomain.createCommand(commandClass, commandParameter);
        }
    };
    private boolean modified = false;
    private boolean beforeSavePointModified = false;
    private List<IModelResource.Listener> listeners = new ArrayList<IModelResource.Listener>();

    public XMIModelResource(String uri) {
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        BasicCommandStack commandStack = new BasicCommandStack();
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                for (IModelResource.Listener l : XMIModelResource.this.listeners) {
                    l.commandStackChanged();
                }
                XMIModelResource.this.setModified(true);
                if (XMIModelResource.this.changes > -1 && !XMIModelResource.this.skipEvent) {
                    XMIModelResource xMIModelResource = XMIModelResource.this;
                    xMIModelResource.changes = xMIModelResource.changes + 1;
                }
            }
        });
        this.wrappedEditingDomain = new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)commandStack, (ResourceSet)resourceSet);
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        this.resource = resourceSet.getResource(URI.createURI((String)uri), true);
    }

    public Foundation getFoundation() {
        if (this.resource.getContents().size() == 0) {
            this.resource.getContents().add((Object)ProjectFactory.eINSTANCE.createFoundation());
        }
        return (Foundation)this.resource.getContents().get(0);
    }

    public IStatus save() {
        try {
            this.resource.save(null);
            this.setModified(false);
        }
        catch (Exception e) {
            return new Status(4, "org.eclipse.emf.examples.databinding.project.core", e.getMessage(), (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public IStatus redo() {
        if (this.getEditingDomain().getCommandStack().canRedo()) {
            this.getEditingDomain().getCommandStack().redo();
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    public IStatus undo() {
        if (this.getEditingDomain().getCommandStack().canUndo()) {
            this.getEditingDomain().getCommandStack().undo();
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    public IStatus commit() {
        if (this.changes != -1) {
            this.changes = -1;
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    public IStatus rollback() {
        int steps = this.changes;
        if (this.changes != -1) {
            int i = 0;
            while (i < steps) {
                if (!this.getEditingDomain().getCommandStack().canUndo()) {
                    return Status.CANCEL_STATUS;
                }
                this.undo();
                ++i;
            }
            this.changes = -1;
            this.setModified(this.beforeSavePointModified);
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    public IStatus setSavePoint() {
        if (this.changes == -1) {
            this.changes = 0;
            this.beforeSavePointModified = this.modified;
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    public boolean isDirty() {
        return this.modified;
    }

    private void setModified(boolean modified) {
        if (this.modified != modified) {
            this.modified = modified;
            for (IModelResource.Listener listener : this.listeners) {
                listener.dirtyStateChanged();
            }
        }
    }

    public void addListener(IModelResource.Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IModelResource.Listener listener) {
        this.listeners.remove(listener);
    }

    public void executeCmd(Command cmd) {
        this.getEditingDomain().getCommandStack().execute(cmd);
    }

    public IStatus canRedo() {
        return this.getEditingDomain().getCommandStack().canRedo() ? Status.OK_STATUS : Status.CANCEL_STATUS;
    }

    public IStatus canUndo() {
        return this.getEditingDomain().getCommandStack().canUndo() ? Status.OK_STATUS : Status.CANCEL_STATUS;
    }
}

