/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.edit.policies;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.uml2.diagram.sequence.edit.create.arcas.AnchoredDiagramTarget;
import org.eclipse.uml2.diagram.sequence.edit.policies.AnchorUtil;

public class TargetFeedbackHelper {
    private GraphicalEditPolicy myPolicy;
    private TargetFeedback myTargetFeedback;
    private GraphicalEditPolicyAccess myAccess = new GraphicalEditPolicyAccess();

    public TargetFeedbackHelper(GraphicalEditPolicy policy) {
        this.myPolicy = policy;
    }

    public void showFeedback(Request request) {
        Command command = this.myPolicy.getCommand(request);
        if (command == null || !command.canExecute()) {
            return;
        }
        if (this.myPolicy.getHost() == this.myPolicy.getHost().getViewer().getContents()) {
            return;
        }
        if (request instanceof DropRequest) {
            AnchoredDiagramTarget target = new AnchoredDiagramTarget((GraphicalEditPart)this.myPolicy.getHost(), request);
            target = this.findVisibleTargetUptree(target);
            if (this.myTargetFeedback == null || !this.myTargetFeedback.getTarget().equals(target)) {
                if (this.myTargetFeedback != null) {
                    this.myAccess.removeFeedback(this.myTargetFeedback.getFigure());
                }
                if (target != null) {
                    this.myTargetFeedback = new TargetFeedback(target);
                    this.myAccess.addFeedback(this.myTargetFeedback.getFigure());
                }
            }
            Point diagramPoint = this.getDiagramPoint((DropRequest)request);
            this.myTargetFeedback.layout(diagramPoint);
        }
    }

    private AnchoredDiagramTarget findVisibleTargetUptree(AnchoredDiagramTarget target) {
        if (!TargetFeedbackHelper.isHidden(target.getContainer())) {
            return target;
        }
        if (!(target.getContainer().getParent() instanceof GraphicalEditPart)) {
            return null;
        }
        GraphicalEditPart walker = (GraphicalEditPart)target.getContainer().getParent();
        while (walker != this.myPolicy.getHost().getViewer().getContents()) {
            if (!TargetFeedbackHelper.isHidden(walker)) {
                return new AnchoredDiagramTarget(walker);
            }
            walker = (GraphicalEditPart)walker.getParent();
        }
        return null;
    }

    public void eraseFeedback() {
        if (this.myTargetFeedback != null) {
            this.myAccess.removeFeedback(this.myTargetFeedback.getFigure());
            this.myTargetFeedback = null;
        }
    }

    private Point getDiagramPoint(DropRequest request) {
        Point diagramPoint = new Point(request.getLocation());
        ((GraphicalEditPart)this.myPolicy.getHost()).getFigure().translateToRelative((Translatable)diagramPoint);
        return diagramPoint;
    }

    public static boolean isHidden(GraphicalEditPart editPart) {
        GraphicalViewer viewer = (GraphicalViewer)editPart.getViewer();
        if (viewer == null) {
            return true;
        }
        IFigure rootFigure = ((DiagramRootEditPart)viewer.getRootEditPart()).getFigure();
        IFigure figure = editPart.getFigure();
        while (figure != null) {
            if (figure == rootFigure) {
                return false;
            }
            figure = figure.getParent();
        }
        return true;
    }

    private class GraphicalEditPolicyAccess
    extends GraphicalEditPolicy {
        private GraphicalEditPolicyAccess() {
        }

        public EditPart getHost() {
            return TargetFeedbackHelper.this.myPolicy.getHost();
        }

        public void addFeedback(IFigure figure) {
            super.addFeedback(figure);
            System.err.println("Feedback added:" + figure + ": (" + (figure.getParent() != null ? " OK " : " BROKEN "));
        }

        public void removeFeedback(IFigure figure) {
            System.err.println("Feedback removed:" + figure + ": (" + (figure.getParent() != null ? " OK " : " BROKEN "));
            if (figure.getParent() != null) {
                super.removeFeedback(figure);
            }
        }

        protected IFigure getFeedbackLayer() {
            return this.getLayer("Feedback Layer");
        }
    }

    private static class TargetFeedback {
        IFigure myFigure;
        AnchoredDiagramTarget myTarget;

        public TargetFeedback(AnchoredDiagramTarget target) {
            this.myTarget = target;
        }

        public IFigure getFigure() {
            if (this.myFigure == null) {
                if (this.myTarget.getAnchor() == null) {
                    if (this.myTarget.getContainer().getFigure() instanceof PolylineConnection) {
                        Polyline line = new Polyline();
                        line.setLineWidth(5);
                        line.setFill(false);
                        line.setPoints(((PolylineConnection)this.myTarget.getContainer().getFigure()).getPoints());
                        this.myFigure = line;
                    } else {
                        RectangleFigure r = new RectangleFigure();
                        r.setFill(false);
                        r.setOutline(true);
                        r.setForegroundColor(ColorConstants.blue);
                        this.myFigure = r;
                    }
                } else {
                    RectangleFigure r = new RectangleFigure();
                    r.setFill(false);
                    r.setBackgroundColor(ColorConstants.black);
                    this.myFigure = r;
                }
            }
            return this.myFigure;
        }

        public void layout(Point diagramPoint) {
            IFigure containerFigure = this.myTarget.getContainer().getFigure();
            IFigure anchorFigure = this.myTarget.getAnchor() == null ? null : this.myTarget.getAnchor().getFigure();
            boolean isBefore = this.myTarget.isBeforeAnchor();
            if (anchorFigure == null) {
                this.myFigure.setBounds(containerFigure.getBounds().getExpanded(5, 5));
            } else {
                int bottom;
                int top;
                Rectangle ab = anchorFigure.getBounds();
                Rectangle pb = containerFigure.getBounds();
                Rectangle b = new Rectangle();
                b.x = pb.x;
                b.width = pb.width;
                if (isBefore) {
                    IFigure prevChild = AnchorUtil.findPrevFigure((org.eclipse.gef.GraphicalEditPart)this.myTarget.getAnchor());
                    if (prevChild == null) {
                        top = pb.y;
                    } else {
                        Rectangle prevb = prevChild.getBounds();
                        top = prevb.y + prevb.height;
                    }
                    bottom = ab.y;
                } else {
                    top = ab.y + ab.height;
                    IFigure nextChild = AnchorUtil.findNextFigure((org.eclipse.gef.GraphicalEditPart)this.myTarget.getAnchor());
                    bottom = nextChild == null ? pb.y + pb.height : nextChild.getBounds().y;
                }
                b.y = diagramPoint.y;
                if (b.y < top) {
                    b.y = top;
                } else if (b.y > bottom) {
                    b.y = bottom;
                }
                b.height = 2;
                this.myFigure.setBounds(b);
            }
        }

        public AnchoredDiagramTarget getTarget() {
            return this.myTarget;
        }
    }
}

