/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.editpolicies;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IInsertableEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ComponentEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;

public class InsertingComponentEditPolicy
extends ComponentEditPolicy {
    private boolean myForListItem;

    public InsertingComponentEditPolicy(boolean forListItem) {
        this.myForListItem = forListItem;
    }

    public InsertingComponentEditPolicy() {
        this(false);
    }

    public void setForListItem(boolean forListItem) {
        this.myForListItem = forListItem;
    }

    protected IInsertableEditPart getInsertableEditPart() {
        if (this.myForListItem) {
            EditPart container = this.getHost().getParent();
            return container instanceof IInsertableEditPart ? (IInsertableEditPart)container : null;
        }
        return super.getInsertableEditPart();
    }

    protected Command getInsertCommand(GroupRequest insertRequest) {
        IInsertableEditPart insertEP = this.getInsertableEditPart();
        if (insertEP == null) {
            return null;
        }
        EObject hostElement = ViewUtil.resolveSemanticElement((View)((View)insertEP.getModel()));
        if (hostElement != null) {
            TransactionalEditingDomain editingDomain = this.getHostImpl().getEditingDomain();
            if (editingDomain == null) {
                return null;
            }
            CreateUnspecifiedTypeRequest createReq = new CreateUnspecifiedTypeRequest(Collections.singletonList(insertEP.getElementType()), this.getHostImpl().getDiagramPreferencesHint());
            Command result = insertEP.getCommand((Request)createReq);
            if (result != null && result.canExecute()) {
                result = new ICommandProxy((ICommand)new ExecuteCreationAndReturnEObjectCommand(editingDomain, (CreateRequest)createReq, result));
            }
            return result;
        }
        return null;
    }

    protected IGraphicalEditPart getHostImpl() {
        return (IGraphicalEditPart)this.getHost();
    }

    private static class ExecuteCreationAndReturnEObjectCommand
    extends AbstractTransactionalCommand {
        private final Command myActualCommand;
        private final CreateRequest myRequest;

        public ExecuteCreationAndReturnEObjectCommand(TransactionalEditingDomain domain, CreateRequest request, Command actualCommand) {
            super(domain, actualCommand.getLabel(), null);
            this.myRequest = request;
            this.myActualCommand = actualCommand;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.myActualCommand.execute();
            EObject createdSemantic = this.unwrapToSemantic(this.myRequest);
            return CommandResult.newOKCommandResult((Object)createdSemantic);
        }

        private EObject unwrapToSemantic(CreateRequest request) {
            Object creationResult = request.getNewObject();
            if (creationResult instanceof List) {
                creationResult = ((List)creationResult).get(0);
            }
            View createdView = null;
            if (creationResult instanceof IAdaptable) {
                createdView = (View)((IAdaptable)creationResult).getAdapter(View.class);
            }
            return createdView == null ? null : createdView.getElement();
        }
    }
}

