/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.async;

import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.diagram.common.async.SyncModelNode;

public class SyncModelLabelProvider
extends BaseLabelProvider
implements ILabelProvider,
IFontProvider {
    private final ILabelProvider myDelegate;
    private final FontRegistry myFontRegistry = new FontRegistry();
    protected static final String TREE_FONT = "TreeFont";

    public SyncModelLabelProvider(ILabelProvider pluginSpecificDelegate) {
        this.myDelegate = pluginSpecificDelegate;
    }

    public Image getImage(Object element) {
        if (!(element instanceof SyncModelNode)) {
            return null;
        }
        SyncModelNode node = (SyncModelNode)element;
        return this.myDelegate.getImage((Object)node);
    }

    public String getText(Object element) {
        if (!(element instanceof SyncModelNode)) {
            return null;
        }
        SyncModelNode node = (SyncModelNode)element;
        String text = this.myDelegate.getText((Object)node);
        return text;
    }

    public Font getFont(Object element) {
        if (!(element instanceof SyncModelNode)) {
            return null;
        }
        SyncModelNode node = (SyncModelNode)element;
        return node.isAutoSynchronized() ? this.myFontRegistry.getBold(TREE_FONT) : this.myFontRegistry.get(TREE_FONT);
    }

    protected void hookTreeViewer(CheckboxTreeViewer syncUI) {
        this.myFontRegistry.put(TREE_FONT, syncUI.getTree().getFont().getFontData());
    }

    protected final FontRegistry getFontRegistry() {
        return this.myFontRegistry;
    }
}

