/**
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * $Id: EJClassMapping.java,v 1.1 2007/03/18 08:10:12 lzhang Exp $
 */
package org.eclipse.eodm.util;

import java.util.HashMap;
import java.util.Iterator;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.eodm.owl.owlbase.*;
import org.eclipse.eodm.owl.owlbase.util.OWLBasePackage;
import org.eclipse.eodm.rdf.rdfbase.*;
import org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage;
import org.eclipse.eodm.rdf.rdfs.*;
import org.eclipse.eodm.rdf.rdfs.util.RDFSPackage;

public class EJClassMapping {

	protected static HashMap j2eClassMap = new HashMap() ;
	protected static HashMap e2jClassMap = new HashMap() ;
	
	public static EClass jclass2eclass(Class javaClass )
	{
		return (EClass)j2eClassMap.get( javaClass );
	}
	
	public static Class eclass2jclass(EClass eClass )
	{
		return (Class)e2jClassMap.get( eClass );
	}
	
	static {
		j2eClassMap.put( BlankNode.class, 		RDFBasePackage.eINSTANCE.getBlankNode() );
		j2eClassMap.put( URIReferenceNode.class, RDFBasePackage.eINSTANCE.getURIReferenceNode() );
		j2eClassMap.put( RDFSResource.class, 	RDFBasePackage.eINSTANCE.getRDFSResource() );
		j2eClassMap.put( RDFProperty.class, 		RDFBasePackage.eINSTANCE.getRDFProperty() );
		j2eClassMap.put( RDFSClass.class, 		RDFSPackage.eINSTANCE.getRDFSClass() );
		j2eClassMap.put( RDFSDatatype.class, 	RDFSPackage.eINSTANCE.getRDFSDatatype() );
		j2eClassMap.put( RDFList.class, 			RDFSPackage.eINSTANCE.getRDFList() );
		j2eClassMap.put( RDFSContainer.class, 	RDFSPackage.eINSTANCE.getRDFSContainer() );
		j2eClassMap.put( RDFAlt.class, 			RDFSPackage.eINSTANCE.getRDFAlt() );
		j2eClassMap.put( RDFBag.class, 			RDFSPackage.eINSTANCE.getRDFBag() );
		j2eClassMap.put( RDFSeq.class, 			RDFSPackage.eINSTANCE.getRDFSeq() );
		j2eClassMap.put( RDFStatement.class,    RDFBasePackage.eINSTANCE.getRDFStatement());
		j2eClassMap.put( RDFSContainerMembershipProperty.class, 	RDFSPackage.eINSTANCE.getRDFSContainerMembershipProperty() );
		j2eClassMap.put( OWLOntology.class, 		OWLBasePackage.eINSTANCE.getOWLOntology() );
		j2eClassMap.put( Statement.class, 		OWLBasePackage.eINSTANCE.getStatement() );
		j2eClassMap.put( OWLOntologyProperty.class, 	OWLBasePackage.eINSTANCE.getOWLOntologyProperty() );
		j2eClassMap.put( OWLClass.class, 			OWLBasePackage.eINSTANCE.getOWLClass() );
		j2eClassMap.put( OWLObjectProperty.class, 	OWLBasePackage.eINSTANCE.getOWLObjectProperty() );
		j2eClassMap.put( OWLDatatypeProperty.class, 	OWLBasePackage.eINSTANCE.getOWLDatatypeProperty() );
		j2eClassMap.put( Individual.class, 			OWLBasePackage.eINSTANCE.getIndividual() );
		j2eClassMap.put( OWLAllDifferent.class,	 	OWLBasePackage.eINSTANCE.getOWLAllDifferent() );
		j2eClassMap.put( OWLDataRange.class, 		OWLBasePackage.eINSTANCE.getOWLDataRange() );
		j2eClassMap.put( OWLAnnotationProperty.class, 	OWLBasePackage.eINSTANCE.getOWLAnnotationProperty() );
		j2eClassMap.put( EnumeratedClass.class, 		OWLBasePackage.eINSTANCE.getEnumeratedClass() );
		j2eClassMap.put( IntersectionClass.class, 	OWLBasePackage.eINSTANCE.getIntersectionClass() );
		j2eClassMap.put( UnionClass.class, 			OWLBasePackage.eINSTANCE.getUnionClass() );
		j2eClassMap.put( ComplementClass.class, 		OWLBasePackage.eINSTANCE.getComplementClass() );
		j2eClassMap.put( OWLRestriction.class, 	OWLBasePackage.eINSTANCE.getOWLRestriction() );
		j2eClassMap.put( HasValueRestriction.class, 	OWLBasePackage.eINSTANCE.getHasValueRestriction() );
		j2eClassMap.put( AllValuesFromRestriction.class, 	OWLBasePackage.eINSTANCE.getAllValuesFromRestriction() );
		j2eClassMap.put( SomeValuesFromRestriction.class, 	OWLBasePackage.eINSTANCE.getSomeValuesFromRestriction() );
		j2eClassMap.put( CardinalityRestriction.class, 		OWLBasePackage.eINSTANCE.getCardinalityRestriction() );
		j2eClassMap.put( MaxCardinalityRestriction.class, 	OWLBasePackage.eINSTANCE.getMaxCardinalityRestriction() );
		j2eClassMap.put( MinCardinalityRestriction.class, 	OWLBasePackage.eINSTANCE.getMinCardinalityRestriction() );
		j2eClassMap.put( Property.class, 						OWLBasePackage.eINSTANCE.getProperty() );
		
		Iterator iter = j2eClassMap.keySet().iterator();
		while (iter.hasNext())
		{
			Object key = iter.next();
			Object val = j2eClassMap.get( key );
			e2jClassMap.put( val, key );
		}
	}
	
}






