/**
 * <copyright> 
 * 
 * Copyright (c) 2004-2005 IBM Corporation and others. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License - v 1.0 
 * which accompanies this distribution, and is available at 
 * http://opensource.org/licenses/eclipse-1.0.txt 
 * 
 * Contributors: 
 *   IBM - Initial API and implementation 
 * 
 * </copyright> 
 * 
 * $Id: LoadAndSaveOWLbyOWLFile.java,v 1.2 2007/03/18 10:24:39 lzhang Exp $
 */

package org.eclipse.eodm.owl.resource;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Iterator;

import org.eclipse.eodm.RDFFactory;
import org.eclipse.eodm.exceptions.UnsupportedViewTypeException;
import org.eclipse.eodm.owl.resource.parser.OWLDocument;
import org.eclipse.eodm.owl.resource.parser.OWLParser;
import org.eclipse.eodm.owl.resource.parser.impl.OWLDocumentImpl;
import org.eclipse.eodm.owl.resource.parser.impl.OWLOntologyGraph;
import org.eclipse.eodm.owl.resource.parser.impl.OWLParserImpl;
import org.eclipse.eodm.rdf.rdfbase.RDFGraph;
import org.eclipse.eodm.rdf.rdfweb.Namespace;
import org.eclipse.eodm.rdf.rdfweb.NamespaceDefinition;
import org.eclipse.eodm.util.OWLUtility;
import org.eclipse.eodm.util.Triple;
import org.eclipse.eodm.vocabulary.OWL;
import org.eclipse.eodm.vocabulary.RDFS;

/**
 * This example shows how to load and save owl ontologies from owl files.
 */
public class LoadAndSaveOWLbyOWLFile {

    public static void main(String[] args) throws FileNotFoundException, UnsupportedViewTypeException, URISyntaxException {
        for (int jj = 0; jj < 1; jj++) {

            // New an OWL Parser
            OWLParser parser = new OWLParserImpl();

            // New an OWL Document
            // OWLDocument food = new
            // OWLDocumentImpl("D:\\eclipse\\workspace\\com.ibm.research.minerva-latest\\testcases\\eclass_51en.owl",
            // null,
            OWLDocument food = new OWLDocumentImpl("testcase/food.rdf", null,
                    true);
            // OWLDocument food2 = new OWLDocumentImpl("testcase\\wine.edf",
            // null,
            // true);
            // Add the document into the parser
            parser.addOWLDocument(food);
            parser.addURL2FileMapping("http://www.w3.org/TR/2003/PR-owl-guide-20031209/wine","testcase/wine.rdf");
            // parser.addOWLDocument(food2);
            // New an OWL Document
            // OWLDocument wine = new OWLDocumentImpl("./testcase/wine.owl",
            // "http://www.w3.org/TR/2003/PR-owl-guide-20031209/wine", true);
            // parser.addOWLDocument(wine);
            //
            // //Start to parse OWL documents and get OWL ontologies
            OWLOntologyGraph[] ontofood = parser.parseOWLDocument(food);
            // OWLOntologyGraph[] ontofood2 = parser.parseOWLDocument(food2);
            // OWLOntology ontowine = parser.parseOWLDocument(wine);

            Namespace rdfNs = RDFFactory.eINSTANCE.createNamespace("http://www.w3.org/1999/02/22-rdf-syntax-ns#");
            Namespace rdfsNs = RDFFactory.eINSTANCE.createNamespace("http://www.w3.org/2000/01/rdf-schema#");
            Namespace owlNs = RDFFactory.eINSTANCE.createNamespace("http://www.w3.org/2002/07/owl#");
            Namespace foodNs = RDFFactory.eINSTANCE.createNamespace("http://www.w3.org/TR/2003/PR-owl-guide-20031209/food#");
            Namespace wineNs = RDFFactory.eINSTANCE.createNamespace("http://www.w3.org/TR/2003/PR-owl-guide-20031209/wine#");
            
            NamespaceDefinition rdfNsd = RDFFactory.eINSTANCE.createNamespaceDefinition("rdf", rdfNs);
            NamespaceDefinition rdfsNsd = RDFFactory.eINSTANCE.createNamespaceDefinition("rdfs", rdfsNs);
            NamespaceDefinition owlNsd = RDFFactory.eINSTANCE.createNamespaceDefinition("owl", owlNs);
            NamespaceDefinition foodNsd = RDFFactory.eINSTANCE.createNamespaceDefinition("food", foodNs);
            NamespaceDefinition wineNsd = RDFFactory.eINSTANCE.createNamespaceDefinition("wine", wineNs);
            
            NamespaceDefinition[] nsds = new NamespaceDefinition[] {rdfNsd, rdfsNsd, owlNsd, foodNsd, wineNsd} ;
            
            System.out.println("\n========== Sensitive triples for food.rdf============");
            RDFGraph g = ontofood[0].getDocument().getComplementalGraph();          
            Iterator itr = g.getTriples() ;
            while (itr.hasNext())
            {
            	Triple t = (Triple)itr.next() ;
            	String predUri = t.getPredicate();
            	if ( predUri.equals(RDFS.P_COMMENT_STR) || predUri.equals(OWL.SAME_AS_URI) || 
            			(t.isObjectURI() && OWLUtility.SpecialProp.contains( t.getObjectURI() ) ) ) {
            		t.print(nsds);
            	}
            }
            
            System.out.println("\n========== Sensitive triples for wine.rdf ===========");
            g = ontofood[1].getDocument().getComplementalGraph();
            itr = g.getTriples() ;
            while (itr.hasNext())
            {
            	Triple t = (Triple)itr.next() ;
            	String predUri = t.getPredicate();
            	if ( predUri.equals(RDFS.P_COMMENT_STR) || predUri.equals(OWL.SAME_AS_URI) || 
            			(t.isObjectURI() && OWLUtility.SpecialProp.contains( t.getObjectURI() ) ) ) {
            		t.print(nsds);
            	}
            }
            
            System.out.println("\n========== Sensitive triples for food+wine ==========");
            g = ontofood[0].getgraph();           
            itr = g.getTriples() ;
            while (itr.hasNext())
            {
            	Triple t = (Triple)itr.next() ;
            	String predUri = t.getPredicate();
            	if ( predUri.equals(RDFS.P_COMMENT_STR) || predUri.equals(OWL.SAME_AS_URI) || 
            			(t.isObjectURI() && OWLUtility.SpecialProp.contains( t.getObjectURI() ) ) ) {
            		t.print(nsds);
            	}
            }
            
            System.out.println("\n========== End of Sensitive triples =================\n\n");
            
            // Save an OWLOntology
            try {
                OWLXMLSaver.saveToFile(ontofood[0].getDocument(),
                        "./testcase/testNew1.owl", "UTF-8");
                // OWLXMLSaver.saveToFile(ontowine, "./testcase/wine3.owl",
                // "UTF-8");
            } catch (IOException e1) {
                e1.printStackTrace();
            }
            // Free all resources if the parser will be not used.
            parser.clear();
        }
    }
}