/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eodm.rdf.resource.parser.impl;

import java.net.URISyntaxException;
import org.eclipse.eodm.RDFFactory;
import org.eclipse.eodm.exceptions.AddingTripleException;
import org.eclipse.eodm.exceptions.InvalidLexicalFormException;
import org.eclipse.eodm.exceptions.UnsupportedViewTypeException;
import org.eclipse.eodm.rdf.rdfbase.RDFGraph;
import org.eclipse.eodm.rdf.rdfbase.RDFSLiteral;
import org.eclipse.eodm.rdf.rdfweb.Document;
import org.eclipse.eodm.rdf.rdfweb.NamespaceDefinition;
import org.eclipse.eodm.rdf.resource.parser.element.RDFBlankNode;
import org.eclipse.eodm.rdf.resource.parser.element.RDFLiteralElement;
import org.eclipse.eodm.rdf.resource.parser.element.RDFResourceElement;
import org.eclipse.eodm.rdf.resource.parser.element.RDFValue;
import org.eclipse.eodm.rdf.resource.parser.element.URIReference;
import org.eclipse.eodm.rdf.resource.parser.exception.ParserException;
import org.eclipse.eodm.rdf.resource.parser.impl.RDFNamespaceMap;
import org.eclipse.eodm.util.Triple;

public class RDFTripleAnalyzer {
    private RDFNamespaceMap namespaceMap = new RDFNamespaceMap();
    private Document document;
    private RDFGraph graph;

    public RDFNamespaceMap getNamespaceMap() {
        return this.namespaceMap;
    }

    public Document getDocument() {
        return this.document;
    }

    public void initialize(String documentURI) {
        try {
            this.document = RDFFactory.eINSTANCE.createDocument(documentURI);
            this.graph = RDFFactory.eINSTANCE.createGraph(documentURI);
            this.document.setComplementalGraph(this.graph);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            throw new ParserException("RDF Parser errors: " + e.getMessage());
        }
        this.handleNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        this.handleNamespace("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        this.handleNamespace("xsd", "http://www.w3.org/2001/XMLSchema#");
        this.handleNamespace("bnode", "http://bnode.ibm.com#");
    }

    public NamespaceDefinition handleNamespace(String name, String uri) {
        NamespaceDefinition namespace = this.namespaceMap.getNamespace(uri);
        if (namespace == null || !name.equals(namespace.getNamespacePrefix()) && !uri.equals("http://bnode.ibm.com#") && !namespace.getNamespacePrefix().startsWith("ns_")) {
            namespace = this.createNamespace(name, uri);
            this.namespaceMap.addNamespace(namespace);
            this.document.getNamespaceDefinition().add((Object)namespace);
        } else if (namespace != null && name != null && name.length() > 0 && namespace.getNamespacePrefix().startsWith("ns_") && !name.startsWith("ns_")) {
            namespace.setNamespacePrefix(name);
        }
        return namespace;
    }

    private NamespaceDefinition createNamespace(String name, String uri) {
        NamespaceDefinition namespace = null;
        try {
            namespace = RDFFactory.eINSTANCE.createNamespaceDefinition(name, RDFFactory.eINSTANCE.createNamespace(uri));
        }
        catch (URISyntaxException e) {
            throw new ParserException("RDF parser exception: " + e.getMessage());
        }
        return namespace;
    }

    public NamespaceDefinition getNamespaceByURI(String uri) {
        NamespaceDefinition namespace = this.namespaceMap.getNamespace(uri);
        if (namespace == null) {
            namespace = this.handleNamespace(null, uri);
        }
        return namespace;
    }

    public void analyseTriple(RDFResourceElement subject, URIReference predicate, RDFValue object) {
        Triple triple = new Triple();
        if (subject instanceof RDFBlankNode) {
            triple.setSubjectNodeID(subject.getLocalName());
        } else {
            triple.setSubjectURI(this.getNamespaceByURI(subject.getNamespace()).getNamespace(), subject.getLocalName());
        }
        triple.setPredicateUriRef(this.getNamespaceByURI(predicate.getNamespace()).getNamespace(), predicate.getLocalName());
        if (object instanceof RDFBlankNode) {
            triple.setObjectNodeID(((RDFBlankNode)object).getLocalName());
        } else if (object instanceof URIReference) {
            URIReference uri = (URIReference)object;
            triple.setObjectURI(this.getNamespaceByURI(uri.getNamespace()).getNamespace(), uri.getLocalName());
        } else {
            RDFLiteralElement literal = (RDFLiteralElement)object;
            URIReference typeRef = literal.getDatatype();
            if (typeRef != null) {
                if (typeRef.getFullURI().equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral")) {
                    try {
                        triple.setObjectLiteral((RDFSLiteral)RDFFactory.eINSTANCE.createRDFXMLLiteral(literal.getText()));
                    }
                    catch (InvalidLexicalFormException e) {
                        e.printStackTrace();
                        throw new ParserException("RDF Parser errors: " + e.getMessage());
                    }
                } else {
                    try {
                        triple.setObjectLiteral((RDFSLiteral)RDFFactory.eINSTANCE.createTypedLiteral(literal.getText(), literal.getDatatype().getFullURI()));
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                        throw new ParserException("RDF Parser errors: " + e.getMessage());
                    }
                    catch (InvalidLexicalFormException e) {
                        e.printStackTrace();
                        throw new ParserException("RDF Parser errors: " + e.getMessage());
                    }
                }
            } else if (literal.getLanguage() != null) {
                triple.setObjectLiteral((RDFSLiteral)RDFFactory.eINSTANCE.createPlainLiteral(literal.getText(), literal.getLanguage()));
            } else if (predicate.getFullURI().equals("http://www.w3.org/2000/01/rdf-schema#comment") || predicate.getFullURI().equals("http://www.w3.org/2000/01/rdf-schema#label")) {
                triple.setObjectLiteral((RDFSLiteral)RDFFactory.eINSTANCE.createPlainLiteral(literal.getText(), null));
            } else {
                triple.setObjectLiteral(RDFFactory.eINSTANCE.createRDFSLiteral(literal.getText()));
            }
        }
        try {
            this.graph.addTriple(triple);
        }
        catch (UnsupportedViewTypeException e) {
            e.printStackTrace();
            throw new ParserException("RDF Parser errors: " + e.getMessage());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            throw new ParserException("RDF Parser errors: " + e.getMessage());
        }
        catch (AddingTripleException e) {
            e.printStackTrace();
            throw new ParserException("RDF Parser errors: " + e.getMessage());
        }
    }

    public void endAnalyzing() {
    }

    public void clearResources() {
        this.namespaceMap.removeAllNamespaces();
    }
}

