/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eodm.rdf.resource;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.eodm.rdf.rdfweb.Document;
import org.eclipse.eodm.rdf.resource.RDFXMLResourceFactoryImpl;
import org.eclipse.eodm.util.Triple;

public class LoadAndSaveRDFExample {
    public static void main(String[] args) {
        try {
            Document ontology = LoadAndSaveRDFExample.load();
            ArrayList export = ontology.getComplementalGraph().exportTriples();
            int i = 0;
            while (i < export.size()) {
                ((Triple)export.get(i)).print();
                ++i;
            }
            System.out.println("----------------------------------");
            LoadAndSaveRDFExample.save(ontology);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected static Document load() throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("rdf", new RDFXMLResourceFactoryImpl());
        URI fileURI = URI.createFileURI((String)new File("testcase/food.rdf").getAbsolutePath());
        Resource resource = resourceSet.createResource(fileURI);
        resource.load(Collections.EMPTY_MAP);
        return (Document)resource.getContents().get(0);
    }

    protected static void save(Document ontology) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("rdf", new RDFXMLResourceFactoryImpl());
        URI fileURI = URI.createFileURI((String)new File("testcase/OrderType6.rdf").getAbsolutePath());
        Resource resource = resourceSet.createResource(fileURI);
        resource.getContents().add((Object)ontology);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", "UTF-8");
        resource.save(options);
    }
}

