/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.internal.operations;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.uml2.common.util.UnionEObjectEList;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Component;
import org.eclipse.uml2.uml.ComponentRealization;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Realization;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.Usage;
import org.eclipse.uml2.uml.internal.operations.ClassOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentOperations
extends ClassOperations {
    protected ComponentOperations() {
    }

    public static Class createOwnedClass(Component component, String name, boolean isAbstract) {
        Class ownedClass = (Class)component.createPackagedElement(name, UMLPackage.Literals.CLASS);
        ownedClass.setIsAbstract(isAbstract);
        return ownedClass;
    }

    public static Enumeration createOwnedEnumeration(Component component, String name) {
        return (Enumeration)component.createPackagedElement(name, UMLPackage.Literals.ENUMERATION);
    }

    public static PrimitiveType createOwnedPrimitiveType(Component component, String name) {
        return (PrimitiveType)component.createPackagedElement(name, UMLPackage.Literals.PRIMITIVE_TYPE);
    }

    public static Interface createOwnedInterface(Component component, String name) {
        return (Interface)component.createPackagedElement(name, UMLPackage.Literals.INTERFACE);
    }

    public static EList<Interface> realizedInterfaces(Component component, Classifier classifier) {
        return ECollections.unmodifiableEList(ComponentOperations.realizedInterfaces(component, classifier, true));
    }

    protected static EList<Interface> realizedInterfaces(Component component, Classifier classifier, boolean resolve) {
        return ComponentOperations.realizedInterfaces(component, classifier, resolve, (EList<Interface>)new UniqueEList.FastCompare());
    }

    protected static EList<Interface> realizedInterfaces(Component component, Classifier classifier, boolean resolve, EList<Interface> realizedInterfaces) {
        for (Dependency clientDependency : classifier.getClientDependencies()) {
            if (!(clientDependency instanceof Realization)) continue;
            Iterator suppliers = resolve ? clientDependency.getSuppliers().iterator() : ((InternalEList)clientDependency.getSuppliers()).basicIterator();
            while (suppliers.hasNext()) {
                NamedElement supplier = (NamedElement)suppliers.next();
                if (!(supplier instanceof Interface)) continue;
                realizedInterfaces.add((Object)((Interface)supplier));
            }
        }
        return realizedInterfaces;
    }

    public static EList<Interface> usedInterfaces(Component component, Classifier classifier) {
        return ECollections.unmodifiableEList(ComponentOperations.usedInterfaces(component, classifier, true));
    }

    protected static EList<Interface> usedInterfaces(Component component, Classifier classifier, boolean resolve) {
        return ComponentOperations.usedInterfaces(component, classifier, resolve, (EList<Interface>)new UniqueEList.FastCompare());
    }

    protected static EList<Interface> usedInterfaces(Component component, Classifier classifier, boolean resolve, EList<Interface> usedInterfaces) {
        for (Dependency clientDependency : classifier.getClientDependencies()) {
            if (!(clientDependency instanceof Usage)) continue;
            Iterator suppliers = resolve ? clientDependency.getSuppliers().iterator() : ((InternalEList)clientDependency.getSuppliers()).basicIterator();
            while (suppliers.hasNext()) {
                NamedElement supplier = (NamedElement)suppliers.next();
                if (!(supplier instanceof Interface)) continue;
                usedInterfaces.add((Object)((Interface)supplier));
            }
        }
        return usedInterfaces;
    }

    public static EList<Interface> getRequireds(Component component) {
        EList<Interface> requireds = ComponentOperations.usedInterfaces(component, component, false, (EList<Interface>)new UniqueEList.FastCompare());
        for (ComponentRealization realization : component.getRealizations()) {
            Classifier realizingClassifier = realization.getRealizingClassifier();
            if (realizingClassifier == null) continue;
            ComponentOperations.usedInterfaces(component, realizingClassifier, false, requireds);
            for (Classifier parent : realizingClassifier.allParents()) {
                ComponentOperations.usedInterfaces(component, parent, false, requireds);
            }
        }
        for (Port ownedPort : component.getOwnedPorts()) {
            requireds.addAll((Collection)((InternalEList)ownedPort.getRequireds()).basicList());
        }
        return new UnionEObjectEList((InternalEObject)component, (EStructuralFeature)UMLPackage.Literals.COMPONENT__REQUIRED, requireds.size(), requireds.toArray());
    }

    public static EList<Interface> getProvideds(Component component) {
        EList<Interface> provideds = ComponentOperations.realizedInterfaces(component, component, false, (EList<Interface>)new UniqueEList.FastCompare());
        for (ComponentRealization realization : component.getRealizations()) {
            Classifier realizingClassifier = realization.getRealizingClassifier();
            if (realizingClassifier == null) continue;
            ComponentOperations.realizedInterfaces(component, realizingClassifier, false, provideds);
            for (Classifier parent : realizingClassifier.allParents()) {
                ComponentOperations.realizedInterfaces(component, parent, false, provideds);
            }
        }
        for (Port ownedPort : component.getOwnedPorts()) {
            provideds.addAll((Collection)((InternalEList)ownedPort.getProvideds()).basicList());
        }
        return new UnionEObjectEList((InternalEObject)component, (EStructuralFeature)UMLPackage.Literals.COMPONENT__PROVIDED, provideds.size(), provideds.toArray());
    }

    protected static EList<Interface> getAllProvideds(Component component, EList<Interface> allProvideds) {
        allProvideds.addAll(component.getProvideds());
        for (Classifier parent : component.allParents()) {
            if (parent instanceof Component) {
                allProvideds.addAll(((Component)parent).getProvideds());
                continue;
            }
            ComponentOperations.realizedInterfaces(component, parent, true, allProvideds);
        }
        return allProvideds;
    }

    protected static EList<Interface> getAllRequireds(Component component, EList<Interface> allRequireds) {
        allRequireds.addAll(component.getRequireds());
        for (Classifier parent : component.allParents()) {
            if (parent instanceof Component) {
                allRequireds.addAll(((Component)parent).getRequireds());
                continue;
            }
            ComponentOperations.usedInterfaces(component, parent, true, allRequireds);
        }
        return allRequireds;
    }
}

