/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.internal.layout.model;

import java.awt.Point;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.AbsLink;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMFoundInvocationOccurence;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMMessage;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMMessageEnd;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMReceiveMessageEnd;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMSendMessageEnd;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.MessageLabelLayouter;

class LMFoundMessage
extends LMMessage {
    private LMReceiveMessageEnd myReceiveMessageEnd;
    private LMSendMessageEnd mySendMessageEnd;
    private LMMessageEnd.FloatingPositioning mySendPositioning;
    private LMReceiveMessageEnd.HorizontalPositioning myReceivePositioning;
    private final boolean myIsFromSendToReceive;

    LMFoundMessage(AbsLink gdeLink, boolean isFromSendToReceive) {
        super(gdeLink);
        this.myIsFromSendToReceive = isFromSendToReceive;
    }

    boolean isFromSendToReceive() {
        return this.myIsFromSendToReceive;
    }

    public void layoutHorizontally(boolean fullLayout) {
        Point[] linkPoints;
        int limit2;
        int limit1;
        if (this.mySendPositioning == null) {
            throw new RuntimeException("No send message positioning");
        }
        if (this.myReceivePositioning == null) {
            throw new RuntimeException("No receive message positioning");
        }
        int endMiddleXPos = this.myReceivePositioning.getReceiveMiddleXPos();
        int startXPos = fullLayout ? endMiddleXPos - 35 : this.mySendPositioning.getXPos();
        boolean goesFromRight = startXPos >= endMiddleXPos;
        int endXPos = this.myReceivePositioning.getReceiveEndXPos(goesFromRight);
        if (goesFromRight) {
            limit1 = endMiddleXPos + 35;
            limit2 = endMiddleXPos + 80;
            if (startXPos < limit1) {
                startXPos = limit1;
            }
            if (startXPos > limit2) {
                startXPos = limit2;
            }
        } else {
            limit1 = endMiddleXPos - 35;
            limit2 = endMiddleXPos - 80;
            if (startXPos > limit1) {
                startXPos = limit1;
            }
            if (startXPos < limit2) {
                startXPos = limit2;
            }
        }
        if (this.myIsFromSendToReceive) {
            this.mySendPositioning.setXPos(startXPos);
            startXPos = this.mySendPositioning.getXPos();
        }
        if (!this.myIsFromSendToReceive) {
            int t = startXPos;
            startXPos = endXPos;
            endXPos = t;
        }
        int endYPos = (linkPoints = this.getGdeLink().getLinkPoints()).length < 1 ? 0 : linkPoints[linkPoints.length - 1].y;
        Point[] newPoints = new Point[]{new Point(startXPos, endYPos), new Point(endXPos, endYPos)};
        this.getGdeLink().setLinkPoints(newPoints);
        MessageLabelLayouter.layoutMessageLabelsHorizontally(this.getGdeLink(), startXPos, endXPos, fullLayout);
    }

    void setLMMessageEndVerticalPosition(int pos, boolean sourceNotDestination, int siblingNumber) {
        int endXPos;
        int startXPos;
        LMFoundInvocationOccurence foundInvocationOccurence = (LMFoundInvocationOccurence)this.getSendMessageEnd();
        if (foundInvocationOccurence == null) {
            throw new RuntimeException("No send message end");
        }
        LMReceiveMessageEnd receiveMessageEnd = this.getReceiveMessageEnd();
        if (receiveMessageEnd == null) {
            throw new RuntimeException("No receive message end");
        }
        Point[] linkPoints = this.getGdeLink().getLinkPoints();
        if (linkPoints.length < 1) {
            startXPos = 10;
            endXPos = 10;
        } else {
            startXPos = linkPoints[0].x;
            endXPos = linkPoints[linkPoints.length - 1].x;
        }
        int receiveY = pos;
        int sendY = pos + siblingNumber * 15;
        Point[] newPoints = new Point[]{new Point(startXPos, sendY), new Point(endXPos, receiveY)};
        this.getGdeLink().setLinkPoints(newPoints);
        if (this.myIsFromSendToReceive) {
            this.mySendPositioning.setYPos(sendY);
        }
        MessageLabelLayouter.layoutMessageLabelsVertically(this.getGdeLink(), sendY);
    }

    LMSendMessageEnd getSendMessageEnd() {
        return this.mySendMessageEnd;
    }

    LMReceiveMessageEnd getReceiveMessageEnd() {
        return this.myReceiveMessageEnd;
    }

    protected void setSendMessageEnd(LMSendMessageEnd sendMessageEnd, LMMessageEnd.FloatingPositioning sendEndPositioning) {
        this.mySendMessageEnd = sendMessageEnd;
        this.mySendPositioning = sendEndPositioning;
        this.sourceOrDestinationChanged();
    }

    protected void setReceiveMessageEnd(LMReceiveMessageEnd receiveMessageEnd, LMReceiveMessageEnd.HorizontalPositioning receiveEndPositioning) {
        this.myReceiveMessageEnd = receiveMessageEnd;
        this.myReceivePositioning = receiveEndPositioning;
        this.sourceOrDestinationChanged();
    }

    void resetSendMessageEnd() {
        this.mySendMessageEnd = null;
        this.mySendPositioning = null;
        this.sourceOrDestinationChanged();
    }

    void resetReceiveMessageEnd() {
        this.myReceiveMessageEnd = null;
        this.myReceivePositioning = null;
        this.sourceOrDestinationChanged();
    }

    void becomeLayoutConstraint(boolean on) {
    }

    boolean isLayoutConstraint() {
        return false;
    }
}

