/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.async;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.diagram.common.async.SyncModelLabelProvider;
import org.eclipse.uml2.diagram.common.async.SyncModelNode;
import org.eclipse.uml2.diagram.common.async.SyncModelUI;

public class SynchronizeDiagramDialog
extends Dialog {
    private final ILabelProvider myPluginSpecificLabelProvider;
    private SyncModelUI mySyncUI;
    private final SyncModelNode myRootNode;
    private final List<ViewerFilter> myViewerFilters = new LinkedList<ViewerFilter>();

    public SynchronizeDiagramDialog(Shell shell, SyncModelNode rootNode, ILabelProvider pluginSpecificLableProvider) {
        super(shell);
        this.myRootNode = rootNode;
        this.myPluginSpecificLabelProvider = pluginSpecificLableProvider;
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setBlockOnOpen(true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.getShell().setText("Choose synchronization mode");
        this.mySyncUI = new SyncModelUI(composite, new SyncModelLabelProvider(this.myPluginSpecificLabelProvider));
        this.mySyncUI.setRootNode(this.getRootSyncNode());
        for (ViewerFilter nextFilter : this.myViewerFilters) {
            this.mySyncUI.getUI().addFilter(nextFilter);
        }
        this.mySyncUI.revealRootChildren();
        return composite;
    }

    protected void addFilter(ViewerFilter filter) {
        if (this.mySyncUI == null || this.mySyncUI.getUI() == null) {
            this.myViewerFilters.add(filter);
        } else {
            this.mySyncUI.getUI().addFilter(filter);
        }
    }

    protected Control createButtonBar(Composite parent) {
        Control buttonBar = super.createButtonBar(parent);
        this.setOkButtonEnabled(true);
        return buttonBar;
    }

    private void setOkButtonEnabled(boolean enabled) {
        this.getButton(0).setEnabled(enabled);
    }

    public SyncModelNode getRootSyncNode() {
        return this.myRootNode;
    }

    protected SyncModelUI getSyncUI() {
        return this.mySyncUI;
    }
}

