/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.internal.stereo;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.diagram.common.internal.stereo.StereotypeApplicationTaggedValueAdapter;
import org.eclipse.uml2.diagram.common.stereo.TaggedValueHelper;
import org.eclipse.uml2.diagram.common.stereo.TaggedValueListener;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

public class TaggedValueHelperImpl
implements TaggedValueHelper {
    private final Element myExistingStereotypedElement;
    private final EObject myRawReference;
    private final Stereotype myStereo;

    public TaggedValueHelperImpl(Element existingStereotypedElement, Stereotype stereo) {
        this.myExistingStereotypedElement = existingStereotypedElement;
        this.myStereo = stereo;
        this.myRawReference = existingStereotypedElement.getStereotypeApplication(stereo);
    }

    public void addTaggedValueListener(TaggedValueListener listener) {
        this.myRawReference.eAdapters().add((Object)new StereotypeApplicationTaggedValueAdapter(listener));
    }

    public void removeTaggedValueListener(TaggedValueListener l) {
        StereotypeApplicationTaggedValueAdapter forListener = null;
        for (Adapter next : this.myRawReference.eAdapters()) {
            if (!(next instanceof StereotypeApplicationTaggedValueAdapter) || !((StereotypeApplicationTaggedValueAdapter)next).isForListener(l)) continue;
            forListener = (StereotypeApplicationTaggedValueAdapter)next;
            break;
        }
        if (forListener != null) {
            this.myRawReference.eAdapters().remove(forListener);
        }
    }

    public Stereotype getStereotype() {
        return this.myStereo;
    }

    public Element getStereotypeOwner() {
        return this.myExistingStereotypedElement;
    }

    public boolean isAlive() {
        return this.myRawReference != null;
    }
}

