/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.usecase.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.uml2.diagram.usecase.edit.policies.UMLBaseItemSemanticEditPolicy;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Generalization;

public class GeneralizationReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject oldEnd;
    private final EObject newEnd;

    public GeneralizationReorientCommand(ReorientRelationshipRequest request) {
        super(request.getLabel(), request.getRelationship(), (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.getElementToEdit() instanceof Generalization)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        if (!(this.oldEnd instanceof Classifier) || !(this.newEnd instanceof Classifier)) {
            return false;
        }
        Classifier target = this.getLink().getGeneral();
        if (!(this.getLink().eContainer() instanceof Classifier)) {
            return false;
        }
        Classifier container = (Classifier)this.getLink().eContainer();
        return UMLBaseItemSemanticEditPolicy.LinkConstraints.canExistGeneralization_4003(container, this.getNewSource(), target);
    }

    protected boolean canReorientTarget() {
        if (!(this.oldEnd instanceof Classifier) || !(this.newEnd instanceof Classifier)) {
            return false;
        }
        Classifier source = this.getLink().getSpecific();
        if (!(this.getLink().eContainer() instanceof Classifier)) {
            return false;
        }
        Classifier container = (Classifier)this.getLink().eContainer();
        return UMLBaseItemSemanticEditPolicy.LinkConstraints.canExistGeneralization_4003(container, source, this.getNewTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        this.getLink().setSpecific(this.getNewSource());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        this.getLink().setGeneral(this.getNewTarget());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected Generalization getLink() {
        return (Generalization)this.getElementToEdit();
    }

    protected Classifier getOldSource() {
        return (Classifier)this.oldEnd;
    }

    protected Classifier getNewSource() {
        return (Classifier)this.newEnd;
    }

    protected Classifier getOldTarget() {
        return (Classifier)this.oldEnd;
    }

    protected Classifier getNewTarget() {
        return (Classifier)this.newEnd;
    }
}

