package org.eclipse.uml2.diagram.codegen;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.gmf.codegen.util.CodegenEmitters;
import org.eclipse.gmf.common.UnexpectedBehaviourException;
import org.eclipse.gmf.internal.codegen.dispatch.StaticTemplateRegistry;
import org.eclipse.gmf.internal.common.codegen.TextEmitter;

@SuppressWarnings("restriction")
public class CodegenEmittersExt extends CodegenEmitters {
	
	public CodegenEmittersExt(boolean usePrecompiled, String templateDirectory) {
		super(usePrecompiled, templateDirectory, extendVariables(), extendRegistry());
	}
	
	private static String[] extendVariables(){
		String[] defaultVariables = getDefaultVariables();
		String[] extended = new String[] {
			"org.eclipse.uml2.diagram.codegen", 
		};
		
		String[] result = new String[defaultVariables.length + extended.length];
		System.arraycopy(defaultVariables, 0, result, 0, defaultVariables.length);
		System.arraycopy(extended, 0, result, defaultVariables.length, extended.length);
		return result;
	}
	
	private static StaticTemplateRegistry extendRegistry(){
		return new StaticTemplateRegistry(CodegenEmittersExt.class.getClassLoader());
	}

	public TextEmitter getChangeNotationActionEmitter() throws UnexpectedBehaviourException {
		return newXpandEmitter("xpt::actions::ChangeNotationAction::ChangeNotationAction"); //$NON-NLS-1$
	}

	public String getChangeNotationActionName(Object... input) throws UnexpectedBehaviourException {
		return getQualifiedClassName("xpt::actions::ChangeNotationAction::qualifiedClassName", input); //$NON-NLS-1$
	}

	public TextEmitter getChangeNotationContributionItemProviderEmitter() throws UnexpectedBehaviourException {
		return newXpandEmitter("xpt::actions::ChangeNotationContributionItemProvider::ChangeNotationContributionItemProvider"); //$NON-NLS-1$
	}

	public String getChangeNotationContributionItemProviderName(Object... input) throws UnexpectedBehaviourException {
		return getQualifiedClassName("xpt::actions::ChangeNotationContributionItemProvider::qualifiedClassName", input); //$NON-NLS-1$
	}

	public TextEmitter getIconStylePreferencePageEmitter() throws UnexpectedBehaviourException {
		return newXpandEmitter("xpt::preferences::IconStylePreferencePage::IconStylePreferencePage"); //$NON-NLS-1$
	}

	public String getIconStylePreferencePageFQN(Object... input) throws UnexpectedBehaviourException {
		return getQualifiedClassName("xpt::preferences::IconStylePreferencePage::qualifiedClassName", input); //$NON-NLS-1$
	}

	/**
	 * Returns qualified class name defined in template.
	 */
	private String getQualifiedClassName(String templateName, Object... input) throws UnexpectedBehaviourException {
		TextEmitter emitter = newXpandEmitter(templateName);
		return getText(emitter, input);
	}

	/**
	 * copy from the private method in super class
	 * Returns text generated by emitter.
	 */
	private String getText(TextEmitter emitter, Object... input) throws UnexpectedBehaviourException {
		try {
			return emitter.generate(new NullProgressMonitor(), input).trim();
		} catch (InterruptedException ie) {
			return null;
		} catch (InvocationTargetException ite) {
			throw new UnexpectedBehaviourException(ite.getCause());
		}
	}


}
