/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.deploy.part;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.diagram.deploy.expressions.UMLAbstractExpression;
import org.eclipse.uml2.diagram.deploy.expressions.UMLOCLFactory;
import org.eclipse.uml2.diagram.deploy.part.UMLDiagramEditorPlugin;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLPackage;

public class UMLVisualIDRegistry {
    private static final String DEBUG_KEY = String.valueOf(UMLDiagramEditorPlugin.getInstance().getBundle().getSymbolicName()) + "/debug/visualID";
    private static final UMLAbstractExpression Node_2004_Constraint = UMLOCLFactory.getExpression("not oclIsKindOf(uml::Device) and not oclIsKindOf(uml::ExecutionEnvironment)", (EClassifier)UMLPackage.eINSTANCE.getNode());
    private static final UMLAbstractExpression Artifact_2006_Constraint = UMLOCLFactory.getExpression("not oclIsKindOf(uml::DeploymentSpecification)", (EClassifier)UMLPackage.eINSTANCE.getArtifact());
    private static final UMLAbstractExpression Artifact_3002_Constraint = UMLOCLFactory.getExpression("not oclIsKindOf(uml::DeploymentSpecification)", (EClassifier)UMLPackage.eINSTANCE.getArtifact());
    private static final UMLAbstractExpression Node_3007_Constraint = UMLOCLFactory.getExpression("not oclIsKindOf(uml::Device) and not oclIsKindOf(uml::ExecutionEnvironment)", (EClassifier)UMLPackage.eINSTANCE.getNode());

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("UMLDeployment".equals(view.getType())) {
                return 1000;
            }
            return -1;
        }
        return UMLVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getVisualID(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException numberFormatException) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY))) {
                UMLDiagramEditorPlugin.getInstance().logError("Unable to parse view type as a visualID number: " + type);
            }
            return -1;
        }
    }

    public static String getType(int visualID) {
        return String.valueOf(visualID);
    }

    public static int getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDiagram((Package)domainElement)) {
            return 1000;
        }
        return -1;
    }

    public static int getNodeVisualID(View containerView, EObject domainElement) {
        int containerVisualID;
        if (domainElement == null) {
            return -1;
        }
        String containerModelID = UMLVisualIDRegistry.getModelID(containerView);
        if (!"UMLDeployment".equals(containerModelID)) {
            return -1;
        }
        if ("UMLDeployment".equals(containerModelID)) {
            containerVisualID = UMLVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return -1;
        }
        switch (containerVisualID) {
            case 7001: {
                if (!UMLPackage.eINSTANCE.getElementImport().isSuperTypeOf(domainElement.eClass())) break;
                return 3001;
            }
            case 7004: {
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 3004;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.evaluate(Artifact_3002_Constraint, domainElement)) {
                    return 3002;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 3005;
                }
                if (!UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.evaluate(Node_3007_Constraint, domainElement)) break;
                return 3007;
            }
            case 7005: {
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 3004;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.evaluate(Artifact_3002_Constraint, domainElement)) {
                    return 3002;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 3005;
                }
                if (!UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.evaluate(Node_3007_Constraint, domainElement)) break;
                return 3007;
            }
            case 7006: {
                if (!UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) break;
                return 3006;
            }
            case 7002: {
                if (!UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) break;
                return 3006;
            }
            case 7003: {
                if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) break;
                return 3003;
            }
            case 1000: {
                if (containerView instanceof Diagram && domainElement != null && domainElement.equals(containerView.getElement())) {
                    return 2001;
                }
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 2003;
                }
                if (UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.evaluate(Node_2004_Constraint, domainElement)) {
                    return 2004;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 2005;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.evaluate(Artifact_2006_Constraint, domainElement)) {
                    return 2006;
                }
                if (!UMLPackage.eINSTANCE.getDeploymentSpecification().isSuperTypeOf(domainElement.eClass())) break;
                return 2007;
            }
        }
        return -1;
    }

    public static boolean canCreateNode(View containerView, int nodeVisualID) {
        int containerVisualID;
        String containerModelID = UMLVisualIDRegistry.getModelID(containerView);
        if (!"UMLDeployment".equals(containerModelID)) {
            return false;
        }
        if ("UMLDeployment".equals(containerModelID)) {
            containerVisualID = UMLVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return false;
        }
        switch (containerVisualID) {
            case 2001: {
                if (5001 == nodeVisualID) {
                    return true;
                }
                if (7001 != nodeVisualID) break;
                return true;
            }
            case 2003: {
                if (5002 == nodeVisualID) {
                    return true;
                }
                if (7004 != nodeVisualID) break;
                return true;
            }
            case 2004: {
                if (5003 != nodeVisualID) break;
                return true;
            }
            case 2005: {
                if (5004 == nodeVisualID) {
                    return true;
                }
                if (7002 != nodeVisualID) break;
                return true;
            }
            case 2006: {
                if (5005 != nodeVisualID) break;
                return true;
            }
            case 2007: {
                if (5006 == nodeVisualID) {
                    return true;
                }
                if (7003 != nodeVisualID) break;
                return true;
            }
            case 3004: {
                if (5010 == nodeVisualID) {
                    return true;
                }
                if (7005 != nodeVisualID) break;
                return true;
            }
            case 3002: {
                if (5007 != nodeVisualID) break;
                return true;
            }
            case 3005: {
                if (5008 == nodeVisualID) {
                    return true;
                }
                if (7006 != nodeVisualID) break;
                return true;
            }
            case 3007: {
                if (5009 != nodeVisualID) break;
                return true;
            }
            case 7001: {
                if (3001 != nodeVisualID) break;
                return true;
            }
            case 7004: {
                if (3004 == nodeVisualID) {
                    return true;
                }
                if (3002 == nodeVisualID) {
                    return true;
                }
                if (3005 == nodeVisualID) {
                    return true;
                }
                if (3007 != nodeVisualID) break;
                return true;
            }
            case 7005: {
                if (3004 == nodeVisualID) {
                    return true;
                }
                if (3002 == nodeVisualID) {
                    return true;
                }
                if (3005 == nodeVisualID) {
                    return true;
                }
                if (3007 != nodeVisualID) break;
                return true;
            }
            case 7006: {
                if (3006 != nodeVisualID) break;
                return true;
            }
            case 7002: {
                if (3006 != nodeVisualID) break;
                return true;
            }
            case 7003: {
                if (3003 != nodeVisualID) break;
                return true;
            }
            case 1000: {
                if (2001 == nodeVisualID) {
                    return true;
                }
                if (2003 == nodeVisualID) {
                    return true;
                }
                if (2004 == nodeVisualID) {
                    return true;
                }
                if (2005 == nodeVisualID) {
                    return true;
                }
                if (2006 == nodeVisualID) {
                    return true;
                }
                if (2007 != nodeVisualID) break;
                return true;
            }
            case 4001: {
                if (6001 != nodeVisualID) break;
                return true;
            }
            case 4002: {
                if (6002 != nodeVisualID) break;
                return true;
            }
            case 4004: {
                if (6003 != nodeVisualID) break;
                return true;
            }
        }
        return false;
    }

    public static int getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (UMLPackage.eINSTANCE.getDeployment().isSuperTypeOf(domainElement.eClass())) {
            return 4001;
        }
        if (UMLPackage.eINSTANCE.getManifestation().isSuperTypeOf(domainElement.eClass())) {
            return 4002;
        }
        if (UMLPackage.eINSTANCE.getCommunicationPath().isSuperTypeOf(domainElement.eClass())) {
            return 4004;
        }
        return -1;
    }

    private static boolean isDiagram(Package element) {
        return true;
    }

    private static boolean evaluate(UMLAbstractExpression expression, Object element) {
        Object result = expression.evaluate(element);
        return result instanceof Boolean && (Boolean)result != false;
    }

    protected static boolean hasViewChild(View containerView, EObject domainElement, int visualId) {
        if (domainElement == null) {
            return false;
        }
        for (Object next : containerView.getChildren()) {
            View nextView = (View)next;
            if (!domainElement.equals(nextView.getElement()) || !UMLVisualIDRegistry.getType(visualId).equals(nextView.getType())) continue;
            return true;
        }
        return false;
    }
}

