/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.clazz.edit.commands;

import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.commands.SetConnectionBendpointsCommand;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.diagram.clazz.edit.helpers.DependencyEditHelper;
import org.eclipse.uml2.diagram.clazz.part.CustomMessages;
import org.eclipse.uml2.diagram.clazz.providers.UMLElementTypes;
import org.eclipse.uml2.uml.Dependency;

public class ChangeDependencyTypeCommand
extends CompoundCommand {
    private EClass dependencyType;
    private ConnectionEditPart editPart;
    private CreateConnectionViewAndElementRequest createViewRequest;

    public ChangeDependencyTypeCommand(ConnectionEditPart editPart, EClass dependencyType) {
        this(editPart, dependencyType, PreferencesHint.USE_DEFAULTS);
    }

    public ChangeDependencyTypeCommand(ConnectionEditPart editPart, EClass dependencyType, PreferencesHint preferencesHint) {
        super(CustomMessages.ChangeDependencyTypeCommand_command_label);
        this.dependencyType = dependencyType;
        this.editPart = editPart;
        this.add(this.getDeleteViewCommand());
        this.createViewRequest = this.getCreateViewRequest(preferencesHint);
        this.add(this.getCreateViewCommand());
    }

    public CreateConnectionViewRequest.ConnectionViewDescriptor getElementDescriptor() {
        Object newObject = this.createViewRequest.getNewObject();
        if (!(newObject instanceof CreateConnectionViewAndElementRequest.ConnectionViewAndElementDescriptor)) {
            return null;
        }
        return (CreateConnectionViewAndElementRequest.ConnectionViewAndElementDescriptor)newObject;
    }

    private Command getDeleteViewCommand() {
        GroupRequest deleteViewRequest = new GroupRequest((Object)"delete");
        Command command = this.editPart.getCommand((Request)deleteViewRequest);
        return command != null ? command : UnexecutableCommand.INSTANCE;
    }

    private Command getCreateViewCommand() {
        if (this.createViewRequest == null) {
            return UnexecutableCommand.INSTANCE;
        }
        EditPart sourceEditPart = this.editPart.getSource();
        this.createViewRequest.setType((Object)"connection start");
        this.createViewRequest.setLocation(this.getSourceLocation(this.editPart));
        sourceEditPart.getCommand((Request)this.createViewRequest);
        EditPart targetEditPart = this.editPart.getTarget();
        this.createViewRequest.setType((Object)"connection end");
        this.createViewRequest.setLocation(this.getTargetLocation(this.editPart));
        Command createViewCommand = targetEditPart.getCommand((Request)this.createViewRequest);
        if (createViewCommand == null) {
            return UnexecutableCommand.INSTANCE;
        }
        this.processSetBendPointsCommand((CreateConnectionRequest)this.createViewRequest);
        return createViewCommand;
    }

    private CreateConnectionViewAndElementRequest getCreateViewRequest(PreferencesHint preferencesHint) {
        View view = (View)this.editPart.getModel();
        if (view == null) {
            return null;
        }
        CreateConnectionViewAndElementRequest.ConnectionViewAndElementDescriptor viewDescriptor = this.getConnectionViewDescriptor(preferencesHint);
        CreateConnectionViewAndElementRequest createViewRequest = new CreateConnectionViewAndElementRequest(viewDescriptor);
        createViewRequest.setSourceEditPart(this.editPart.getSource());
        createViewRequest.setTargetEditPart(this.editPart.getTarget());
        return createViewRequest;
    }

    private CreateConnectionViewAndElementRequest.ConnectionViewAndElementDescriptor getConnectionViewDescriptor(PreferencesHint preferencesHint) {
        String semanticHint = String.valueOf(4002);
        CreateRelationshipRequest createElementRequest = new CreateRelationshipRequest(UMLElementTypes.Dependency_4002);
        createElementRequest.setSource(((View)this.editPart.getSource().getModel()).getElement());
        createElementRequest.setTarget(((View)this.editPart.getTarget().getModel()).getElement());
        createElementRequest.setParameter(DependencyEditHelper.PARAMETER_DEPENDENCY_TYPE, (Object)this.dependencyType);
        String name = ((Dependency)((View)this.editPart.getModel()).getElement()).getName();
        createElementRequest.setParameter(DependencyEditHelper.PARAMETER_DEPENDENCY_NAME, (Object)name);
        CreateConnectionViewAndElementRequest.ConnectionViewAndElementDescriptor viewDescriptor = new CreateConnectionViewAndElementRequest.ConnectionViewAndElementDescriptor(new CreateElementRequestAdapter((CreateElementRequest)createElementRequest), semanticHint, preferencesHint);
        return viewDescriptor;
    }

    private Point getSourceLocation(ConnectionEditPart editPart) {
        return editPart.getConnectionFigure().getSourceAnchor().getReferencePoint();
    }

    private Point getTargetLocation(ConnectionEditPart editPart) {
        return editPart.getConnectionFigure().getTargetAnchor().getReferencePoint();
    }

    private void processSetBendPointsCommand(CreateConnectionRequest createConnectionRequest) {
        ConnectionAnchor sourceAnchor = this.editPart.getConnectionFigure().getSourceAnchor();
        ConnectionAnchor targetAnchor = this.editPart.getConnectionFigure().getTargetAnchor();
        if (sourceAnchor == null) {
            return;
        }
        Point sourceRefPoint = sourceAnchor.getReferencePoint().getCopy();
        sourceAnchor.getOwner().translateToRelative((Translatable)sourceRefPoint);
        if (targetAnchor == null) {
            return;
        }
        Point targetRefPoint = targetAnchor.getReferencePoint().getCopy();
        targetAnchor.getOwner().translateToRelative((Translatable)targetRefPoint);
        PointList newPointList = this.editPart.getConnectionFigure().getPoints().getCopy();
        SetConnectionBendpointsCommand setConnectionBendpointsCommand = this.getSetConnectionBendpointsCommand(createConnectionRequest);
        if (setConnectionBendpointsCommand != null) {
            setConnectionBendpointsCommand.setNewPointList(newPointList, sourceRefPoint, targetRefPoint);
        }
    }

    private SetConnectionBendpointsCommand getSetConnectionBendpointsCommand(CreateConnectionRequest createConnectionRequest) {
        ICommandProxy proxy = (ICommandProxy)createConnectionRequest.getStartCommand();
        CompositeCommand cc = (CompositeCommand)proxy.getICommand();
        for (Object next : cc) {
            if (!(next instanceof SetConnectionBendpointsCommand)) continue;
            return (SetConnectionBendpointsCommand)next;
        }
        return null;
    }
}

