/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.clazz.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.uml2.diagram.clazz.edit.policies.UMLBaseItemSemanticEditPolicy;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.ValueSpecification;

public class AssociationInstanceReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject oldEnd;
    private final EObject newEnd;

    public AssociationInstanceReorientCommand(ReorientRelationshipRequest request) {
        super(request.getLabel(), request.getRelationship(), (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.getElementToEdit() instanceof Slot)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        if (!(this.oldEnd instanceof InstanceSpecification) || !(this.newEnd instanceof InstanceSpecification)) {
            return false;
        }
        InstanceSpecification target = this.getLink().getOwningInstance();
        if (!(this.getLink().eContainer() instanceof InstanceSpecification)) {
            return false;
        }
        InstanceSpecification container = (InstanceSpecification)this.getLink().eContainer();
        return UMLBaseItemSemanticEditPolicy.LinkConstraints.canExistSlot_4015(container, this.getNewSource(), target);
    }

    protected boolean canReorientTarget() {
        if (!(this.oldEnd instanceof InstanceSpecification) || !(this.newEnd instanceof InstanceSpecification)) {
            return false;
        }
        InstanceSpecification source = this.getLink().getOwningInstance();
        if (!(this.getLink().eContainer() instanceof InstanceSpecification)) {
            return false;
        }
        InstanceSpecification container = (InstanceSpecification)this.getLink().eContainer();
        return UMLBaseItemSemanticEditPolicy.LinkConstraints.canExistSlot_4015(container, source, this.getNewTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        this.getLink().setOwningInstance(this.getNewSource());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        Slot slot = this.getLink();
        InstanceValue valueForOldTarget = null;
        for (ValueSpecification next : slot.getValues()) {
            if (!(next instanceof InstanceValue)) continue;
            InstanceValue nextValue = (InstanceValue)next;
            if (!this.getOldTarget().equals(nextValue.getInstance())) continue;
            valueForOldTarget = nextValue;
            break;
        }
        if (valueForOldTarget == null) {
            valueForOldTarget = UMLFactory.eINSTANCE.createInstanceValue();
            slot.getValues().add((Object)valueForOldTarget);
        }
        valueForOldTarget.setInstance(this.getNewTarget());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected Slot getLink() {
        return (Slot)this.getElementToEdit();
    }

    protected InstanceSpecification getOldSource() {
        return (InstanceSpecification)this.oldEnd;
    }

    protected InstanceSpecification getNewSource() {
        return (InstanceSpecification)this.newEnd;
    }

    protected InstanceSpecification getOldTarget() {
        return (InstanceSpecification)this.oldEnd;
    }

    protected InstanceSpecification getNewTarget() {
        return (InstanceSpecification)this.newEnd;
    }
}

